/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.ontologymanager;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.ClueManager;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.internal.ontology.api.OntologyManager;
import com.ibm.smarts.ontology.exceptions.InitializationException;
import com.ibm.smarts.ontology.ontologymanager.OWLOntologyImpl;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.ontology.util.LRUCache;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.apache.commons.validator.routines.UrlValidator;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOWLOntologyManagerImpl
implements OntologyManager<OWLOntology> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOWLOntologyManagerImpl.class);
    protected static OWLOntologyManager owlOntologyManager = null;
    protected final LRUCache<String, Ontology<OWLOntology>> ontologyRepo = new LRUCache(10);
    protected final ClueManager<OWLOntology> clueManager;
    protected final Properties config;
    protected boolean isInitialized = false;

    protected AbstractOWLOntologyManagerImpl(Properties config) {
        this(config, null);
    }

    protected AbstractOWLOntologyManagerImpl(Properties initConfig, ClueManager<OWLOntology> clueMgr) {
        this.clueManager = clueMgr;
        this.config = initConfig;
        if (owlOntologyManager == null) {
            owlOntologyManager = OWLManager.createOWLOntologyManager();
        }
    }

    abstract String getResourceLoc(Properties var1);

    public void distroy() {
        if (owlOntologyManager != null) {
            owlOntologyManager.getOntologyStorers().clear();
        }
        owlOntologyManager = null;
        this.ontologyRepo.dispose();
        this.isInitialized = false;
        LOGGER.info("destroyed AbstractOWLOntologyManagerImpl");
    }

    public void initialize(RequestContext reqCtx) {
        try {
            Properties props = KnowledgeDiscoveryHelper.loadProperties(this.getResourceLoc(this.config));
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, path) -> {
                try {
                    UrlValidator urlValidator = new UrlValidator();
                    OWLOntology ontology = urlValidator.isValid((String)path) ? this.getOWLOntologyManager().loadOntology(IRI.create((String)((String)path))) : this.getOWLOntologyManager().loadOntologyFromOntologyDocument(KnowledgeDiscoveryHelper.loadFromClasspath((String)path));
                    OWLOntologyImpl onto = new OWLOntologyImpl(ontology);
                    this.ontologyRepo.put(onto.getOntologyID(), onto);
                    this.additionalInit(ontology, reqCtx);
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
                    throw new InitializationException(ex);
                }
            }));
            this.isInitialized = true;
        }
        catch (IOException ex) {
            LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
            throw new InitializationException(ex);
        }
    }

    protected abstract void additionalInit(OWLOntology var1, RequestContext var2) throws Exception;

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return owlOntologyManager;
    }

    public List<Ontology<OWLOntology>> getOntologies() {
        return this.ontologyRepo.getAll();
    }

    public List<Ontology<OWLOntology>> getOntologies(String tenant) {
        return null;
    }

    public Ontology<OWLOntology> getOntology(@Nonnull String ontologyID) {
        return this.ontologyRepo.get(ontologyID);
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.getOWLOntologyManager().getOWLDataFactory();
    }
}

