/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.reasoner;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.reasoner.ClassesEvaluator;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.ObjectFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationOntologyReasoner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationOntologyReasoner.class);

    public static Set<OWLClass> getTypes(OWLOntology ontology, Map<IRI, List<OWLLiteral>> dataProperties, List<String> samples, RequestContext currentReqCtx) {
        ClassesEvaluator v = new ClassesEvaluator(ontology, dataProperties, samples, currentReqCtx);
        Set axioms = ontology.getAxioms(AxiomType.EQUIVALENT_CLASSES);
        return axioms.stream().filter(a -> ApplicationOntologyReasoner.evaluateAxiom(a, v) > 0.0f).map(a -> ((OWLClassExpression)a.getClassExpressionsAsList().get(0)).asOWLClass()).collect(Collectors.toSet());
    }

    public static Set<ConceptInfo> getConcepts(OWLOntology ontology, Map<IRI, List<OWLLiteral>> dataProperties, List<String> samples, ObjectFactory objFactory, RequestContext currentReqCtx) {
        ClassesEvaluator v = new ClassesEvaluator(ontology, dataProperties, samples, currentReqCtx);
        Set axioms = ontology.getAxioms(AxiomType.EQUIVALENT_CLASSES);
        HashSet<ConceptInfo> concepts = new HashSet<ConceptInfo>();
        axioms.stream().forEach(a -> {
            float score = ApplicationOntologyReasoner.evaluateAxiom(a, v);
            if (Float.compare(score, 0.0f) > 0) {
                ConceptInfo concept = objFactory.createConceptInfo();
                IRI conceptID = ((OWLClassExpression)a.getClassExpressionsAsList().get(0)).asOWLClass().getIRI();
                concept.setConceptID(conceptID.toString());
                concept.setConfidence(score);
                concepts.add(concept);
            }
        });
        return concepts;
    }

    private static float evaluateAxiom(OWLEquivalentClassesAxiom a, ClassesEvaluator v) {
        OWLClassExpression c = (OWLClassExpression)a.getClassExpressionsAsList().get(1);
        float result = ((Float)c.accept((OWLClassExpressionVisitorEx)v)).floatValue();
        LOGGER.info("{} = {}", (Object)Float.valueOf(result), (Object)a);
        return result;
    }
}

