/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.reasoner;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;

public class ClassCollector {
    public static Set<OWLClass> collectClassesHasObjectPropertyWithFillerInSignature(OWLObjectProperty property, OWLClass filler, OWLOntology ontology, OWLReasoner reasoner, boolean includeSubs) {
        Set<OWLClass> entities = ontology.filterAxioms((OWLAxiomSearchFilter)new SubClassOfObjectPropertyWithFiller(AxiomType.SUBCLASS_OF, property, reasoner), (Object)filler, Imports.INCLUDED).stream().map(a -> ((OWLSubClassOfAxiom)a).getSubClass().asOWLClass()).collect(Collectors.toSet());
        if (includeSubs) {
            HashSet<OWLClass> EntitiesAndSubs = new HashSet<OWLClass>(entities);
            EntitiesAndSubs.addAll(entities.stream().flatMap(c -> reasoner.getSubClasses((OWLClassExpression)c, false).getFlattened().stream()).collect(Collectors.toSet()));
            return EntitiesAndSubs;
        }
        Set supers = entities.stream().flatMap(e -> reasoner.getSuperClasses((OWLClassExpression)e, false).getFlattened().stream()).collect(Collectors.toSet());
        entities.removeAll(supers);
        return entities;
    }

    public static Set<OWLClass> collectClassesFromSignature(OWLObject classSignature, String domain) {
        ClassOfDomain v = new ClassOfDomain(domain);
        classSignature.accept((OWLObjectVisitor)v);
        return v.getCollectedClasses();
    }

    static class ClassOfDomain
    extends OWLObjectVisitorAdapter {
        private String m_domain;
        private Set<OWLClass> m_collectedClasses;

        public Set<OWLClass> getCollectedClasses() {
            return this.m_collectedClasses;
        }

        ClassOfDomain(String domain) {
            this.m_domain = domain;
            this.m_collectedClasses = new HashSet<OWLClass>();
        }

        public void visit(OWLClass ce) {
            if (ce.getIRI().getNamespace().equals(this.m_domain)) {
                this.m_collectedClasses.add(ce);
            }
        }

        public void visit(OWLObjectIntersectionOf ce) {
            ce.getOperandsAsList().stream().forEach(p -> p.accept((OWLObjectVisitor)this));
        }

        public void visit(OWLObjectUnionOf ce) {
            ce.getOperandsAsList().stream().forEach(p -> p.accept((OWLObjectVisitor)this));
        }

        public void visit(OWLObjectComplementOf ce) {
            ce.getOperand().accept((OWLObjectVisitor)this);
        }

        public void visit(OWLObjectSomeValuesFrom ce) {
            ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        }

        public void visit(OWLObjectAllValuesFrom ce) {
            ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        }

        public void visit(OWLObjectMinCardinality ce) {
            ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        }
    }

    static class SubClassOfObjectPropertyWithFiller
    extends Filters.AxiomFilter<OWLSubClassOfAxiom> {
        private static final long serialVersionUID = 40000L;
        private OWLObjectProperty m_objProperty = null;
        private OWLReasoner m_reasoner;

        SubClassOfObjectPropertyWithFiller(AxiomType<?> type, OWLObjectProperty property, OWLReasoner reasoner) {
            super(type);
            this.m_objProperty = property;
            this.m_reasoner = reasoner;
        }

        public boolean pass(OWLAxiom axiom, Object key) {
            OWLClassExpression superClass = (OWLClassExpression)this.axiomValue((OWLSubClassOfAxiom)axiom);
            if (superClass.containsEntityInSignature((OWLEntity)this.m_objProperty)) {
                if (superClass.containsEntityInSignature((OWLEntity)key)) {
                    return true;
                }
                OWLQuantifiedObjectRestriction s = (OWLQuantifiedObjectRestriction)superClass;
                return this.m_reasoner.getSubClasses((OWLClassExpression)s.getFiller(), false).getFlattened().contains(key);
            }
            return false;
        }

        @Nonnull
        protected Object axiomValue(@Nonnull OWLSubClassOfAxiom axiom) {
            return axiom.getSuperClass();
        }
    }
}

