/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.reasoner;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.ontology.reasoner.DataEvaluator;
import com.ibm.smarts.ontology.reasoner.ExistentialRestrictionCollector;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.ConceptInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class DataHintEvaluator
extends OWLObjectVisitorExAdapter<Float> {
    private static final String APPLICATI_ONONTOLOGY_IRI = "http://www.ibm.com/ontologies/waca/application";
    private static final String DOMAIN_COMMON_ONONTOLOGY_IRI = "http://www.ibm.com/ontologies/waca/domain/common";
    private static final IRI HAS_REGEX_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasRegex");
    private static final IRI DATA_VALUE_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#dataValue");
    private static final IRI HAS_PATTERN_PROPERTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasPattern");
    public static final IRI HAS_DATA_INSTANCE_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/application#hasDataInstance");
    private static final int MINIMUM_THRESHOLD = 3;
    private Map<IRI, List<ConceptInfo>> m_objectPropertyValues = null;
    private Map<IRI, List<OWLLiteral>> m_dataPropertyValues = null;
    private List<String> m_samples = null;
    private OWLOntology m_ontology = null;
    private OWLReasoner m_reasoner = null;
    private RequestContext m_currentReqCxt = null;
    private static final String CityInstance = "http://www.ibm.com/ontologies/waca/domain/common#City";
    private static final String StateProvinceInstance = "http://www.ibm.com/ontologies/waca/domain/common#StateProvince";
    private static final String CountryInstance = "http://www.ibm.com/ontologies/waca/domain/common#Country";

    public DataHintEvaluator(OWLOntology ontology, OWLReasoner reasoner, Map<IRI, List<ConceptInfo>> objectPropertyValues, Map<IRI, List<OWLLiteral>> dataPropertyValues, List<String> samples, RequestContext reqContext) {
        super((Object)Float.valueOf(0.0f));
        this.m_objectPropertyValues = objectPropertyValues;
        this.m_dataPropertyValues = dataPropertyValues;
        this.m_samples = samples;
        this.m_ontology = ontology;
        this.m_reasoner = reasoner;
        this.m_currentReqCxt = reqContext;
    }

    public static Optional<String> matchIndividual(String value, RequestContext ctx) {
        return KnowledgeDiscoveryHelper.getClueManager(ctx).lookupIndividuals(ctx, new String[]{value}).stream().findFirst();
    }

    public static Map<String, Float> matchIndividuals(RequestContext ctx, List<String> samples) {
        Map matches = KnowledgeDiscoveryHelper.getClueManager(ctx).lookupIndividuals(ctx, samples.toArray(new String[0])).stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        return matches.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Float.valueOf((float)((Long)e.getValue()).longValue() * 1.0f / (float)samples.size())));
    }

    public static Map<String, Long> matchIndividualsCounts(RequestContext ctx, List<String> samples) {
        return KnowledgeDiscoveryHelper.getClueManager(ctx).lookupIndividuals(ctx, samples.toArray(new String[0])).stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    public static boolean matchIndividual(String value, IRI individual, RequestContext ctx) {
        String key = individual.toString();
        if (key.equals(CityInstance) || key.equals(CountryInstance) || key.equals(StateProvinceInstance)) {
            return true;
        }
        return KnowledgeDiscoveryHelper.getClueManager(ctx).matchDataClue(value, individual.toString(), ctx);
    }

    private float evaluateHasPattern(OWLQuantifiedObjectRestriction ce) {
        return ((Float)((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitorEx)this)).floatValue();
    }

    private float evaluateOWLQuantifiedObjectRestriction(OWLQuantifiedObjectRestriction ce, int threshold) {
        IRI property = ce.getProperty().asOWLObjectProperty().getIRI();
        if (property.equals((Object)HAS_DATA_INSTANCE_IRI)) {
            return DataHintEvaluator.evaluateHasDataInstance(ce, threshold, this.m_samples, this.m_ontology, this.m_currentReqCxt) / (float)threshold;
        }
        if (property.equals((Object)HAS_PATTERN_PROPERTY_IRI)) {
            return this.evaluateHasPattern(ce);
        }
        return 0.0f;
    }

    public static Stream<Pattern> getRegularExpressions(OWLObject instance, OWLOntology ontology) {
        Set properties = ontology.getAxioms(OWLDataPropertyAssertionAxiom.class, OWLIndividual.class, instance, Imports.INCLUDED, Navigation.IN_SUB_POSITION);
        return properties.stream().filter(p -> ((OWLDataPropertyExpression)p.getProperty()).asOWLDataProperty().getIRI().equals((Object)DATA_VALUE_PROPERTY_IRI)).map(reg -> ((OWLLiteral)((OWLLiteral)reg.getObject()).asLiteral().get()).getLiteral()).map(Pattern::compile);
    }

    public static float evaluateHasDataInstance(OWLQuantifiedObjectRestriction ce, long threshold, List<String> samples, OWLOntology ontology, RequestContext currentReqCtx) {
        List<String> nonNullSamples = samples.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (nonNullSamples.isEmpty()) {
            return 3.0f;
        }
        ExistentialRestrictionCollector hasRegexRestrictionVisitor = new ExistentialRestrictionCollector(Collections.singleton(ontology), Collections.singletonList(HAS_REGEX_IRI), false);
        ((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitor)hasRegexRestrictionVisitor);
        if (!hasRegexRestrictionVisitor.getRestrictedProperties().isEmpty()) {
            Set<OWLObject> instances = hasRegexRestrictionVisitor.getRestrictedProperties();
            return instances.stream().flatMap(i -> DataHintEvaluator.getRegularExpressions(i, ontology)).map(p -> {
                int n = 0;
                for (String s : nonNullSamples) {
                    if (p.matcher(s).matches()) {
                        ++n;
                    }
                    if ((long)n < threshold) continue;
                    return n;
                }
                return n;
            }).reduce(Integer::sum).orElse(0).intValue();
        }
        IRI instanceClassIRI = ((OWLClassExpression)ce.getFiller()).asOWLClass().getIRI();
        String key = instanceClassIRI.toString();
        if (key.equals(CityInstance) || key.equals(CountryInstance) || key.equals(StateProvinceInstance)) {
            return Math.min((long)nonNullSamples.size(), threshold);
        }
        Map<String, Long> matches = DataHintEvaluator.matchIndividualsCounts(currentReqCtx, nonNullSamples);
        return Math.min(matches.getOrDefault(key, 0L), threshold);
    }

    public static float evaluateHasDataInstance(OWLObjectHasValue ce, IntFunction<Boolean> accumulator, List<String> samples, OWLOntology ontology) {
        List nonNullSamples = samples.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (nonNullSamples.isEmpty()) {
            return 0.0f;
        }
        if (ce.getProperty().asOWLObjectProperty().getIRI().equals((Object)HAS_REGEX_IRI)) {
            Set<OWLObject> instances = Collections.singleton(ce.getFiller());
            return instances.stream().flatMap(i -> DataHintEvaluator.getRegularExpressions(i, ontology)).map(p -> {
                int n = 0;
                for (String s : nonNullSamples) {
                    if (p.matcher(s).matches()) {
                        ++n;
                    }
                    if (!((Boolean)accumulator.apply(n)).booleanValue()) continue;
                    return n;
                }
                return n;
            }).reduce(Integer::sum).orElse(0).intValue();
        }
        IRI instanceClassIRI = ((OWLIndividual)ce.getFiller()).asOWLNamedIndividual().getIRI();
        int n = 0;
        for (String s : nonNullSamples) {
            if (DataHintEvaluator.matchIndividual(s, instanceClassIRI, null)) {
                ++n;
            }
            if (!accumulator.apply(n).booleanValue()) continue;
            return n;
        }
        return n;
    }

    public Float visit(OWLClass ce) {
        Optional<ConceptInfo> concept = this.m_objectPropertyValues.values().stream().flatMap(Collection::stream).filter(c -> c.getConceptID().equals(ce.getIRI().toString())).findFirst();
        if (concept.isPresent()) {
            return Float.valueOf(concept.get().getConfidence());
        }
        OWLDataFactory factory = this.m_ontology.getOWLOntologyManager().getOWLDataFactory();
        concept = this.m_objectPropertyValues.values().stream().flatMap(Collection::stream).filter(c -> !c.getConceptID().startsWith(APPLICATI_ONONTOLOGY_IRI)).filter(c -> this.m_reasoner.getSuperClasses((OWLClassExpression)factory.getOWLClass(IRI.create((String)c.getConceptID())), false).getFlattened().contains(ce)).findFirst();
        if (concept.isPresent()) {
            return Float.valueOf(concept.get().getConfidence());
        }
        return Float.valueOf(0.0f);
    }

    public Float visit(OWLObjectIntersectionOf ce) {
        return ce.getOperandsAsList().stream().map(p -> (Float)p.accept((OWLObjectVisitorEx)this)).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue()));
    }

    public Float visit(OWLObjectUnionOf ce) {
        return ce.getOperandsAsList().stream().map(p -> (Float)p.accept((OWLObjectVisitorEx)this)).reduce(Float.valueOf(0.0f), (a, b) -> Float.valueOf(Float.compare(a.floatValue() + b.floatValue(), 1.0f) > 0 ? 1.0f : a.floatValue() + b.floatValue()));
    }

    public Float visit(OWLObjectComplementOf ce) {
        return Float.valueOf(((Float)ce.getOperand().accept((OWLObjectVisitorEx)this)).floatValue() > 0.0f ? 0.0f : 1.0f);
    }

    public Float visit(OWLObjectSomeValuesFrom ce) {
        return Float.valueOf(this.evaluateOWLQuantifiedObjectRestriction((OWLQuantifiedObjectRestriction)ce, 3));
    }

    public Float visit(OWLObjectAllValuesFrom ce) {
        return Float.valueOf(this.evaluateOWLQuantifiedObjectRestriction((OWLQuantifiedObjectRestriction)ce, this.m_samples.isEmpty() ? 1 : this.m_samples.size()));
    }

    public Float visit(OWLObjectMinCardinality ce) {
        return Float.valueOf(this.evaluateOWLQuantifiedObjectRestriction((OWLQuantifiedObjectRestriction)ce, ce.getCardinality()));
    }

    public Float visit(OWLObjectHasValue ce) {
        IntFunction<Boolean> f = i -> i >= 3;
        return Float.valueOf(DataHintEvaluator.evaluateHasDataInstance(ce, f, this.m_samples, this.m_ontology) / 3.0f);
    }

    public Float visit(OWLDataSomeValuesFrom ce) {
        List<OWLLiteral> values = this.m_dataPropertyValues.get(ce.getProperty().asOWLDataProperty().getIRI());
        if (values == null) {
            return Float.valueOf(0.0f);
        }
        DataEvaluator dataRangeEvaluator = new DataEvaluator(values, ce.getProperty().asOWLDataProperty().getIRI());
        return (Float)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)dataRangeEvaluator);
    }

    public Float visit(OWLDataHasValue ce) {
        List<OWLLiteral> values = this.m_dataPropertyValues.get(ce.getProperty().asOWLDataProperty().getIRI());
        if (values == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(values.stream().anyMatch(v -> ((OWLLiteral)ce.getFiller()).equals(v)) ? 1.0f : 0.0f);
    }

    public Float visit(OWLDataAllValuesFrom ce) {
        List<OWLLiteral> values = this.m_dataPropertyValues.get(ce.getProperty().asOWLDataProperty().getIRI());
        if (values == null) {
            return Float.valueOf(0.0f);
        }
        DataEvaluator dataRangeEvaluator = new DataEvaluator(values, ce.getProperty().asOWLDataProperty().getIRI());
        return (Float)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)dataRangeEvaluator);
    }
}

