/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.smarts.model.datatype.BaseDataType;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueDeserializer;
import com.ibm.smarts.model.value.ValueSerializer;
import com.ibm.smarts.model.value.ValueStatus;
import java.math.BigDecimal;
import java.util.Date;

@JsonTypeName(value="float")
@JsonDeserialize(using=ValueDeserializer.class)
@JsonSerialize(using=ValueSerializer.class)
public class FloatValue
extends Value {
    @JsonProperty(value="floatValue")
    private float value;

    public FloatValue() {
        this.setStatus(ValueStatus.NULL);
    }

    public FloatValue(float value, ValueStatus status) {
        this.set(value, status);
    }

    public FloatValue(float value) {
        this.set(value);
    }

    @JsonGetter(value="floatValue")
    public float getValue() {
        return this.value;
    }

    @Override
    public DataType getType() {
        return DataTypes.getFloatType();
    }

    public void set(float value, ValueStatus status) {
        this.value = value;
        this.setStatus(status);
    }

    public void set(float value) {
        this.set(value, ValueStatus.OK);
    }

    public void set(Float value) {
        if (null == value) {
            this.set(0.0f, ValueStatus.NULL);
        } else {
            this.set(value.floatValue(), ValueStatus.OK);
        }
    }

    public Object objectValue() {
        if (this.isNull()) {
            return null;
        }
        return Float.valueOf(this.value);
    }

    @Override
    public String stringValue() {
        if (this.isNull()) {
            return null;
        }
        return Float.toString(this.value);
    }

    @Override
    public float floatValue() {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public double doubleValue() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK() || Float.isInfinite(this.value) || Float.isNaN(this.value)) {
            return null;
        }
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public short shortValue() {
        if (!this.isOK()) {
            return 0;
        }
        return (short)this.value;
    }

    @Override
    public byte byteValue() {
        if (!this.isOK()) {
            return 0;
        }
        return (byte)this.value;
    }

    @Override
    public int intValue() {
        if (!this.isOK()) {
            return 0;
        }
        return (int)this.value;
    }

    @Override
    public long longValue() {
        if (!this.isOK()) {
            return 0L;
        }
        return (long)this.value;
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        return new Date(this.longValue());
    }

    @Override
    public boolean booleanValue() {
        if (!this.isOK()) {
            return false;
        }
        return 0.0f != this.value;
    }

    @Override
    public int hashCode() {
        return this.getStatus().hashCode() + Float.floatToIntBits(this.value);
    }

    @Override
    public int compareTo(Value other) {
        float rightValue;
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.FLOAT) {
            return FloatValue.compareValue(this, other);
        }
        int c = FloatValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        float leftValue = this.floatValue();
        if (leftValue < (rightValue = other.floatValue())) {
            return -1;
        }
        if (leftValue > rightValue) {
            return 1;
        }
        return 0;
    }

    @Override
    public void assignFrom(Value value) {
        if (null == value || ValueStatus.NULL == value.getStatus()) {
            this.set(0.0f, ValueStatus.NULL);
        } else {
            this.set(value.floatValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(0.0f, ValueStatus.NULL);
        } else {
            try {
                this.set(Float.parseFloat(value), ValueStatus.OK);
            }
            catch (NumberFormatException ex) {
                this.setError();
            }
        }
    }

    @Override
    public Number numberValue() {
        if (this.isOK()) {
            return Float.valueOf(this.floatValue());
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FloatValue that = (FloatValue)o;
        return Float.compare(that.value, this.value) == 0;
    }
}

