/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.model.value.ValueDeserializer;
import com.ibm.smarts.model.value.ValueSerializer;
import com.ibm.smarts.model.value.ValueStatus;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonDeserialize(using=ValueDeserializer.class)
@JsonSerialize(using=ValueSerializer.class)
public abstract class Value
implements Comparable<Value>,
Cloneable {
    protected static final String TYPE_DELIMITER = "::";
    protected static final Date DELINQUENT_DATE = new Date(0L);
    private ValueStatus status = ValueStatus.NULL;

    @JsonIgnore
    public abstract DataType getType();

    public abstract void assignFrom(Value var1);

    public abstract void assignFrom(String var1);

    public abstract Number numberValue();

    public abstract String stringValue();

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract BigDecimal bigDecimalValue();

    public abstract byte byteValue();

    public abstract short shortValue();

    public abstract int intValue();

    public abstract long longValue();

    public abstract Date dateValue();

    public abstract boolean booleanValue();

    public final ValueStatus getStatus() {
        return this.status;
    }

    public void setStatus(ValueStatus status) {
        this.status = status;
    }

    public void setOK() {
        this.setStatus(ValueStatus.OK);
    }

    public void setNull() {
        this.setStatus(ValueStatus.NULL);
    }

    public void setDivByZero() {
        this.setStatus(ValueStatus.DIVBYZERO);
    }

    public void setError() {
        this.setStatus(ValueStatus.ERROR);
    }

    @JsonIgnore
    public boolean isDivByZero() {
        return ValueStatus.DIVBYZERO == this.status;
    }

    @JsonIgnore
    public boolean isNull() {
        return ValueStatus.NULL == this.status;
    }

    @JsonIgnore
    public boolean isError() {
        return ValueStatus.ERROR == this.status;
    }

    @JsonIgnore
    public boolean isOK() {
        return ValueStatus.OK == this.status;
    }

    public String toString() {
        if (this.isNull()) {
            return "#null#";
        }
        if (this.isError()) {
            return "#error#";
        }
        if (this.isDivByZero()) {
            return "#divbyzero#";
        }
        return this.getType().toString() + TYPE_DELIMITER + this.stringValue();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        return 0 == this.compareTo((Value)o);
    }

    public Object clone() {
        Value clone = this.getType().newValue();
        clone.assignFrom(this);
        return clone;
    }

    public static int compareValue(Value left, Value right) {
        int c = Value.compareStatus(left.getStatus(), right.getStatus());
        if (c != 0) {
            return c;
        }
        DataType commonType = DataTypes.widestCompatibleType(left.getType(), right.getType());
        Value coercedLeft = commonType.newValue();
        Value coercedRight = commonType.newValue();
        coercedLeft.assignFrom(left);
        coercedRight.assignFrom(right);
        return coercedLeft.compareTo(coercedRight);
    }

    protected static int compareStatus(ValueStatus left, ValueStatus right) {
        int rightOrd;
        int leftOrd = left.ordinal();
        if (leftOrd == (rightOrd = right.ordinal())) {
            return 0;
        }
        if (leftOrd < rightOrd) {
            return -1;
        }
        return 1;
    }
}

