/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.recommendationmodel;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.ibm.bi.recommendationmodel.Chart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecommendationModel {
    private static final Logger log = LoggerFactory.getLogger(RecommendationModel.class);
    private Map<String, Chart> chartMappings;

    public RecommendationModel() {
        this.chartMappings = new HashMap<String, Chart>();
    }

    protected RecommendationModel(RecommendationModel recommendationModel, double freqWeight) {
        this.chartMappings = new HashMap<String, Chart>(recommendationModel.getCharts().size());
        for (Chart recModelChart : recommendationModel.getCharts()) {
            Chart newChart = new Chart(recModelChart, freqWeight);
            this.chartMappings.put(newChart.getName(), newChart);
        }
    }

    public Chart putIfAbsentAndReturn(String chartName) {
        Chart chart = new Chart(chartName);
        this.chartMappings.putIfAbsent(chartName, chart);
        return this.chartMappings.get(chartName);
    }

    @JsonGetter
    public Collection<Chart> getCharts() {
        return this.chartMappings.values();
    }

    @JsonSetter(value="charts")
    protected void setChartMappings(ArrayList<Chart> charts) {
        for (Chart chart : charts) {
            this.chartMappings.putIfAbsent(chart.getName(), chart);
        }
    }

    private Map<String, Chart> getChartMappings() {
        return this.chartMappings;
    }

    public static RecommendationModel aggregateRecModel(RecommendationModel offlineRecModel, RecommendationModel onlineRecModel) {
        boolean isOfflineModelEmpty;
        long startTime = System.currentTimeMillis();
        boolean isOnlineModelEmpty = onlineRecModel.getChartMappings() == null || onlineRecModel.getChartMappings().isEmpty();
        boolean bl = isOfflineModelEmpty = offlineRecModel.getChartMappings() == null || offlineRecModel.getChartMappings().isEmpty();
        if (isOfflineModelEmpty && !isOnlineModelEmpty) {
            return onlineRecModel;
        }
        if (!isOfflineModelEmpty && isOnlineModelEmpty) {
            return offlineRecModel;
        }
        RecommendationModel onlineRecModelWithWeight = new RecommendationModel(onlineRecModel, 0.7);
        RecommendationModel offlineRecModelWithWeight = new RecommendationModel(offlineRecModel, 0.3);
        Map<String, Chart> onlineChartMappings = onlineRecModelWithWeight.getChartMappings();
        Map<String, Chart> offlineChartMappings = offlineRecModelWithWeight.getChartMappings();
        for (Map.Entry<String, Chart> onlineModelEntry : onlineChartMappings.entrySet()) {
            Chart onlineModelChart = onlineModelEntry.getValue();
            String onlineModelChartName = onlineModelEntry.getKey();
            if (offlineChartMappings.containsKey(onlineModelChartName)) {
                Chart offlineModelChart = offlineChartMappings.get(onlineModelChartName);
                offlineModelChart.merge(onlineModelChart);
                continue;
            }
            offlineChartMappings.put(onlineModelChartName, onlineModelChart);
        }
        log.info("Aggregating the model took: " + (System.currentTimeMillis() - startTime) + " ms");
        return offlineRecModelWithWeight;
    }
}

