/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder;

import com.ibm.smarts.common.pipeline.SampleQueryContext;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.common.provider.IDataProviderModuleInfo;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.SamplingInfo;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.smartsmodule.builder.exceptions.SmartsBuilderException;
import com.ibm.smarts.store.api.TypeNames;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.provider.IPersistenceProvider;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;

public class SmartsModuleBuilderSettings {
    private static final int DEFAULT_STATUS_PUBLISHING_BATCH_SIZE = 5;
    private RequestContext requestContext;
    private SmartsModuleOptions smartsModuleOptions;
    private SamplingInfo samplingInfo;
    private AnalysisScope analysisScope;
    private boolean isUpdate;
    private IStoreProvider storeProvider;
    private IDataProviderModuleInfo dataProviderModuleInfo;
    private String resourceUri;
    private ExecutorService executorService;
    private SmartNLP nlp;
    private IDataProvider dataProvider;
    private Properties systemConfig = new Properties();
    private Map<String, String> sortColumns;
    private boolean moduleHasOverwrites;
    private String masterSmartsModuleUri;
    private int statusPublishingBatchSize = 5;

    public SmartsModuleBuilderSettings(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public SmartsModuleBuilderSettings(SmartsModuleOptions smartsModuleOptions, SamplingInfo samplingInfo, AnalysisScope analysisScope, boolean isUpdate, RequestContext requestContext, IStoreProvider storeProvider, IDataProviderModuleInfo dataProviderModuleInfo, SmartNLP nlp, IDataProvider dataProvider, boolean moduleHasOverwrites) {
        this.samplingInfo = samplingInfo;
        this.smartsModuleOptions = smartsModuleOptions;
        this.analysisScope = analysisScope;
        this.requestContext = requestContext;
        this.isUpdate = isUpdate;
        this.dataProviderModuleInfo = dataProviderModuleInfo;
        this.storeProvider = storeProvider;
        this.nlp = nlp;
        this.dataProvider = dataProvider;
        this.moduleHasOverwrites = moduleHasOverwrites;
    }

    public AnalysisScope getAnalysisScope() {
        return this.analysisScope;
    }

    public SmartsModuleOptions getSmartsModuleOptions() {
        if (this.smartsModuleOptions == null) {
            this.smartsModuleOptions = SmartsModuleOptions.DEFAULT_CREATE_PATTERN;
        }
        return this.smartsModuleOptions;
    }

    public SamplingInfo getSamplingInfo() {
        return this.samplingInfo;
    }

    public IStoreProvider getStoreProvider() {
        return this.storeProvider;
    }

    public IDataProviderModuleInfo getDataProviderModuleInfo() {
        return this.dataProviderModuleInfo;
    }

    public IPersistenceProvider getPersistenceProvider() throws SmartsBuilderException {
        if (this.requestContext != null && this.storeProvider != null) {
            StoreConfig config = new StoreConfig(this.requestContext.locale, TypeNames.DDS);
            return this.storeProvider.getPersistenceProvider(config);
        }
        throw new SmartsBuilderException("Store Provider was not set in settings");
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    public boolean isPublishing() {
        return this.getPublishingURI() != null;
    }

    public boolean isOverwriting() {
        return !this.isUpdate() && this.isPublishing();
    }

    public boolean isDeepAnalysis() {
        return this.samplingInfo != null && (this.samplingInfo.getSampleTarget() != null && this.samplingInfo.getSampleTarget().getSampleSize() > 0 || this.samplingInfo.getSampleUriList() != null && !this.samplingInfo.getSampleUriList().isEmpty() || this.samplingInfo.getSampleDataList() != null && !this.samplingInfo.getSampleDataList().isEmpty());
    }

    public boolean isFeatureExtractionEnabled() {
        return Boolean.parseBoolean(this.systemConfig.getProperty("smarts.feature.extraction.enabled"));
    }

    public boolean isEmbeddingEnabled() {
        return Boolean.parseBoolean(this.systemConfig.getProperty("smarts.core.column.embedding"));
    }

    public boolean isQuestionGeneratorEnabled() {
        return Boolean.parseBoolean(this.systemConfig.getProperty("smarts.core.question.generator"));
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setSmartsModuleOptions(SmartsModuleOptions smartsModuleOptions) {
        this.smartsModuleOptions = smartsModuleOptions;
    }

    public void setAnalysisScope(AnalysisScope analysisScope) {
        this.analysisScope = analysisScope;
    }

    public void setUpdateSmartsModule(boolean updateSmartsModule) {
        this.isUpdate = updateSmartsModule;
    }

    public void setSamplingInfo(SamplingInfo samplingInfo) {
        this.samplingInfo = samplingInfo;
    }

    public void setStoreProvider(IStoreProvider storeProvider) {
        this.storeProvider = storeProvider;
    }

    public void setDataProviderModuleInfo(IDataProviderModuleInfo dataProviderModuleInfo) {
        this.dataProviderModuleInfo = dataProviderModuleInfo;
    }

    public void setPublishingURI(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    public String getPublishingURI() {
        return this.resourceUri;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setNLP(SmartNLP nlp) {
        this.nlp = nlp;
    }

    public SmartNLP getNLP() {
        return this.nlp;
    }

    public IDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(IDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public Properties getSystemConfig() {
        return this.systemConfig;
    }

    public void setSystemConfig(Properties systemConfig) {
        this.systemConfig = systemConfig;
    }

    public Map<String, String> getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(Map<String, String> sortColumns) {
        this.sortColumns = sortColumns;
    }

    public SampleQueryContext getSampleQueryContext() {
        if (this.getSamplingInfo() == null || this.getSamplingInfo().getSampleTarget() == null) {
            return null;
        }
        SampleQueryContext sampleContext = new SampleQueryContext(this.getSystemConfig().getProperty("smarts.ca.core.caServer.url"), this.getSamplingInfo().getSampleTarget().getAssetId(), Collections.emptyMap(), this.getSamplingInfo().getSampleTarget().getModuleType(), this.getSamplingInfo().getSampleTarget().getConnections(), this.getSamplingInfo().getSampleTarget().getSampleSeed(), this.getSamplingInfo().getSampleTarget().getSampleSize(), this.sortColumns);
        return sampleContext;
    }

    public void setModuleHasOverwrites(boolean moduleHasOverwrites) {
        this.moduleHasOverwrites = moduleHasOverwrites;
    }

    public boolean moduleHasOverwrites() {
        return this.moduleHasOverwrites;
    }

    public String getMasterSmartsModuleUri() {
        return this.masterSmartsModuleUri;
    }

    public void setMasterSmartsModuleUri(String masterSmartsModuleUri) {
        this.masterSmartsModuleUri = masterSmartsModuleUri;
    }

    public int getStatusPublishingBatchSize() {
        return this.statusPublishingBatchSize;
    }

    public void setStatusPublishingBatchSize(int statusPublishingBatchSize) {
        this.statusPublishingBatchSize = statusPublishingBatchSize;
    }
}

