/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.function;

import com.ibm.smarts.common.mq.SmartsModuleTask;
import com.ibm.smarts.common.mq.function.SmartsModuleFunction;
import com.ibm.smarts.common.mq.function.SmartsModuleTasks;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.core.mq.MessageQueueingSystem;
import com.ibm.smarts.dds.core.function.InitialPublishingFunction;
import com.ibm.smarts.dds.core.function.PredictFunction;
import com.ibm.smarts.dds.core.function.PublishingFunction;
import com.ibm.smarts.dds.core.function.SamplesFunction;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.Arrays;
import java.util.List;

public class DdsSmartsModuleTasks
extends SmartsModuleTasks {
    public static final String DDS_TASK_ID = "smarts.dds";
    public static final String INIT_PUBLISH_TASK_ID = "smarts.dds.initpublish";
    public static final String INIT_PUBLISH_TASK_NAME = "InitialPublish";
    public static final String INIT_PUBLISH_TASK_DESCRIPTION = "Initial Publish consumable SmartsModule parts into permanent SmartsModule storage.";
    public static final String SAMPLES_TASK_ID = "smarts.dds.samples";
    public static final String SAMPLES_TASK_NAME = "Samples";
    public static final String SAMPLES_TASK_DESCRIPTION = "Posts a message containing a sample of data for a dataset in the SmartsModule.";
    public static final String PREDICT_TASK_ID = "smarts.dds.predict";
    public static final String PREDICT_TASK_NAME = "Predict";
    public static final String PREDICT_TASK_DESCRIPTION = "Adds univariate and bivariate statistics to columns in the SmartsModule, based on sample data.";
    public static final String PUBLISH_TASK_ID = "smarts.dds.publish";
    public static final String PUBLISH_TASK_NAME = "Publish";
    public static final String PUBLISH_TASK_DESCRIPTION = "Publish consumable SmartsModule parts into permanent SmartsModule storage.";
    public static final String[] ALL_TASKS_FOR_REGISTRATION = new String[]{"smarts.dds.initpublish", "smarts.dds.samples", "smarts.dds.predict", "smarts.dds.publish"};
    private final IDataProvider dataProvider;

    public DdsSmartsModuleTasks(IStoreProvider storeProvider, IDataProvider dataProvider, MessageQueueingSystem messageSystem) {
        super(storeProvider, messageSystem);
        this.dataProvider = dataProvider;
    }

    public void configure(final List<String> unregisteredTasks) {
        super.configure(new Runnable(){

            @Override
            public void run() {
                DdsSmartsModuleTasks.this.configureInternal(unregisteredTasks);
            }
        });
    }

    private void configureInternal(List<String> unregisteredTasks) {
        List<String> tasks = Arrays.asList(ALL_TASKS_FOR_REGISTRATION);
        if (tasks.contains(INIT_PUBLISH_TASK_ID) && unregisteredTasks.contains(INIT_PUBLISH_TASK_ID)) {
            this.registerInitPublish();
        }
        if (tasks.contains(SAMPLES_TASK_ID) && unregisteredTasks.contains(SAMPLES_TASK_ID)) {
            this.registerSamples();
        }
        if (tasks.contains(PREDICT_TASK_ID) && unregisteredTasks.contains(PREDICT_TASK_ID)) {
            this.registerPredict();
        }
        if (tasks.contains(PUBLISH_TASK_ID) && unregisteredTasks.contains(PUBLISH_TASK_ID)) {
            this.registerPublish();
        }
    }

    public void registerInitPublish() {
        SmartsModuleTask initialPublishTask = new SmartsModuleTask(false, INIT_PUBLISH_TASK_ID, INIT_PUBLISH_TASK_NAME, INIT_PUBLISH_TASK_DESCRIPTION, SmartsModuleTask.Scope.DATASET, Arrays.asList("smartsmodule.fanout.column.name"), new String[]{"smartsmodule.fanout.initpublish"});
        this.messageGroup.register(initialPublishTask, (SmartsModuleFunction)new InitialPublishingFunction(INIT_PUBLISH_TASK_ID, this.storeProvider, this.dataProvider));
    }

    public void registerSamples() {
        SmartsModuleTask samplesTask = new SmartsModuleTask(false, SAMPLES_TASK_ID, SAMPLES_TASK_NAME, SAMPLES_TASK_DESCRIPTION, SmartsModuleTask.Scope.DATASET, Arrays.asList("smartsmodule.fanout.initpublish"), new String[]{"smartsmodule.fanout.column.samples"});
        this.messageGroup.register(samplesTask, (SmartsModuleFunction)new SamplesFunction(SAMPLES_TASK_ID, this.storeProvider, this.dataProvider));
    }

    public void registerPredict() {
        SmartsModuleTask predictTask = new SmartsModuleTask(false, PREDICT_TASK_ID, PREDICT_TASK_NAME, PREDICT_TASK_DESCRIPTION, SmartsModuleTask.Scope.DATASET, Arrays.asList("smartsmodule.fanout.column.samples"), new String[]{"smartsmodule.fanout.column.predict"});
        this.messageGroup.register(predictTask, (SmartsModuleFunction)new PredictFunction(PREDICT_TASK_ID, this.storeProvider, this.dataProvider));
    }

    public void registerPublish() {
        SmartsModuleTask publishTask = new SmartsModuleTask(true, PUBLISH_TASK_ID, PUBLISH_TASK_NAME, PUBLISH_TASK_DESCRIPTION, SmartsModuleTask.Scope.DATASET, false, Arrays.asList("smartsmodule.fanout.column.concept"), new String[]{"smartsmodule.fanout.publish"});
        this.messageGroup.register(publishTask, (SmartsModuleFunction)new PublishingFunction(PUBLISH_TASK_ID, this.storeProvider, this.dataProvider));
    }
}

