/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.function;

import com.ibm.smarts.common.mq.function.SmartsModuleFunctionResult;
import com.ibm.smarts.common.mq.message.SmartsModuleMessage;
import com.ibm.smarts.common.mq.message.SmartsModulePublishMessage;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.core.mq.MessageProducerProvider;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.dds.core.function.DdsFunction;
import com.ibm.smarts.dds.core.tasks.PublishingTaskImpl;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.HashMap;

public class PublishingFunction
extends DdsFunction<SmartsModuleMessage> {
    private final PublishingTaskImpl publishingTaskImpl = new PublishingTaskImpl();

    public PublishingFunction(String taskId, IStoreProvider storeProvider, IDataProvider dataProvider) {
        super(taskId, storeProvider, SmartsModuleMessage.class, dataProvider);
    }

    public SmartsModuleFunctionResult doApply(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
        String smartsModuleId = message.getSmartsModuleId();
        String datasetID = message.getDatasetId();
        SmartsTaskContext context = new SmartsTaskContext(smartsModuleId, datasetID, null, rc, this.storeProvider);
        this.publishingTaskImpl.execute(context);
        SmartsModuleFunctionResult res = (SmartsModuleFunctionResult)context.getProperty("result");
        if (res == null) {
            HashMap<String, SmartsModulePublishMessage> outgoingMessages = new HashMap<String, SmartsModulePublishMessage>();
            outgoingMessages.put("smartsmodule.fanout.publish", new SmartsModulePublishMessage(message.getSmartsModuleId(), message.getDatasetId(), message.getResourceURI()));
            res = new SmartsModuleFunctionResult(outgoingMessages);
        }
        return res;
    }
}

