/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.numerics.bivariate;

import com.ibm.smarts.dds.core.numerics.bivariate.Bivariate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoWayStatsCumulation {
    private static final Logger logger = LoggerFactory.getLogger(TwoWayStatsCumulation.class);
    private final double[] groupSum;
    private final int[] groupCount;
    private final int[][] tableSum;
    private double sxy;
    private int nxy;

    public TwoWayStatsCumulation(boolean yNumeric, boolean xNumeric, int yGroups, int xGroups) {
        if (xNumeric && !yNumeric) {
            throw new IllegalStateException("Numeric field should be second");
        }
        if (yNumeric && !xNumeric) {
            this.groupSum = new double[xGroups];
            this.groupCount = new int[xGroups];
        } else {
            this.groupSum = null;
            this.groupCount = null;
        }
        this.tableSum = new int[xGroups > 0 ? xGroups : 4][yGroups > 0 ? yGroups : 4];
    }

    public synchronized void addValue(int yGroup, int xGroup, Double yValStandardized, Double xValStandardized) {
        int[] nArray = this.tableSum[xGroup];
        int n = yGroup;
        nArray[n] = nArray[n] + 1;
        if (yValStandardized == null) {
            return;
        }
        if (xValStandardized != null) {
            this.sxy += xValStandardized * yValStandardized;
            ++this.nxy;
        }
        if (this.groupCount != null) {
            int n2 = xGroup;
            this.groupCount[n2] = this.groupCount[n2] + 1;
            int n3 = xGroup;
            this.groupSum[n3] = this.groupSum[n3] + yValStandardized;
        }
    }

    public Bivariate finish(boolean yNumeric, boolean xNumeric) {
        if (yNumeric && xNumeric) {
            return new Bivariate(this.calculateCramersV(), this.calculateEta(), this.calculatePearson());
        }
        return new Bivariate(this.calculateCramersV(), this.calculateEta(), -2.0);
    }

    private double calculateCramersV() {
        double chiSq = 0.0;
        int xLen = this.tableSum.length;
        int yLen = this.tableSum[0].length;
        int[] marginX = new int[xLen];
        int[] marginY = new int[yLen];
        double n = 0.0;
        for (int i = 0; i < xLen; ++i) {
            int j = 0;
            while (j < yLen) {
                int o = this.tableSum[i][j];
                int n2 = i;
                marginX[n2] = marginX[n2] + o;
                int n3 = j++;
                marginY[n3] = marginY[n3] + o;
                n += (double)o;
            }
        }
        int k = xLen;
        int r = yLen;
        for (int i : marginX) {
            if (i != 0) continue;
            --k;
        }
        for (int j : marginY) {
            if (j != 0) continue;
            --r;
        }
        for (int i = 0; i < xLen; ++i) {
            if (marginX[i] == 0) continue;
            for (int j = 0; j < yLen; ++j) {
                if (marginY[j] == 0) continue;
                double e = (double)(marginX[i] * marginY[j]) / n;
                double o = this.tableSum[i][j];
                chiSq += (o - e) * (o - e) / e;
            }
        }
        double pcorr = Math.max(0.0, chiSq / n - (double)((k - 1) * (r - 1)) / (n - 1.0));
        double xcorr = (double)k - (double)((k - 1) * (k - 1)) / (n - 1.0);
        double ycorr = (double)r - (double)((r - 1) * (r - 1)) / (n - 1.0);
        return Math.sqrt(pcorr / Math.min(xcorr - 1.0, ycorr - 1.0));
    }

    private double calculateEta() {
        double errorRet = -2.0;
        if (this.groupCount == null) {
            logger.info("Group Count was null! Can't calculate Eta. Returning {} to indicate error", (Object)errorRet);
            return errorRet;
        }
        double eta = 0.0;
        int n = 0;
        for (int i = 0; i < this.groupCount.length; ++i) {
            int nx = this.groupCount[i];
            if (nx <= 0) continue;
            double d = this.groupSum[i] / (double)nx;
            eta += (double)nx * d * d;
            n += nx;
        }
        if (n == 0) {
            logger.info("ETA calculation has a div by zero issue!, returning {} to indicate error", (Object)errorRet);
            return errorRet;
        }
        return eta / (double)n;
    }

    private double calculatePearson() {
        double errorRet = -2.0;
        if (this.nxy < 2) {
            logger.info("Pearson calculation error! Returning {} to indicate not a valid result", (Object)errorRet);
            return errorRet;
        }
        return Math.abs(this.sxy) / (double)(this.nxy - 1);
    }

    static final class ProcessedValue {
        final int group;
        final double val;

        ProcessedValue(int groupIndex, double standardizedValue) {
            this.group = groupIndex;
            this.val = standardizedValue;
        }
    }
}

