/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.dds.core.numerics.util;

import com.ibm.smarts.model.value.DateValue;
import com.ibm.smarts.model.value.Value;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtil.class);

    public Map<String, Pattern> getDatePatterns() {
        HashMap<String, Pattern> patternsMap = new HashMap<String, Pattern>();
        patternsMap.put("yyyy", Pattern.compile("^\\d{4}$"));
        patternsMap.put("yyyy-MM-dd", Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}$"));
        patternsMap.put("yyyy.MM.dd", Pattern.compile("^\\d{4}[.]\\d{1,2}[.]\\d{1,2}$"));
        patternsMap.put("yyyy/MM/dd", Pattern.compile("^\\d{4}/\\d{1,2}/\\d{1,2}$"));
        patternsMap.put("MM-dd-yyyy", Pattern.compile("^\\d{1,2}-\\d{1,2}-\\d{4}$"));
        patternsMap.put("MM.dd.yyyy", Pattern.compile("^\\d{1,2}[.]\\d{1,2}[.]\\d{4}$"));
        patternsMap.put("MM/dd/yyyy", Pattern.compile("^\\d{1,2}/\\d{1,2}/\\d{4}$"));
        patternsMap.put("dd MMM yy", Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}$"));
        patternsMap.put("dd MMM yyyy", Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}$"));
        patternsMap.put("dd MMM yy HH:mm", Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}$"));
        patternsMap.put("dd MMM yyyy HH:mm", Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}$"));
        patternsMap.put("dd MMM yy HH:mm:ss", Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$"));
        patternsMap.put("dd MMM yyyy HH:mm:ss", Pattern.compile("^\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$"));
        patternsMap.put("EEE, d MMM yy", Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}$"));
        patternsMap.put("EEE, d MMM yyyy", Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}$"));
        patternsMap.put("EEE, d MMM yy HH:mm", Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}$"));
        patternsMap.put("EEE, d MMM yyyy HH:mm", Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}$"));
        patternsMap.put("EEE, d MMM yy HH:mm:ss", Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$"));
        patternsMap.put("EEE, d MMM yyyy HH:mm:ss", Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$"));
        patternsMap.put("EEE, d MMM yy HH:mm:ss z", Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}\\s[A-Za-z]{3}$"));
        patternsMap.put("EEE, d MMM yyyy HH:mm:ss z", Pattern.compile("^[A-Za-z]{3},\\s\\d{1,2}\\s[A-Za-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}\\s[A-Za-z]{3}$"));
        patternsMap.put("hh:mm:ss a", Pattern.compile("^\\d{1,2}:\\d{1,2}:\\d{1,2}\\s[A-Za-z]{2}$"));
        patternsMap.put("HH:mm:ss", Pattern.compile("^\\d{2}:\\d{1,2}:\\d{1,2}$"));
        patternsMap.put("yyyy-MM-dd HH:mm", Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}$"));
        patternsMap.put("yyyy-MM-dd HH:mm:ss", Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$"));
        patternsMap.put("yyyy-MM-dd'T'HH:mm", Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{2}:\\d{2}$"));
        patternsMap.put("yyyy-MM-dd'T'HH:mm:ss", Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{2}:\\d{2}:\\d{2}$"));
        patternsMap.put("yyyy-MM-dd'T'HH:mmXXX", Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{2}:\\d{2}(\\+|\\-)(\\d{4}|\\d{2}:\\d{2})$"));
        patternsMap.put("yyyy-MM-dd'T'HH:mm:ssXXX", Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{2}:\\d{2}:\\d{2}(\\+|\\-)(\\d{4}|\\d{2}:\\d{2})$"));
        patternsMap.put("yyyy-MM-dd'T'HH:mm:ss.S'Z'", Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{2}:\\d{2}:\\d{2}.\\d{3}Z$"));
        return patternsMap;
    }

    public List<Value> getProcessedSamples(List<String> samples) {
        SimpleDateFormat format = this.getSimpleDateFormat(samples);
        if (format == null) {
            LOG.info("Date or Time format for column not supported");
            return Collections.emptyList();
        }
        return samples.stream().map(sample -> {
            if (sample == null) {
                return null;
            }
            try {
                Date date = format.parse(sample.trim());
                return new DateValue(date);
            }
            catch (ParseException e) {
                return null;
            }
        }).collect(Collectors.toList());
    }

    public String findFormatWithRegex(String sample) {
        String formatMatch = null;
        String trimmed = sample.trim();
        for (Map.Entry<String, Pattern> entry : this.getDatePatterns().entrySet()) {
            Matcher matcher = entry.getValue().matcher(trimmed);
            if (!matcher.matches()) continue;
            formatMatch = entry.getKey();
            break;
        }
        return formatMatch;
    }

    public SimpleDateFormat getSimpleDateFormat(List<String> samples) {
        int failedAttempts = 0;
        for (String sample : samples) {
            if (sample == null) continue;
            if (failedAttempts == 10) {
                return null;
            }
            String format = this.findFormatWithRegex(sample);
            if (format != null) {
                return new SimpleDateFormat(format);
            }
            ++failedAttempts;
        }
        return null;
    }
}

