/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.generic.recommender.internal.raw.impl.cf.itembased;

import com.ibm.smarts.generic.recommender.api.java.recommenders.IRecommender;
import com.ibm.smarts.generic.recommender.api.java.recommenders.Recommendation;
import com.ibm.smarts.generic.recommender.datalayer.IDataStore;
import com.ibm.smarts.generic.recommender.internal.raw.impl.recommenders.AbstractRecommender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemBasedRecommender
extends AbstractRecommender
implements IRecommender {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemBasedRecommender.class);
    private int neighbourhoodSize;
    private Map<String, Map<String, Double>> similarityMatrix = new HashMap<String, Map<String, Double>>();
    private Map<String, List<Similarity>> neighbourhood = new HashMap<String, List<Similarity>>();
    private Map<String, Double> userAvgRatings = new HashMap<String, Double>();

    public ItemBasedRecommender(IDataStore iData, int neighbourhoodSize) {
        super(iData);
        this.neighbourhoodSize = neighbourhoodSize;
    }

    private void calculateUserAvgRatings() {
        for (String usr : this.iData.getUserIds()) {
            double sum = 0.0;
            Map<String, Double> ratings = this.iData.getUserRatings(usr);
            for (double rating : ratings.values()) {
                sum += rating;
            }
            if (ratings.size() == 0) {
                this.userAvgRatings.put(usr, 0.0);
                continue;
            }
            this.userAvgRatings.put(usr, sum / (double)ratings.size());
        }
    }

    private double computeCosineSimilarity(String item1, String item2) {
        double similarity = 0.0;
        double segmaItemsRatingsProduct = 0.0;
        double segmaItem1RatingsSq = 0.0;
        double segmaItem2RatingsSq = 0.0;
        for (String usr : this.iData.getUserIds()) {
            double usrAvgRating = this.userAvgRatings.get(usr);
            Map<String, Double> ratings = this.iData.getUserRatings(usr);
            if (!ratings.keySet().contains(item1) || !ratings.keySet().contains(item2)) continue;
            segmaItemsRatingsProduct += (ratings.get(item1) - usrAvgRating) * (ratings.get(item2) - usrAvgRating);
            segmaItem1RatingsSq += (ratings.get(item1) - usrAvgRating) * (ratings.get(item1) - usrAvgRating);
            segmaItem2RatingsSq += (ratings.get(item2) - usrAvgRating) * (ratings.get(item2) - usrAvgRating);
        }
        if (segmaItem1RatingsSq == 0.0 || segmaItem2RatingsSq == 0.0) {
            return -1.0;
        }
        similarity = segmaItemsRatingsProduct / (Math.sqrt(segmaItem1RatingsSq) * Math.sqrt(segmaItem2RatingsSq));
        return similarity;
    }

    private void updateSimilarities(String item, String otherItem, Double similarity) {
        Map similarities = this.similarityMatrix.computeIfAbsent(item, k -> new HashMap());
        similarities.put(otherItem, similarity);
        List neighbours = this.neighbourhood.computeIfAbsent(item, k -> new ArrayList());
        if (neighbours.size() < this.neighbourhoodSize) {
            Similarity sim = new Similarity(otherItem, similarity);
            neighbours.add(sim);
        }
    }

    @Override
    public void train() {
        this.calculateUserAvgRatings();
        List<String> items = this.iData.getItemIds();
        for (int i = 0; i < items.size(); ++i) {
            for (int j = i + 1; j < items.size(); ++j) {
                double similarity = this.computeCosineSimilarity(items.get(i), items.get(j));
                this.updateSimilarities(items.get(i), items.get(j), similarity);
                this.updateSimilarities(items.get(j), items.get(i), similarity);
            }
        }
        for (Map.Entry<String, List<Similarity>> entry : this.neighbourhood.entrySet()) {
            List<Similarity> neighours = entry.getValue();
            if (neighours == null) continue;
            Collections.sort(neighours, Collections.reverseOrder());
        }
        LOGGER.debug("similarity_matrix: {}", this.similarityMatrix);
        LOGGER.debug("neighbourhood: {}", this.neighbourhood);
    }

    @Override
    public double predict(String user, String item) {
        double score = 0.0;
        double segmaSimilirtyRatingProduct = 0.0;
        double segmaAbsSimilirty = 0.0;
        Map<String, Double> ratings = this.iData.getUserRatings(user);
        if (ratings.containsKey(item)) {
            return ratings.get(item);
        }
        for (Map.Entry<String, Double> rating : ratings.entrySet()) {
            Map<String, Double> similarities = this.similarityMatrix.get(rating.getKey());
            if (!similarities.containsKey(item)) continue;
            segmaSimilirtyRatingProduct += similarities.get(item) * rating.getValue();
            segmaAbsSimilirty += Math.abs(similarities.get(item));
        }
        if (segmaAbsSimilirty != 0.0) {
            score = segmaSimilirtyRatingProduct / segmaAbsSimilirty;
        }
        return score;
    }

    @Override
    public List<Recommendation> recommendTopN(String user, int n) {
        HashSet<Recommendation<String>> recommendations = new HashSet<Recommendation<String>>();
        Map<String, Double> ratings = this.iData.getUserRatings(user);
        for (String item : ratings.keySet()) {
            for (Similarity s : this.neighbourhood.get(item)) {
                double score = this.predict(user, s.getItem());
                recommendations.add(new Recommendation<String>(s.getItem(), score));
            }
        }
        List<Recommendation<Object>> result = new ArrayList<Recommendation>(recommendations);
        Collections.sort(result, Collections.reverseOrder());
        if (result.size() > n) {
            result = result.subList(0, n);
        }
        return result;
    }

    @Override
    public List<Recommendation> recommendTopN(String user, int n, List<String> inclusionList) {
        throw new UnsupportedOperationException();
    }

    private class Similarity
    implements Comparable<Similarity> {
        private String item;
        private double score;

        public Similarity(String item, double score) {
            this.item = item;
            this.score = score;
        }

        public String getItem() {
            return this.item;
        }

        public double getScore() {
            return this.score;
        }

        @Override
        public int compareTo(Similarity o) {
            int comparison = Double.compare(o.getScore(), this.score);
            if (comparison == 0) {
                return 0;
            }
            if (comparison > 0) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return "Similarity [item=" + this.item + ", score=" + this.score + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            long temp = Double.doubleToLongBits(this.score);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Similarity other = (Similarity)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
                return false;
            }
            return Double.doubleToLongBits(this.score) == Double.doubleToLongBits(other.score);
        }

        private ItemBasedRecommender getOuterType() {
            return ItemBasedRecommender.this;
        }
    }
}

