/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.system;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.smarts.common.mq.progress.SmartsModuleCancel;
import com.ibm.smarts.common.mq.progress.SmartsModuleProgress;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.core.lifecycle.IComponentLifecycle;
import com.ibm.smarts.core.lifecycle.IComponentLifecycleOperations;
import com.ibm.smarts.core.lifecycle.ILifecycleManager;
import com.ibm.smarts.core.lifecycle.LifecycleManager;
import com.ibm.smarts.core.mq.MessageQueueingSystem;
import com.ibm.smarts.core.mq.SimpleMessageQueueing;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.dds.api.IDataDescriptorService;
import com.ibm.smarts.dds.api.ISmartsModuleDescriptor;
import com.ibm.smarts.dds.core.DataDescriptorService;
import com.ibm.smarts.internal.ontology.api.ConceptClassifier;
import com.ibm.smarts.internal.ontology.api.KnowledgeDiscoveryClient;
import com.ibm.smarts.internal.ontology.api.KnowledgeDiscoveryClientFactory;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.nlp.core.SmartNLPImpl;
import com.ibm.smarts.ontology.service.KnowledgeDiscoveryService;
import com.ibm.smarts.qa.api.QuestionAnalyzer;
import com.ibm.smarts.questionanalyzer.core.QuestionAnalyzerImpl;
import com.ibm.smarts.schema.CancelOption;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.semanticsearch.api.SemanticSearchService;
import com.ibm.smarts.semanticsearch.impl.SemanticSearchServiceImpl;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.system.ISmartsAdaptor;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsSystem<A extends ISmartsAdaptor>
implements IComponentLifecycleOperations,
IComponentLifecycle {
    private final Logger LOGGER = LoggerFactory.getLogger(SmartsSystem.class);
    public final A adaptor;
    public final IDataProvider dataProvider;
    public final Properties config;
    public final IStoreProvider storeProvider;
    public final MessageQueueingSystem messageQueueing;
    private final IDataDescriptorService dds;
    private final SmartNLP nlp;
    private final KnowledgeDiscoveryService knowledgeDiscoveryService;
    private final KnowledgeDiscoveryClient knowledgeDiscoveryClient;
    private final QuestionAnalyzer qa;
    private final SemanticSearchService semanticSearchService;
    private final ExecutorService executorService;
    private final LifecycleManager clh;

    public SmartNLP getNlp() {
        return this.nlp;
    }

    public SmartsSystem(A adaptor, Properties config, IDataProvider dataProvider, IStoreProvider storeProvider, ExecutorService executorService) {
        this(adaptor, config, dataProvider, storeProvider, (MessageQueueingSystem)new SimpleMessageQueueing(), executorService);
    }

    public SmartsSystem(A adaptor, Properties config, IDataProvider dataProvider, IStoreProvider storeProvider, MessageQueueingSystem messageQueueing, ExecutorService executorService) {
        this(adaptor, config, dataProvider, storeProvider, messageQueueing, (IDataDescriptorService)new DataDescriptorService(dataProvider, storeProvider, messageQueueing), executorService);
    }

    public SmartsSystem(A adaptor, Properties config, IDataProvider dataProvider, IStoreProvider storeProvider, MessageQueueingSystem messageQueueing, IDataDescriptorService dds, ExecutorService executorService) {
        this(adaptor, config, dataProvider, storeProvider, messageQueueing, dds, (SmartNLP)new SmartNLPImpl(config, storeProvider, messageQueueing), executorService);
    }

    private SmartsSystem(A adaptor, Properties config, IDataProvider dataProvider, IStoreProvider storeProvider, MessageQueueingSystem messageQueueing, IDataDescriptorService dds, SmartNLP nlp, ExecutorService executorService) {
        this(adaptor, config, dataProvider, storeProvider, messageQueueing, dds, nlp, new KnowledgeDiscoveryService(config, nlp, storeProvider), executorService);
    }

    private SmartsSystem(A adaptor, Properties config, IDataProvider dataProvider, IStoreProvider storeProvider, MessageQueueingSystem messageQueueing, IDataDescriptorService dds, SmartNLP nlp, KnowledgeDiscoveryService knowledgeDiscoveryService, ExecutorService executorService) {
        this(adaptor, config, dataProvider, storeProvider, messageQueueing, dds, nlp, knowledgeDiscoveryService, SmartsSystem.builOntologyClient(config, storeProvider, messageQueueing, knowledgeDiscoveryService), executorService);
    }

    private SmartsSystem(A adaptor, Properties config, IDataProvider dataProvider, IStoreProvider storeProvider, MessageQueueingSystem messageQueueing, IDataDescriptorService dds, SmartNLP nlp, KnowledgeDiscoveryService knowledgeDiscoveryService, KnowledgeDiscoveryClient knowledgeDiscoveryClient, ExecutorService executorService) {
        this(adaptor, config, dataProvider, storeProvider, messageQueueing, dds, nlp, knowledgeDiscoveryService, knowledgeDiscoveryClient, (QuestionAnalyzer)new QuestionAnalyzerImpl(nlp, storeProvider, knowledgeDiscoveryService), executorService);
    }

    private SmartsSystem(A adaptor, Properties config, IDataProvider dataProvider, IStoreProvider storeProvider, MessageQueueingSystem messageQueueing, IDataDescriptorService dds, SmartNLP nlp, KnowledgeDiscoveryService knowledgeDiscoveryService, KnowledgeDiscoveryClient knowledgeDiscoveryClient, QuestionAnalyzer qa, ExecutorService executorService) {
        this(adaptor, config, dataProvider, storeProvider, messageQueueing, dds, nlp, knowledgeDiscoveryService, knowledgeDiscoveryClient, qa, (SemanticSearchService)new SemanticSearchServiceImpl(qa, storeProvider, nlp, knowledgeDiscoveryService), executorService);
    }

    public SmartsSystem(A adaptor, Properties config, IDataProvider dataProvider, IStoreProvider storeProvider, MessageQueueingSystem messageQueueing, IDataDescriptorService dds, SmartNLP nlp, KnowledgeDiscoveryService knowledgeDiscoveryService, KnowledgeDiscoveryClient knowledgeDiscoveryClient, QuestionAnalyzer qa, SemanticSearchService ss, ExecutorService executorService) {
        this.adaptor = adaptor;
        this.config = config;
        this.dataProvider = dataProvider;
        this.storeProvider = storeProvider;
        this.messageQueueing = messageQueueing;
        assert (messageQueueing != null);
        this.executorService = executorService;
        this.dds = dds;
        this.nlp = nlp;
        this.knowledgeDiscoveryService = knowledgeDiscoveryService;
        this.knowledgeDiscoveryClient = knowledgeDiscoveryClient;
        this.qa = qa;
        this.semanticSearchService = ss;
        this.clh = new LifecycleManager((IComponentLifecycle)this, new IComponentLifecycleOperations[0]);
        this.clh.addComponents(new IComponentLifecycleOperations[]{(IComponentLifecycleOperations)dds});
        this.clh.addComponents(new IComponentLifecycleOperations[]{knowledgeDiscoveryService});
        this.clh.addComponents(new IComponentLifecycleOperations[]{(IComponentLifecycleOperations)nlp});
        this.clh.addComponents(new IComponentLifecycleOperations[]{(IComponentLifecycleOperations)qa});
        this.clh.addComponents(new IComponentLifecycleOperations[]{(IComponentLifecycleOperations)ss});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[SmartsSystem @" + Integer.toHexString(this.hashCode()));
        sb.append(" config=" + this.config);
        sb.append(" storeProvider=" + this.storeProvider);
        sb.append(" messaging=" + this.messageQueueing);
        sb.append(" dds=" + this.dds);
        sb.append(" nlp=" + this.nlp);
        sb.append(" kds=" + this.knowledgeDiscoveryService);
        sb.append(" kdsClient=" + this.knowledgeDiscoveryClient);
        sb.append(" qa=" + this.qa);
        sb.append(" semanticService=" + this.semanticSearchService);
        sb.append(" dataProvider=" + this.dataProvider);
        sb.append(" executorService=" + this.executorService);
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }

    public ILifecycleManager getLifecycleManager() {
        return this.clh;
    }

    public void initialize(RequestContext rc) {
        this.LOGGER.info("<TCL> Component initialize System");
    }

    public void shutDown(RequestContext rc) {
        this.LOGGER.info("<TCL> Component initialize System");
    }

    public IDataDescriptorService getDataDescriptorService() {
        return this.dds;
    }

    public ISmartsModuleDescriptor getSmartsModule(RequestContext context, String moduleId) {
        return this.getDataDescriptorService().getSmartsModule(context, moduleId);
    }

    public ISmartsModuleDescriptor getSmartsModule(RequestContext context, String moduleId, Module module) {
        return this.getDataDescriptorService().getSmartsModule(context, moduleId, module, null);
    }

    public ISmartsModuleDescriptor createSmartsModule(RequestContext context, String moduleId, Module module, Set<String> excludedTables) {
        return this.getDataDescriptorService().getSmartsModule(context, moduleId, module, excludedTables);
    }

    public CompletableFuture<SmartsModule> getSmartsModuleFromPersistenceProvider(RequestContext context, String smartsModuleId) {
        return this.getDataDescriptorService().getSmartsModuleFromPersistenceProvider(context, smartsModuleId);
    }

    public SmartsModuleProgress getProgress(RequestContext context, String smartsModuleId) {
        return this.getDataDescriptorService().getProgress(context, smartsModuleId);
    }

    public SmartsModuleCancel cancelSmartModule(RequestContext context, String smartsModuleId, CancelOption cancelOption) {
        return this.getDataDescriptorService().cancelSmartModule(context, smartsModuleId, cancelOption);
    }

    public SmartsModuleCancel deleteSmartModule(RequestContext context, String smartsModuleId) {
        return this.getDataDescriptorService().deleteSmartModule(context, smartsModuleId);
    }

    public KnowledgeDiscoveryClient getKnowledgeDiscoveryClient() {
        return this.knowledgeDiscoveryClient;
    }

    public KnowledgeDiscoveryService getKnowledgeDiscoveryService() {
        return this.knowledgeDiscoveryService;
    }

    private static KnowledgeDiscoveryClient builOntologyClient(Properties config, IStoreProvider storeProvider, MessageQueueingSystem messageSystem, KnowledgeDiscoveryService knowledgeDiscoveryService) {
        if (KnowledgeDiscoveryClientFactory.isInitialized()) {
            KnowledgeDiscoveryClientFactory.terminate();
        }
        KnowledgeDiscoveryClientFactory.initialize((IStoreProvider)storeProvider, (MessageQueueingSystem)messageSystem, (ConceptClassifier)knowledgeDiscoveryService.getSmartsModuleConceptClassifier());
        KnowledgeDiscoveryClient client = KnowledgeDiscoveryClientFactory.getInstance().getOntologyClient();
        client.setConceptClassifier((ConceptClassifier)knowledgeDiscoveryService.getSmartsModuleConceptClassifier());
        return client;
    }

    public SemanticSearchService getSemanticSearchService() {
        return this.semanticSearchService;
    }

    public QuestionAnalyzer getQuestionAnalyzer() {
        return this.qa;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public IStoreProvider getStoreProvider() {
        return this.storeProvider;
    }
}

