/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.api;

import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.IChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.internal.ChartDescription;
import com.ibm.smarts.visualization.recommender.internal.ChartDescriptionGenerator;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import com.ibm.smarts.visualization.recommender.schema.charts.ChartElementFeatureMismatch;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class BindingResult
implements IBindingResult {
    private final String chart;
    private final List<Binding> binding;
    private final List<String> unbindableColumns;
    private final int numberOfRemainingSlots;
    private final PreferenceLevel preferenceLevel;
    private boolean isMandatorySlotsMissing;
    private boolean isLearnedBinding;
    private double bindingScore;
    private String naturalLanguageLabel = "";
    private String naturalLanguageTitle = "";
    private String naturalLanguageDescription = "";
    private Locale locale;
    private static final double BASE_SCORE = 0.5;
    private static final double BINDING_WEIGHT = 0.4;
    private static final double MANDATORY_SLOT_MISSING_WEIGHT = 0.1;
    private static final double REMAINING_SLOT_WEIGHT = 0.05;
    private static final double LEARNING_WEIGHT = 0.6;
    private static final double SLOT_BINDING_WEIGHT = 0.1;
    private static final double CONCEPT_WEIGHT = 0.1;

    public BindingResult(IBindingResult other) {
        this.chart = other.getChart();
        this.binding = new LinkedList<Binding>(other.getBinding());
        this.unbindableColumns = new LinkedList<String>(other.getUnbindableColumns());
        this.numberOfRemainingSlots = other.getNumberOfRemainingSlots();
        this.bindingScore = other.getBindingScore();
        this.preferenceLevel = other.gePreferenceLevel();
        this.locale = other.getLocale();
        this.naturalLanguageLabel = other.getNaturalLanguageLabel();
        this.naturalLanguageTitle = other.getNaturalLanguageTitle();
        this.naturalLanguageDescription = other.getNaturalLanguageDescription();
        this.isMandatorySlotsMissing = other.isMandatorySlotsMissing();
        this.isLearnedBinding = other.isLearnedBinding();
    }

    public BindingResult(Locale locale, String chart, List<Binding> binding, List<String> unbindaleColumns, int numberofRemainingSlots, PreferenceLevel preferenceLevel, boolean isMandatorySlotsMissing, boolean isLearnedBinding) {
        this.binding = binding.stream().sorted(Comparator.comparing(Binding::getSlot)).collect(Collectors.toList());
        this.unbindableColumns = unbindaleColumns;
        this.numberOfRemainingSlots = numberofRemainingSlots;
        this.chart = chart;
        this.locale = locale;
        this.isMandatorySlotsMissing = isMandatorySlotsMissing;
        this.isLearnedBinding = isLearnedBinding;
        this.preferenceLevel = preferenceLevel;
        this.calculateScore();
    }

    public BindingResult(Locale locale, String chart, List<Binding> binding, List<String> unbindaleColumns, int numberofRemainingSlots, PreferenceLevel preferenceLevel, boolean isMandatorySlotsMissing) {
        this(locale, chart, binding, unbindaleColumns, numberofRemainingSlots, preferenceLevel, isMandatorySlotsMissing, false);
    }

    public BindingResult(Locale locale, String chart, List<Binding> binding, List<String> unbindaleColumns, int numberofRemainingSlots, PreferenceLevel preferenceLevel) {
        this(locale, chart, binding, unbindaleColumns, numberofRemainingSlots, preferenceLevel, false, false);
    }

    public void generateNaturalLanguage(Locale locale, IChartDescriptor chart, List<ExtractedFeatureSet> features, List<Binding> columnBinding, Map<String, String> mapColumnIdForExpressionToColumnName) {
        if (!(this.naturalLanguageLabel.isEmpty() || this.naturalLanguageTitle.isEmpty() || this.naturalLanguageDescription.isEmpty())) {
            return;
        }
        ChartDescription description = ChartDescriptionGenerator.generateNaturalLanguage(locale, chart, features, columnBinding, mapColumnIdForExpressionToColumnName, this.isMandatorySlotsMissing);
        this.naturalLanguageLabel = description.getLabel();
        this.naturalLanguageTitle = description.getTitle();
        this.naturalLanguageDescription = description.getDescription();
    }

    @Override
    public List<Binding> getBinding() {
        return this.binding;
    }

    @Override
    public double getBindingScore() {
        return this.bindingScore;
    }

    private void calculateScore() {
        double boundCount = this.binding.stream().map(b -> b.getColumns().size()).reduce((a, b) -> a + b).orElse(0).intValue();
        double allColumns = (double)this.unbindableColumns.size() + boundCount;
        double finalScore = 0.5;
        finalScore -= (double)this.unbindableColumns.size() / allColumns * 0.4;
        finalScore -= (double)this.getNumberOfRemainingSlots() * 0.05;
        if (this.isMandatorySlotsMissing) {
            finalScore -= 0.1;
        }
        if (this.binding.size() > 0) {
            double bindingScoreTotal = this.binding.stream().map(b -> b.getScore()).reduce((a, b) -> a + b).get().longValue();
            double maxScore = this.binding.stream().flatMap(b -> b.getColumns().stream()).collect(Collectors.toList()).size() * ChartElementFeatureMismatch.getMaxMatchScore();
            finalScore += bindingScoreTotal / maxScore * 0.1;
            double concepts = this.binding.stream().filter(b -> !b.getConcept().equals("NONE")).collect(Collectors.toList()).size();
            finalScore += concepts / (double)this.binding.size() * 0.1;
        }
        if (this.isLearnedBinding) {
            finalScore += 0.6;
        }
        switch (this.preferenceLevel) {
            case HIGH: {
                finalScore += 0.1;
                break;
            }
            case MEDIUM: {
                finalScore += 0.05;
            }
        }
        this.bindingScore = Math.min(finalScore, 1.0);
    }

    @Override
    public List<String> getUnbindableColumns() {
        return this.unbindableColumns;
    }

    @Override
    public int getNumberOfRemainingSlots() {
        return this.numberOfRemainingSlots;
    }

    @Override
    public String getChart() {
        return this.chart;
    }

    @Override
    public boolean isLearnedBinding() {
        return this.isLearnedBinding;
    }

    @Override
    public boolean isWarningsPresent() {
        return this.binding.stream().anyMatch(b -> !b.getWarnings().isEmpty());
    }

    public String toString() {
        return "BindingResult [chart=" + this.chart + ", binding=" + this.binding + ", unbindableColumns=" + this.unbindableColumns + ", numberOfRemainingSlots=" + this.numberOfRemainingSlots + ", isMandatorySlotsMissing=" + this.isMandatorySlotsMissing + ", bindingScore=" + this.bindingScore + ", naturalLanguageLabel=" + this.naturalLanguageLabel + ", naturalLanguageTitle=" + this.naturalLanguageTitle + ", naturalLanguageDescription=" + this.naturalLanguageDescription + ", locale=" + this.locale + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindingResult that = (BindingResult)o;
        return this.numberOfRemainingSlots == that.numberOfRemainingSlots && this.isMandatorySlotsMissing == that.isMandatorySlotsMissing && this.bindingScore == that.bindingScore && Objects.equals(this.chart, that.chart) && Objects.equals(this.binding, that.binding) && Objects.equals(this.unbindableColumns, that.unbindableColumns) && Objects.equals(this.naturalLanguageLabel, that.naturalLanguageLabel) && Objects.equals(this.naturalLanguageTitle, that.naturalLanguageTitle) && Objects.equals(this.naturalLanguageDescription, that.naturalLanguageDescription) && Objects.equals(this.locale, that.locale);
    }

    public int hashCode() {
        return Objects.hash(this.chart, this.binding, this.unbindableColumns, this.numberOfRemainingSlots, this.isMandatorySlotsMissing, this.naturalLanguageLabel, this.naturalLanguageTitle, this.naturalLanguageDescription, this.locale, this.bindingScore);
    }

    @Override
    public String getNaturalLanguageLabel() {
        return this.naturalLanguageLabel;
    }

    @Override
    public String getNaturalLanguageTitle() {
        return this.naturalLanguageTitle;
    }

    @Override
    public String getNaturalLanguageDescription() {
        return this.naturalLanguageDescription;
    }

    @Override
    public void setNaturalLanguage(String label, String title, String description, Locale loc) {
        this.naturalLanguageLabel = label;
        this.naturalLanguageTitle = title;
        this.naturalLanguageDescription = description;
        this.locale = loc;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public PreferenceLevel gePreferenceLevel() {
        return this.preferenceLevel;
    }

    @Override
    public boolean isMandatorySlotsMissing() {
        return this.isMandatorySlotsMissing;
    }
}

