/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.api;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.api.IBaseChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.exceptions.ImpossibleBindingException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnBindingException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnInfoException;
import com.ibm.smarts.visualization.recommender.internal.charts.BindingChartElementAlloc;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.FeatureChartElementAlloc;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartConcepts;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import com.ibm.smarts.visualization.recommender.schema.charts.ChartElementFeatureMismatch;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface IChartDescriptor
extends IBaseChartDescriptor {
    public String getLabel(Map<String, List<String>> var1, Locale var2);

    public String getTitle(Map<String, List<String>> var1, Locale var2);

    public String getDescription(Map<String, List<String>> var1, List<ExtractedFeatureSet> var2, Locale var3);

    public String getNLGId();

    public List<ChartElement> getChartElements();

    public PreferenceLevel getPreferenceLevel();

    default public boolean isPredictive() {
        return false;
    }

    default public boolean acceptsHierarchicalColumns() {
        return true;
    }

    default public int getMinDistinctCount() {
        return 0;
    }

    default public boolean isValid() {
        List<ChartElement> elements = this.getChartElements();
        String name = this.getName();
        if (name != null && !name.isEmpty() && elements != null && !elements.isEmpty()) {
            return this.getChartElements().stream().allMatch(ChartElement::isValid);
        }
        return false;
    }

    public List<Binding> bindChartElements(List<ExtractedFeatureSet> var1) throws ImpossibleBindingException;

    public List<IBindingResult> bindChartElements(Locale var1, List<Binding> var2, Map<String, IDataColumn> var3, Map<BindingParams, Double> var4, List<ExtractedFeatureSet> var5, boolean var6) throws InvalidColumnBindingException, ImpossibleBindingException, InvalidColumnInfoException;

    public boolean validateBindings(List<ExtractedFeatureSet> var1, List<Binding> var2, int var3);

    default public List<FeatureChartElementAlloc> findCandidateElementsForColumn(Binding binding, List<ExtractedFeatureSet> features) {
        return features.stream().flatMap(f -> this.findCandidateElements(binding, (ExtractedFeatureSet)f).stream()).collect(Collectors.toList());
    }

    default public List<FeatureChartElementAlloc> findCandidateElements(Binding binding, ExtractedFeatureSet feature) {
        BasicType type = feature.getFeatureType();
        String concept = feature.getConcept();
        Function<ChartElement, Set> findMismatches = e -> {
            HashSet<ChartElementFeatureMismatch> mismatches = new HashSet<ChartElementFeatureMismatch>();
            if (!e.getBasicTypes().contains((Object)type)) {
                mismatches.add(ChartElementFeatureMismatch.TYPE_MISMATCH);
            }
            if (!(concept.isEmpty() || e.getConcept().equals(concept) || e.getType().getConcept().equals(StdChartConcepts.HIERARCHY.name()) && binding.getColumns().size() > 1)) {
                mismatches.add(ChartElementFeatureMismatch.TYPE_MISMATCH);
            }
            return mismatches;
        };
        return this.getElements().stream().filter(e -> e.getType().getSlot().equals(binding.getSlot())).map(e -> new FeatureChartElementAlloc(feature, (ChartElement)e, (Set)findMismatches.apply((ChartElement)e))).collect(Collectors.toList());
    }

    default public List<List<BindingChartElementAlloc>> findAllPossibleAllocations(Map<Binding, List<BindingChartElementAlloc>> allocations) {
        List flatended = allocations.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        if (flatended.size() == 1) {
            return flatended.get(0).stream().map(f -> Stream.of(f).collect(Collectors.toList())).collect(Collectors.toList());
        }
        return VisRecommenderUtils.cartesianProduct(flatended).stream().filter(a -> this.isValidAllocation(this.getElements().stream().collect(Collectors.toList()), (List<BindingChartElementAlloc>)a)).collect(Collectors.toList());
    }

    default public boolean isValidAllocation(List<ChartElement> elemnts, List<BindingChartElementAlloc> allocations) {
        return !allocations.stream().map(a -> elemnts.remove(a.getElement())).collect(Collectors.toList()).contains(false);
    }
}

