/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.external.charts.extensions;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.FeatureType;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.ExternalChartDescriptor;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class BaseMultiMeasureSlotChart
extends ExternalChartDescriptor {
    protected static final long MIN_MEASURES = 2L;
    protected static final long MAX_MEASURES = 10L;
    protected static Set<Quantity> quantities = new HashSet<Quantity>(Arrays.asList(Quantity.NONE, Quantity.FEW, Quantity.MODERATE, Quantity.MANY));

    BaseMultiMeasureSlotChart(String name, String labelId, String titleId, String descriptionId, List<ChartElement> elements, PreferenceLevel preference) {
        super(name, labelId, titleId, descriptionId, elements, preference, 0.0, 0.0, 0.0);
    }

    protected Map<FeatureType, List<IDataColumn>> classifyColumns(List<IDataColumn> unboundColumns) {
        EnumMap<FeatureType, List<IDataColumn>> classifications = new EnumMap<FeatureType, List<IDataColumn>>(FeatureType.class);
        unboundColumns.forEach(c -> {
            List concepts = c.getFlatListOfConcepts();
            if (concepts.contains(BasicType.ENTITY.getOntologyConcept()) && concepts.contains(BasicType.MEASURE.getOntologyConcept())) {
                List columns = classifications.computeIfAbsent(FeatureType.MIXED, t -> new ArrayList());
                columns.add(c);
            } else if (concepts.contains(BasicType.MEASURE.getOntologyConcept())) {
                List columns = classifications.computeIfAbsent(FeatureType.MEASURE, t -> new ArrayList());
                columns.add(c);
            } else {
                List columns = classifications.computeIfAbsent(FeatureType.ENTITY, t -> new ArrayList());
                columns.add(c);
            }
        });
        return classifications;
    }

    protected List<String> getIdForExpression(IDataColumn col) {
        if (col.isHierchical()) {
            return col.getHierarchy().stream().map(IDataColumn::getIdForExpression).collect(Collectors.toList());
        }
        return Arrays.asList(col.getIdForExpression());
    }
}

