/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.external.charts.extensions;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.exceptions.BindingException;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.FeatureType;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.MultiMeasureSlotColumn;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGUtils;
import com.ibm.smarts.visualization.recommender.internal.ExternalRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.MultiMeasureChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.Requirment;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartConcepts;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartElements;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ClusteredColumn
extends MultiMeasureSlotColumn {
    private static final String CHART_NAME = "ClusteredColumn";
    protected static final double NORMAL_SCORE = 1.0;
    protected static final String TARGET_SLOT = "TARGET_LINE";
    private static List<ChartElement> chartElements = Arrays.asList(new ChartElement(StdChartElements.CATEGORY.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new MultiMeasureChartElement(StdChartElements.VALUE.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new ChartElement(StdChartElements.COLOR.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1));

    public ClusteredColumn() {
        super(CHART_NAME, "IDS_COMPARE_CATEGORY_LABEL", "IDS_COLUMN_CATEGORY_TITLE", null, chartElements);
    }

    @Override
    public String getName() {
        return CHART_NAME;
    }

    @Override
    protected void updateRecommendationScore(ExternalRecommendedVisualization recommendation, Map<FeatureType, List<IDataColumn>> classifications) {
        recommendation.setScore(1.0);
    }

    @Override
    public List<String> getSlots() {
        ArrayList<String> slots = new ArrayList<String>(super.getSlots());
        slots.add(TARGET_SLOT);
        return slots;
    }

    @Override
    public boolean validateBindings(List<IDataColumn> columns, List<Binding> bindings) {
        List<String> validSlots = this.getSlots();
        return bindings.stream().map(Binding::getSlot).allMatch(validSlots::contains);
    }

    protected Map<FeatureType, List<IDataColumn>> classifyTargetColumn(List<IDataColumn> unboundColumns) {
        EnumMap<FeatureType, List<IDataColumn>> targetClassification = new EnumMap<FeatureType, List<IDataColumn>>(FeatureType.class);
        for (IDataColumn unbound : unboundColumns) {
            List concepts = unbound.getFlatListOfConcepts();
            if (!concepts.contains(BasicType.MEASURE.getOntologyConcept()) || !concepts.contains(StdChartConcepts.PLANNED.getId())) continue;
            List columns = targetClassification.computeIfAbsent(FeatureType.PLANNED, t -> new ArrayList());
            columns.add(unbound);
            break;
        }
        return targetClassification;
    }

    @Override
    protected List<Binding> checkWrongBindings(List<Binding> bound) {
        return super.checkWrongBindings(bound).stream().filter(b -> !b.getSlot().equals(TARGET_SLOT)).collect(Collectors.toList());
    }

    protected boolean isMoreMeasuresAvailable(List<IDataColumn> potentialMeasures) {
        List measures = this.classifyColumns(potentialMeasures).getOrDefault((Object)FeatureType.MEASURE, Collections.emptyList());
        List duals = this.classifyColumns(potentialMeasures).getOrDefault((Object)FeatureType.MIXED, Collections.emptyList());
        return !measures.isEmpty() || !duals.isEmpty();
    }

    @Override
    public ExternalRecommendedVisualization recommend(String combinationId, List<IDataColumn> columns, List<Binding> constraints, VisualizationParameters parameters) {
        Map<FeatureType, List<IDataColumn>> targetClassification = this.classifyTargetColumn(columns);
        List targets = targetClassification.getOrDefault((Object)FeatureType.PLANNED, Collections.emptyList());
        ArrayList<IDataColumn> updatedColumns = new ArrayList<IDataColumn>(columns);
        if (!targets.isEmpty()) {
            IDataColumn firstCol = (IDataColumn)targets.get(0);
            ArrayList<IDataColumn> potentialMeasures = new ArrayList<IDataColumn>(columns);
            potentialMeasures.remove(firstCol);
            if (!this.isMoreMeasuresAvailable(potentialMeasures)) {
                return super.recommend(combinationId, columns, constraints, parameters);
            }
            Binding targetBinding = new Binding(this.getIdForExpression(firstCol), TARGET_SLOT, StdChartConcepts.PLANNED.name());
            updatedColumns.remove(firstCol);
            ExternalRecommendedVisualization ret = super.recommend(combinationId, updatedColumns, constraints, parameters);
            if (ret != null) {
                Locale locale;
                ret.getColumnBindings().add(targetBinding);
                Locale locale2 = locale = parameters != null && parameters.getRequestContext() != null ? parameters.getRequestContext().locale : null;
                if (locale != null) {
                    this.generateNaturalLanguage(ret, ChartNLGUtils.getFeaturesForDescription(columns), locale, columns);
                }
            }
            return ret;
        }
        return super.recommend(combinationId, columns, constraints, parameters);
    }

    @Override
    public List<IBindingResult> bind(Locale locale, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, List<IDataColumn> unboundColumns, boolean forceBinding) throws BindingException {
        Map<FeatureType, List<IDataColumn>> targetClassification = this.classifyTargetColumn(unboundColumns);
        List targets = targetClassification.getOrDefault((Object)FeatureType.PLANNED, Collections.emptyList());
        ArrayList<Binding> updatedBound = new ArrayList<Binding>(bound);
        HashMap<String, IDataColumn> updatedBoundColumnInfo = new HashMap<String, IDataColumn>(boundColumnInfo);
        ArrayList<IDataColumn> updatedUnboundColumns = new ArrayList<IDataColumn>(unboundColumns);
        Optional<Binding> isTargetSlotUsed = bound.stream().filter(b -> b.getSlot().equals(TARGET_SLOT)).findFirst();
        if (!targets.isEmpty() && !isTargetSlotUsed.isPresent()) {
            IDataColumn firstCol = (IDataColumn)targets.get(0);
            ArrayList<IDataColumn> potentialMeasures = new ArrayList<IDataColumn>(unboundColumns);
            potentialMeasures.remove(firstCol);
            if (!this.isMoreMeasuresAvailable(potentialMeasures)) {
                return super.bind(locale, bound, boundColumnInfo, unboundColumns, forceBinding);
            }
            Binding targetBinding = new Binding(this.getIdForExpression(firstCol), TARGET_SLOT, StdChartConcepts.PLANNED.name());
            updatedBound.add(targetBinding);
            updatedUnboundColumns.remove(firstCol);
            updatedBoundColumnInfo.put(firstCol.getIdForExpression(), firstCol);
        }
        return super.bind(locale, updatedBound, updatedBoundColumnInfo, updatedUnboundColumns, forceBinding);
    }
}

