/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.external.charts.extensions;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.FeatureType;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.MultiMeasureSlotColumn;
import com.ibm.smarts.visualization.recommender.internal.ExternalRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.MultiMeasureChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.Requirment;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartElements;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MultiMeasureColumn
extends MultiMeasureSlotColumn {
    private static final String CHART_NAME = "Column";
    protected static final double NORMAL_SCORE = 0.99;
    private static List<ChartElement> chartElements = Arrays.asList(new MultiMeasureChartElement(StdChartElements.VALUE.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1));

    public MultiMeasureColumn() {
        super(CHART_NAME, "IDS_MULTIMEASURE_LABEL", "IDS_MULTICOLUMN_TITLE", null, chartElements);
    }

    @Override
    public String getName() {
        return CHART_NAME;
    }

    @Override
    protected void updateRecommendationScore(ExternalRecommendedVisualization recommendation, Map<FeatureType, List<IDataColumn>> classifications) {
        recommendation.setScore(0.99);
    }

    @Override
    public ExternalRecommendedVisualization recommend(String combinationId, List<IDataColumn> columns, List<Binding> constraints, VisualizationParameters parameters) {
        Map<FeatureType, List<IDataColumn>> classifications = this.classifyColumns(columns);
        List entities = classifications.getOrDefault((Object)FeatureType.ENTITY, Collections.emptyList());
        List<IDataColumn> measures = classifications.getOrDefault((Object)FeatureType.MEASURE, Collections.emptyList());
        List<IDataColumn> dual = classifications.getOrDefault((Object)FeatureType.MIXED, Collections.emptyList());
        if (!entities.isEmpty() || !dual.isEmpty()) {
            return null;
        }
        if ((long)measures.size() < 2L) {
            return null;
        }
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        measures.forEach(m -> bindings.add(new Binding(Arrays.asList(m.getIdForExpression()), "VALUE")));
        HashSet<String> flexibleSlotCapacitySet = new HashSet<String>();
        flexibleSlotCapacitySet.add("VALUE");
        ExternalRecommendedVisualization recommendation = new ExternalRecommendedVisualization(this, bindings, this.getScore(), 0, combinationId, flexibleSlotCapacitySet);
        recommendation.setBaseFilterList(parameters.getBaseFilterList());
        recommendation.setAggregationMap(parameters.getAggregationMap());
        this.updateRecommendationScore(recommendation, classifications);
        if (recommendation.getScore() <= 0.0) {
            return null;
        }
        if (!this.checkAggregationValuesAllMatch(measures, parameters.getAggregationMap())) {
            return null;
        }
        Map<IDataColumn, List<Double>> minMaxValues = this.getMinMaxValues(dual);
        minMaxValues.putAll(this.getMinMaxValues(measures));
        if (!this.findOutOfScaleColumns(minMaxValues).isEmpty()) {
            return null;
        }
        Locale locale = parameters != null && parameters.getRequestContext() != null ? parameters.getRequestContext().locale : null;
        this.setNaturalLanguageStrings(recommendation, bindings, columns, locale);
        return recommendation;
    }
}

