/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CompatibleChartsForBindingSets {
    public final List<Set<String>> compatibleChartsSets;

    @JsonCreator
    public CompatibleChartsForBindingSets(@JsonProperty(value="compatibleChartsSets") List<Set<String>> sets) {
        this.compatibleChartsSets = sets;
    }

    public CompatibleChartsForBindingSets() {
        this.compatibleChartsSets = new ArrayList<Set<String>>();
    }

    public boolean isCompatible(String originalChart, String targetChart) {
        for (Set<String> chartsSet : this.compatibleChartsSets) {
            if (!chartsSet.contains(originalChart) || !chartsSet.contains(targetChart)) continue;
            return true;
        }
        return false;
    }

    public void add(Set<String> chartsSet) {
        this.compatibleChartsSets.add(chartsSet);
    }

    public Set<String> get(String chart) {
        for (Set<String> chartsSet : this.compatibleChartsSets) {
            if (!chartsSet.contains(chart)) continue;
            return chartsSet;
        }
        return Collections.emptySet();
    }

    public String toString() {
        return "CompatibleChartsForBindingSets [listOfChartSets=" + this.compatibleChartsSets + "]";
    }
}

