/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal;

import com.ibm.smarts.combinations.generator.api.ICombinationGenerator;
import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.combinations.generator.api.IDataGroup;
import com.ibm.smarts.combinations.generator.api.IFilter;
import com.ibm.smarts.combinations.generator.api.IMatrixDataGroup;
import com.ibm.smarts.combinations.generator.internal.MatrixDataGroup;
import com.ibm.smarts.recommenders.core.utils.ChartDescriptorLoader;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingResult;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.exceptions.BindingException;
import com.ibm.smarts.visualization.recommender.internal.RecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.VisualizationRecommender;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartElements;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import com.ibm.smarts.visualization.recommender.schema.IRecommendedVisualization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualizationMatrixer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartDescriptorLoader.class);

    private VisualizationMatrixer() {
    }

    static List<IBindingResult> addMaxtrixBinding(SmartsModule dataModule, List<String> matrixExcludedCharts, String chart, List<IBindingResult> results, ICombinationGenerator generator, Map<String, IFilter> columnFilterMap, Properties config) throws BindingException {
        BindingResult firstBindingResult = new BindingResult(results.get(0));
        if (matrixExcludedCharts.contains(chart)) {
            return results;
        }
        if (firstBindingResult.getUnbindableColumns().isEmpty() || firstBindingResult.getNumberOfRemainingSlots() != 0) {
            return results;
        }
        Optional<Binding> row = firstBindingResult.getBinding().stream().filter(b -> StdChartElements.MATRIX_ROW.name().equals(b.getSlot())).findFirst();
        Optional<Binding> column = firstBindingResult.getBinding().stream().filter(b -> StdChartElements.MATRIX_COLUMN.name().equals(b.getSlot())).findFirst();
        for (IBindingResult result : results) {
            int firstBindingUnboundSize;
            BindingResult resultCopy = new BindingResult(result);
            if (!VisualizationMatrixer.attemptBindingMatrixRowAndColumn(dataModule, resultCopy, generator, Integer.valueOf(config.getProperty("smarts.visualization.recommender.featureQuantityFewThreshold")), Integer.valueOf(config.getProperty("smarts.visualization.recommender.featureQuantityModerateThreshold")), row, column, columnFilterMap)) continue;
            int attemptedBindingUnboundSize = resultCopy.getUnbindableColumns().size();
            if (attemptedBindingUnboundSize > (firstBindingUnboundSize = firstBindingResult.getUnbindableColumns().size())) {
                return results;
            }
            if (attemptedBindingUnboundSize >= firstBindingUnboundSize) continue;
            results.add(0, resultCopy);
            return results;
        }
        return results;
    }

    static void addMatrixCharts(IDataGroup<IDataColumn> group, Map<String, List<RecommendedVisualization>> chartsPerCombination, List<String> matrixExcludedCharts, Properties config) {
        List<IMatrixDataGroup> matrices = VisualizationMatrixer.getMatrixDataGroups(group, Integer.valueOf(config.getProperty("smarts.visualization.recommender.featureQuantityFewThreshold")), Integer.valueOf(config.getProperty("smarts.visualization.recommender.featureQuantityModerateThreshold")));
        int counter = 0;
        for (IMatrixDataGroup matrix : matrices) {
            ArrayList<String> remainingColumns = new ArrayList<String>();
            for (IDataColumn c : matrix.getChatDataGroup()) {
                remainingColumns.add(c.getName());
            }
            Collections.sort(remainingColumns);
            ArrayList entireMatrixColumns = new ArrayList(remainingColumns);
            matrix.getMatrixRow().ifPresent(row -> entireMatrixColumns.add(row.getName()));
            matrix.getMatrixColumn().ifPresent(column -> entireMatrixColumns.add(column.getName()));
            Collections.sort(entireMatrixColumns);
            List<RecommendedVisualization> recChartsForRemainingColCombination = chartsPerCombination.get(((Object)remainingColumns).toString());
            if (recChartsForRemainingColCombination == null || recChartsForRemainingColCombination.isEmpty()) continue;
            ++counter;
            IRecommendedVisualization firstChoice = null;
            String label = null;
            Iterator<RecommendedVisualization> iterator = recChartsForRemainingColCombination.iterator();
            while (iterator.hasNext() && firstChoice == null) {
                IRecommendedVisualization rec = iterator.next();
                String chart = rec.getLabel();
                if (matrixExcludedCharts.contains(chart)) continue;
                firstChoice = rec;
                label = chart;
            }
            if (firstChoice == null) continue;
            ArrayList<Binding> colbind = new ArrayList<Binding>(firstChoice.getColumnBindings());
            matrix.getMatrixRow().ifPresent(row -> colbind.add(new Binding(Arrays.asList(row.getName()), StdChartElements.MATRIX_ROW.name())));
            matrix.getMatrixColumn().ifPresent(col -> colbind.add(new Binding(Arrays.asList(col.getName()), StdChartElements.MATRIX_COLUMN.name())));
            RecommendedVisualization vis = new RecommendedVisualization(label, (double)Double.valueOf(config.getProperty("smarts.visualization.recommender.minRequiredScore")), -1, ((RecommendedVisualization)firstChoice).getFeatures(), ((Object)entireMatrixColumns).toString());
            vis.setColumnBindings(colbind);
            vis.setMatrixFlag(true);
            String id = VisualizationRecommender.getColNamesCombinationId(entireMatrixColumns.stream());
            List recChartsForEntireColumnCombination = chartsPerCombination.getOrDefault(id, new ArrayList());
            recChartsForEntireColumnCombination.add(vis);
            chartsPerCombination.put(id, recChartsForEntireColumnCombination);
        }
        LOGGER.debug("out of {} matrix combinations {} were matched", (Object)matrices.size(), (Object)counter);
    }

    private static void getValidMatrixColumns(List<IDataColumn> combo, List<IDataColumn> validMatrixColumns, List<IDataColumn> remainingColumns, int featureQuantityFewThreshold, int featureQuantityModerateThreshold) {
        for (IDataColumn c : combo) {
            if (c.hasAnyOfTheseConcepts(Arrays.asList(BasicType.CATEGORY.getOntologyConcept(), BasicType.DATE.getOntologyConcept(), BasicType.LOCATION.getOntologyConcept())) && VisualizationMatrixer.isFewOrModerateCheck(c, featureQuantityFewThreshold, featureQuantityModerateThreshold)) {
                validMatrixColumns.add(c);
                continue;
            }
            remainingColumns.add(c);
        }
    }

    private static List<IMatrixDataGroup> getMatrixDataGroups(IDataGroup<IDataColumn> dataGroup, int featureQuantityFewThreshold, int featureQuantityModerateThreshold) {
        LinkedList<IMatrixDataGroup> res = new LinkedList<IMatrixDataGroup>();
        List combos = dataGroup.getCombintions();
        for (List combo : combos) {
            if (combo.size() < 2) continue;
            List<Object> validMatrixColumns = new LinkedList<IDataColumn>();
            LinkedList<IDataColumn> remainingColumns = new LinkedList<IDataColumn>();
            VisualizationMatrixer.getValidMatrixColumns(combo, validMatrixColumns, remainingColumns, featureQuantityFewThreshold, featureQuantityModerateThreshold);
            if (validMatrixColumns.isEmpty()) continue;
            Map<Integer, List<IDataColumn>> map = validMatrixColumns.stream().collect(Collectors.groupingBy(c -> c.isQuantityUndefined() ? featureQuantityModerateThreshold : c.getQuantity()));
            validMatrixColumns = map.entrySet().stream().sorted((e1, e2) -> Integer.compare((Integer)e2.getKey(), (Integer)e1.getKey())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toCollection(LinkedList::new));
            IDataColumn column = null;
            IDataColumn row = null;
            if (validMatrixColumns.size() >= 2) {
                column = (IDataColumn)validMatrixColumns.remove(0);
                row = (IDataColumn)validMatrixColumns.remove(0);
            } else {
                column = (IDataColumn)validMatrixColumns.remove(0);
            }
            remainingColumns.addAll(validMatrixColumns);
            res.add((IMatrixDataGroup)new MatrixDataGroup(remainingColumns, row, column));
        }
        return res;
    }

    private static boolean isFewOrModerateCheck(IDataColumn column, int featureQuantityFewThreshold, int featureQuantityModerateThreshold) {
        Quantity q = ExtractedFeatureSet.getQuantity((double)featureQuantityFewThreshold, (double)featureQuantityModerateThreshold, column);
        switch (q) {
            case FEW: 
            case MODERATE: {
                return true;
            }
        }
        return false;
    }

    private static boolean attemptBindingMatrixRowAndColumn(SmartsModule dataModule, BindingResult result, ICombinationGenerator generator, int featureQuantityFewThreshold, int featureQuantityModerateThreshold, Optional<Binding> opRow, Optional<Binding> opColumn, Map<String, IFilter> columnFilterMap) throws BindingException {
        Binding row = opRow.isPresent() ? opRow.get() : null;
        Binding column = opColumn.isPresent() ? opColumn.get() : null;
        int originalSize = result.getUnbindableColumns().size();
        Iterator<String> itr = result.getUnbindableColumns().iterator();
        while (itr.hasNext()) {
            String columnID = itr.next();
            IDataColumn unboundCol = generator.getColumn(dataModule, columnID, columnFilterMap, false);
            if (!unboundCol.hasAnyOfTheseConcepts(Arrays.asList(BasicType.CATEGORY.getOntologyConcept(), BasicType.DATE.getOntologyConcept(), BasicType.LOCATION.getOntologyConcept()))) continue;
            Quantity q = ExtractedFeatureSet.getQuantity((double)featureQuantityFewThreshold, (double)featureQuantityModerateThreshold, unboundCol);
            switch (q) {
                case FEW: 
                case MODERATE: {
                    if (opColumn.isPresent() && VisualizationMatrixer.tryHierarchicalBinding(opColumn.get(), unboundCol, generator, columnFilterMap, dataModule)) {
                        itr.remove();
                        break;
                    }
                    if (opRow.isPresent() && VisualizationMatrixer.tryHierarchicalBinding(opRow.get(), unboundCol, generator, columnFilterMap, dataModule)) {
                        itr.remove();
                        break;
                    }
                    if (column == null) {
                        column = new Binding(Arrays.asList(columnID), StdChartElements.MATRIX_COLUMN.name());
                        itr.remove();
                        break;
                    }
                    if (row != null) break;
                    row = new Binding(Arrays.asList(columnID), StdChartElements.MATRIX_ROW.name());
                    itr.remove();
                    break;
                }
            }
        }
        return VisualizationMatrixer.updateResults(result, opRow.isPresent(), row, opColumn.isPresent(), column, originalSize);
    }

    private static boolean updateResults(BindingResult result, boolean inRowPresent, Binding outRow, boolean inColumnPresent, Binding outColumn, int originalSize) {
        if (result.getUnbindableColumns().size() < originalSize) {
            List<Binding> bindings = result.getBinding();
            if (!inRowPresent && outRow != null) {
                bindings.add(outRow);
            }
            if (!inColumnPresent && outColumn != null) {
                bindings.add(outColumn);
            }
            return true;
        }
        return false;
    }

    private static boolean tryHierarchicalBinding(Binding binding, IDataColumn unboundCol, ICombinationGenerator gen, Map<String, IFilter> columnFilterMap, SmartsModule dataModule) throws BindingException {
        ArrayList<IDataColumn> columns = new ArrayList<IDataColumn>();
        for (String c : binding.getColumns()) {
            IDataColumn aCol = gen.getColumn(dataModule, c, columnFilterMap, false);
            if (aCol == null) {
                throw new BindingException("Column not found: " + c);
            }
            columns.add(aCol);
        }
        columns.add(unboundCol);
        if (IDataColumn.formHierarchy(columns).size() == 1) {
            binding.getColumns().add(unboundCol.getIdForExpression());
            return true;
        }
        return false;
    }
}

