/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.charts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.icu.text.MessageFormat;
import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.recommenders.core.utils.VisNLGUtils;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.api.BindingResult;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.IChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnBindingException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnInfoException;
import com.ibm.smarts.visualization.recommender.exceptions.VisRecommenderWrapperException;
import com.ibm.smarts.visualization.recommender.internal.charts.BindingChartElementAlloc;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementFeatureSimilarity;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementType;
import com.ibm.smarts.visualization.recommender.internal.charts.FeatureChartElementAlloc;
import com.ibm.smarts.visualization.recommender.internal.charts.MultiMeasureChartElement;
import com.ibm.smarts.visualization.recommender.internal.learning.LearningUtils;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import com.ibm.smarts.visualization.recommender.schema.charts.ChartElementFeatureMismatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartDescriptor
implements IChartDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartDescriptor.class);
    private static final String ONTOLOGY_CONCEPT_PREFIX = "http://www.ibm.com/ontologies";
    protected String name;
    protected List<ChartElement> elements = new ArrayList<ChartElement>();
    protected PreferenceLevel preference = PreferenceLevel.HIGH;
    private int minDistinctCount;
    private boolean isPredictive;
    private boolean acceptsHierarchicalColumns = true;
    private boolean acceptsNoneAggregation;
    int CANDIDATE_CHART_ELEMENT_LIMIT = 100;
    private String nlgBindingId;
    private static final String SPACE = " ";
    private static final String COLUMN_NAME = "ColumnName";
    private static final String CONCEPT = "Concept";
    private static final String EMPTY_STRING = "";
    private static final String UNIQUE = "Unique";
    private static final String NULLS = "Nulls";
    private static final String HIERARCHY = "Hierarchy";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String IDS_REC_DES_MEASURE = "IDS_REC_DES_MEASURE";
    private static final String IDS_REC_DES_MEASURE_NO_MIN_MAX = "IDS_REC_DES_MEASURE_NO_MIN_MAX";
    private static final String IDS_REC_DES_CATEGORY = "IDS_REC_DES_CATEGORY";
    private static final String IDS_REC_DES_HIERARCHY = "IDS_REC_DES_HIERARCHY";
    private static final String IDS_NULLS = "IDS_NULLS";
    protected String labelId;
    protected String titleId;
    protected String descriptionId;
    protected Map<String, ResourceBundle> resourceBundles = new HashMap<String, ResourceBundle>();
    protected String baseStringName = "strings.visRecommenderStrings";
    private static final String DEFAULT_SHOW_ID = "IDS_SHOW";

    protected ChartDescriptor(String name) {
        this.name = name;
    }

    protected void expandChartElements() {
        ArrayList<ChartElement> expanded = new ArrayList<ChartElement>();
        HashMap<ChartElement, Integer> instances = new HashMap<ChartElement, Integer>();
        for (ChartElement e : this.elements) {
            int instance = instances.getOrDefault(e, 0);
            for (int count = 0; count < e.getMaxOccurence(); ++count) {
                if (e.isMultiMeasure()) {
                    expanded.add(new MultiMeasureChartElement(e, instance++));
                    continue;
                }
                expanded.add(new ChartElement(e, instance++));
            }
            instances.put(e, instance);
        }
        this.elements = expanded;
    }

    @JsonCreator
    public ChartDescriptor(@JsonProperty(value="name") String name, @JsonProperty(value="labelId") String labelId, @JsonProperty(value="titleId") String titleId, @JsonProperty(value="ChartElements") List<ChartElement> elements, @JsonProperty(value="preference") PreferenceLevel preference, @JsonProperty(value="minDistinctCount") Integer minDistinctCount, @JsonProperty(value="nlg") String nlgBindingId, @JsonProperty(value="isPredictive") Boolean isPredictive, @JsonProperty(value="acceptsHierarchicalColumns") Boolean acceptsHierarchicalColumns, @JsonProperty(value="acceptsNoneAggregation") Boolean acceptsNoneAggregation) {
        if (isPredictive != null) {
            this.isPredictive = isPredictive;
        }
        if (acceptsHierarchicalColumns != null) {
            this.acceptsHierarchicalColumns = acceptsHierarchicalColumns;
        }
        if (acceptsNoneAggregation != null) {
            this.acceptsNoneAggregation = acceptsNoneAggregation;
        }
        this.name = name;
        this.elements.addAll(elements);
        this.labelId = labelId != null ? labelId : DEFAULT_SHOW_ID;
        this.titleId = titleId != null ? titleId : DEFAULT_SHOW_ID;
        this.descriptionId = DEFAULT_SHOW_ID;
        this.expandChartElements();
        if (preference != null) {
            this.preference = preference;
        }
        if (minDistinctCount != null) {
            this.minDistinctCount = minDistinctCount;
        }
        this.nlgBindingId = nlgBindingId;
    }

    protected List<ExtractedFeatureSet> assignFeaturesToChartElements(List<ExtractedFeatureSet> features, List<ChartElement> inElements, int minScore) {
        Comparator<ChartElement> comparator = Comparator.comparing(e -> e.getBasicTypes().size()).thenComparing(Comparator.comparing(e -> e.getQuantities().size())).thenComparing(Comparator.comparing(e -> e.getConcept() != null ? 1 : 0));
        LinkedList candidateMappings = new LinkedList(features.stream().filter(f -> {
            int quantity = f.getColumn().getQuantity();
            return quantity >= this.getMinDistinctCount() || f.getColumn().isQuantityUndefined();
        }).collect(Collectors.toMap(Function.identity(), f -> inElements.stream().sorted(comparator).map(e -> e.matchFeature((ExtractedFeatureSet)f)).filter(sim -> sim.getScore() >= minScore).collect(Collectors.toList()), (f1, f2) -> f1)).entrySet());
        Function<Map.Entry, String> getIdForExpression = e -> ((ExtractedFeatureSet)e.getKey()).getColumn().getIdForExpression();
        candidateMappings.sort(Comparator.comparing(getIdForExpression::apply));
        HashSet<ChartElement> elementsToMatch = new HashSet<ChartElement>(inElements);
        Function<Map.Entry, ExtractedFeatureSet> matcher = e -> {
            Optional<ChartElementFeatureSimilarity> match = ((List)e.getValue()).stream().filter(sim -> elementsToMatch.contains(sim.getElement())).findFirst();
            if (match.isPresent()) {
                ChartElementFeatureSimilarity sim2 = match.get();
                elementsToMatch.remove(sim2.getElement());
                ((ExtractedFeatureSet)e.getKey()).setChartElement(sim2.getElement(), sim2.getMismatches());
                return (ExtractedFeatureSet)e.getKey();
            }
            return null;
        };
        return candidateMappings.stream().sorted(Comparator.comparingInt(e -> ((List)e.getValue()).size())).filter(e -> !((List)e.getValue()).isEmpty()).map(matcher).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<Binding> bindChartElements(List<ExtractedFeatureSet> inFeatures) {
        List<ExtractedFeatureSet> mapped = this.assignFeaturesToChartElements(inFeatures, this.elements, ChartElementFeatureMismatch.getMaxMatchScore());
        if (mapped.isEmpty() || mapped.size() != inFeatures.size()) {
            return Collections.emptyList();
        }
        return this.bindColumns(inFeatures);
    }

    private List<String> getHierchicalColumnId(IDataColumn c) {
        return c.getHierarchy().stream().map(IDataColumn::getIdForExpression).collect(Collectors.toList());
    }

    protected List<Binding> bindColumns(List<ExtractedFeatureSet> features) {
        Function<ExtractedFeatureSet, Binding> getBinding = f -> {
            List<String> columns = Arrays.asList(f.getColumn().getIdForExpression());
            ChartElementType binding = f.getChartElement().getCompatibleType(f.getFeatureType());
            if (binding == null) {
                return null;
            }
            if (f.getColumn().isHierchical() && (columns = this.getHierchicalColumnId(f.getColumn())).isEmpty()) {
                return null;
            }
            ChartElement element = this.getElements().stream().filter(e -> e.getType().getSlot().equals(binding.getSlot())).findFirst().get();
            if (element.getConcept().equals(f.getConcept())) {
                return new Binding(columns, binding.getSlot(), f.getConcept(), f.getBindWarnings());
            }
            return new Binding(columns, binding.getSlot(), "NONE", f.getBindWarnings());
        };
        return features.stream().filter(f -> f.getChartElement() != null && f.getFeatureType() != BasicType.NONE && f.getColumn() != null).map(getBinding).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<ChartElement> getElements() {
        return this.elements;
    }

    protected List<List<BindingChartElementAlloc>> getCandidateAllocations(List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, Map<BindingParams, Double> params) throws InvalidColumnBindingException {
        if (bound.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Map<String, List<ExtractedFeatureSet>> columnToFeatures = LearningUtils.getColumnFeatures(boundColumnInfo, params);
            Map<Binding, List<BindingChartElementAlloc>> allocations = bound.stream().flatMap(b -> this.findCandidateElementsForColumn((Binding)b, LearningUtils.getColumnFeature(columnToFeatures, b)).stream().map(fe -> new BindingChartElementAlloc((Binding)b, (FeatureChartElementAlloc)fe))).limit(this.CANDIDATE_CHART_ELEMENT_LIMIT).collect(Collectors.groupingBy(BindingChartElementAlloc::getBinding));
            Function<Binding, List> matchElementBySlotName = b -> {
                List matches = this.elements.stream().filter(e -> b.getSlot().equals(e.getType().getSlot())).collect(Collectors.toList());
                return matches.stream().map(e -> new BindingChartElementAlloc((Binding)b, new FeatureChartElementAlloc(null, (ChartElement)e, Collections.emptySet()))).collect(Collectors.toList());
            };
            Map allocationMap = bound.stream().filter(b -> !allocations.containsKey(b)).map(matchElementBySlotName::apply).filter(list -> !list.isEmpty()).collect(Collectors.toMap(list -> ((BindingChartElementAlloc)list.get(0)).getBinding(), Function.identity()));
            allocations.putAll(allocationMap);
            List<List<BindingChartElementAlloc>> candidateAllocations = this.findAllPossibleAllocations(allocations);
            if (candidateAllocations.stream().filter(c -> !c.isEmpty()).count() == 0L) {
                throw new InvalidColumnBindingException(bound);
            }
            Predicate<List> validate = candidateAllocation -> {
                List solutionBindings = candidateAllocation.stream().map(a -> a.binding).collect(Collectors.toList());
                Predicate<Binding> inSolution = binding -> {
                    List sameSlotMapping = solutionBindings.stream().filter(b -> b.getSlot().equals(binding.getSlot())).collect(Collectors.toList());
                    return sameSlotMapping.stream().anyMatch(b -> b.getColumns().containsAll(binding.getColumns()));
                };
                if (!bound.stream().allMatch(inSolution::test)) {
                    return false;
                }
                Map candidateFreq = candidateAllocation.stream().map(e -> e.binding.getSlot()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                Map slotFreq = this.elements.stream().map(e -> e.getType().getSlot()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                return candidateFreq.entrySet().stream().noneMatch(e -> (Long)e.getValue() > slotFreq.getOrDefault(e.getKey(), 0L));
            };
            return candidateAllocations.stream().filter(validate::test).collect(Collectors.toList());
        }
        catch (VisRecommenderWrapperException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidColumnBindingException) {
                throw (InvalidColumnBindingException)cause;
            }
            LOGGER.warn("Unexpected exception {}", cause);
            return Collections.emptyList();
        }
    }

    private List<Binding> getBindingWithMatchScoreConstraint(List<Binding> bound, List<ChartElement> available, List<ExtractedFeatureSet> unboundFeatures, int minScore) {
        ArrayList<Binding> out = new ArrayList<Binding>(bound);
        List<ExtractedFeatureSet> mapped = this.assignFeaturesToChartElements(unboundFeatures, available, minScore);
        List<Binding> bindings = this.bindColumns(mapped);
        bindings.forEach(b -> unboundFeatures.removeAll(mapped.stream().filter(m -> b.getColumns().contains(m.getColumn().getIdForExpression())).collect(Collectors.toList())));
        out.addAll(bindings);
        return out;
    }

    private List<IBindingResult> getBindingResults(Locale locale, List<Binding> bound, List<ChartElement> available, List<ExtractedFeatureSet> boundFeatures, List<ExtractedFeatureSet> unboundFeatures, boolean forceBinding, Map<String, IDataColumn> boundColumnInfo) {
        ArrayList<IBindingResult> results = new ArrayList<IBindingResult>();
        List<ExtractedFeatureSet> unboundFeaturesCopy = unboundFeatures.stream().collect(Collectors.toList());
        int numberOfAvailableFeatures = available.size();
        List<Binding> bindings = this.getBindingWithMatchScoreConstraint(bound, available, unboundFeaturesCopy, ChartElementFeatureMismatch.getMaxMatchScore());
        List<String> unboundColumns = this.getUnboundColumnsIdForExpressions(unboundFeaturesCopy);
        int numberOfRemainingSlots = numberOfAvailableFeatures - (bindings.size() + bound.size());
        numberOfRemainingSlots = Math.max(numberOfRemainingSlots, 0);
        BindingResult result = this.getBindingResultWithNLG(locale, boundFeatures, unboundFeatures, boundColumnInfo, bindings, unboundColumns, numberOfRemainingSlots);
        results.add(result);
        if (forceBinding && !unboundFeaturesCopy.isEmpty()) {
            unboundFeaturesCopy = unboundFeatures.stream().collect(Collectors.toList());
            List<Binding> secondBinding = this.getBindingWithMatchScoreConstraint(bound, available, unboundFeaturesCopy, ChartElementFeatureMismatch.getTypeMatchMinScore());
            unboundColumns = this.getUnboundColumnsIdForExpressions(unboundFeaturesCopy);
            numberOfRemainingSlots = numberOfAvailableFeatures - bindings.size() + bound.size();
            result = this.getBindingResultWithNLG(locale, boundFeatures, unboundFeatures, boundColumnInfo, secondBinding, unboundColumns, numberOfRemainingSlots);
            results.add(result);
        }
        return results;
    }

    protected List<String> getUnboundColumnsIdForExpressions(List<ExtractedFeatureSet> unboundFeaturesCopy) {
        return unboundFeaturesCopy.stream().flatMap(f -> {
            IDataColumn col = f.getColumn();
            if (col.isHierchical()) {
                return f.getColumn().getHierarchy().stream();
            }
            return Arrays.asList(f.getColumn()).stream();
        }).map(IDataColumn::getIdForExpression).collect(Collectors.toList());
    }

    protected BindingResult getBindingResultWithNLG(Locale locale, List<ExtractedFeatureSet> boundFeatures, List<ExtractedFeatureSet> unboundFeatures, Map<String, IDataColumn> boundColumnInfo, List<Binding> binding, List<String> unboundColumns, int numberOfRemainingSlots) {
        long totalNumberOfSlots;
        long numOfBoundSlots = binding.stream().map(b -> b.getSlot()).distinct().count();
        boolean isMandatorySlotMissing = numOfBoundSlots != (totalNumberOfSlots = this.getElements().stream().map(e -> e.getType().getSlot()).distinct().count());
        BindingResult result = new BindingResult(locale, this.getName(), binding, unboundColumns, numberOfRemainingSlots, this.preference, isMandatorySlotMissing);
        List<ExtractedFeatureSet> features = Stream.concat(boundFeatures.stream(), unboundFeatures.stream()).collect(Collectors.toList());
        Function<ExtractedFeatureSet, List> flattenColumns = feature -> {
            IDataColumn column = feature.getColumn();
            if (column.isHierchical()) {
                return column.getHierarchy();
            }
            return Arrays.asList(column);
        };
        Set<IDataColumn> columns = Stream.concat(boundColumnInfo.entrySet().stream().map(Map.Entry::getValue), features.stream().flatMap(feature -> ((List)flattenColumns.apply((ExtractedFeatureSet)feature)).stream())).collect(Collectors.toSet());
        result.generateNaturalLanguage(locale, this, features, binding, VisRecommenderUtils.getColumnIdNameMap(columns));
        return result;
    }

    @Override
    public List<IBindingResult> bindChartElements(Locale locale, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, Map<BindingParams, Double> params, List<ExtractedFeatureSet> unboundFeatures, boolean forceBinding) throws InvalidColumnBindingException, InvalidColumnInfoException {
        if (bound.isEmpty()) {
            return this.getBindingResults(locale, bound, this.elements.stream().collect(Collectors.toList()), Collections.emptyList(), unboundFeatures, forceBinding, boundColumnInfo);
        }
        List<List<BindingChartElementAlloc>> candidateAllocations = this.getCandidateAllocations(bound, boundColumnInfo, params);
        return candidateAllocations.stream().flatMap(c -> {
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            ArrayList<ChartElement> available = new ArrayList<ChartElement>();
            ArrayList<ExtractedFeatureSet> boundFeatures = new ArrayList<ExtractedFeatureSet>();
            this.prepareParametersForBinding((List<BindingChartElementAlloc>)c, (List<Binding>)bindings, (List<ChartElement>)available, (List<ExtractedFeatureSet>)boundFeatures);
            if (available.isEmpty()) {
                int numberOfRemainingSLots = this.elements.size() - bindings.size();
                List<String> unboundFeatureIds = this.getUnboundColumnsIdForExpressions(unboundFeatures);
                BindingResult result = this.getBindingResultWithNLG(locale, boundFeatures, unboundFeatures, boundColumnInfo, bindings, unboundFeatureIds, numberOfRemainingSLots);
                return Stream.of(result);
            }
            return this.getBindingResults(locale, bindings, available, boundFeatures, unboundFeatures, forceBinding, boundColumnInfo).stream();
        }).filter(Objects::nonNull).sorted(Comparator.comparingInt(b -> b.getUnbindableColumns().size())).collect(Collectors.toList());
    }

    protected void prepareParametersForBinding(List<BindingChartElementAlloc> c, List<Binding> bindings, List<ChartElement> available, List<ExtractedFeatureSet> boundFeatures) {
        bindings.addAll(c.stream().map(i -> new Binding(i.binding.getColumns(), i.binding.getSlot(), i.binding.getConcept(), i.getMismatches())).collect(Collectors.toList()));
        available.addAll(this.elements.stream().filter(e -> !c.stream().map(BindingChartElementAlloc::getElement).collect(Collectors.toList()).contains(e)).collect(Collectors.toList()));
        boundFeatures.addAll(c.stream().map(BindingChartElementAlloc::getFeature).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public boolean validateBindings(List<ExtractedFeatureSet> features, List<Binding> bindings, int minScore) {
        Set availElements = this.elements.stream().collect(Collectors.toSet());
        Function<String, List> getMatchingFeatures = columnId -> features.stream().filter(f -> f.getColumnId().equals(columnId)).collect(Collectors.toList());
        BiFunction<ExtractedFeatureSet, Set, Optional> findMatchingElement = (feature, candidates) -> {
            Optional<ChartElementFeatureSimilarity> match = candidates.stream().map(e -> e.matchFeature((ExtractedFeatureSet)feature)).filter(m -> m.getScore() > minScore).sorted(Comparator.comparingInt(ChartElementFeatureSimilarity::getScore)).findFirst();
            if (match.isPresent()) {
                return Optional.of(match.get().getElement());
            }
            return Optional.empty();
        };
        Predicate<Binding> isValid = b -> {
            List candidateFeatures = (List)getMatchingFeatures.apply((String)b.getColumns().get(0));
            return candidateFeatures.stream().anyMatch(f -> {
                Optional element = (Optional)findMatchingElement.apply((ExtractedFeatureSet)f, availElements);
                if (element.isPresent()) {
                    availElements.remove(element.get());
                    return true;
                }
                return false;
            });
        };
        return bindings.stream().allMatch(isValid::test);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PreferenceLevel getPreference() {
        return this.preference;
    }

    @Override
    public List<ChartElement> getChartElements() {
        return this.elements;
    }

    public String getLabelId() {
        return this.labelId;
    }

    public String getTitleId() {
        return this.titleId;
    }

    @Override
    public PreferenceLevel getPreferenceLevel() {
        return this.preference;
    }

    @Override
    public int getMinDistinctCount() {
        return this.minDistinctCount;
    }

    public String toString() {
        return "ChartDescriptor [name=" + this.name + ", elements=" + this.elements + ", preference=" + (Object)((Object)this.preference) + ", minDistinctCount=" + this.minDistinctCount + "]";
    }

    @Override
    public String getNLGId() {
        return this.nlgBindingId;
    }

    @Override
    public boolean isPredictive() {
        return this.isPredictive;
    }

    @Override
    public boolean acceptsHierarchicalColumns() {
        return this.acceptsHierarchicalColumns;
    }

    @Override
    public boolean acceptsNoneAggregation() {
        return this.acceptsNoneAggregation;
    }

    @Override
    public String getLabel(Map<String, List<String>> parameters, Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        String labelString = this.getStringFromBundle(bundle, this.labelId);
        labelString = VisNLGUtils.removeUnusedParameters(labelString, parameters);
        MessageFormat fLabel = new MessageFormat(labelString, bundle.getLocale());
        return fLabel.format(VisNLGUtils.flattenParameters(parameters));
    }

    @Override
    public String getTitle(Map<String, List<String>> parameters, Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        String titleString = this.getStringFromBundle(bundle, this.titleId);
        titleString = VisNLGUtils.removeUnusedParameters(titleString, parameters);
        MessageFormat fTitle = new MessageFormat(titleString, bundle.getLocale());
        return VisNLGUtils.addMatrix(fTitle.format(VisNLGUtils.flattenParameters(parameters)), parameters, bundle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFeatureConcept(ExtractedFeatureSet feature) {
        String featureConcept = feature.getConcept();
        BasicType featureType = feature.getFeatureType();
        if (featureConcept.contains(ONTOLOGY_CONCEPT_PREFIX)) {
            int index = featureConcept.lastIndexOf(35);
            if (index != -1 && featureConcept.length() > index + 1) {
                return featureConcept.substring(index + 1);
            }
            LOGGER.error("Concept starts with http: , but does not not contain #: {}", (Object)featureConcept);
            return "NONE";
        }
        if (!featureConcept.equals("NONE")) return featureConcept;
        return featureType.name();
    }

    private void getFeatureTypeDescription(ExtractedFeatureSet feature, StringBuilder descriptionBuilder, ResourceBundle bundle) {
        HashMap<String, String> replace = new HashMap<String, String>();
        String columnName = feature.getColumn().getName();
        String featureConcept = this.getFeatureConcept(feature);
        BasicType featureType = feature.getFeatureType();
        String nulls = feature.isNullable() ? this.getStringFromBundle(bundle, IDS_NULLS) : EMPTY_STRING;
        replace.put(COLUMN_NAME, columnName);
        replace.put(CONCEPT, this.getStringFromBundle(bundle, featureConcept));
        replace.put(NULLS, nulls);
        if (featureType == BasicType.MEASURE || featureType == BasicType.DATE) {
            String id = IDS_REC_DES_MEASURE_NO_MIN_MAX;
            if (feature.getColumn().hasStatistic(StatisticType.MIN_VALUE) && feature.getColumn().hasStatistic(StatisticType.MAX_VALUE)) {
                id = IDS_REC_DES_MEASURE;
                replace.put(MIN, feature.getColumn().getMin().stringValue());
                replace.put(MAX, feature.getColumn().getMax().stringValue());
            }
            String baseMeasureString = this.getStringFromBundle(bundle, id);
            MessageFormat fMeasureString = new MessageFormat(baseMeasureString, bundle.getLocale());
            descriptionBuilder.append(fMeasureString.format(replace));
            descriptionBuilder.append(SPACE);
        } else if (featureType == BasicType.CATEGORY || featureType == BasicType.LOCATION) {
            String baseCategoryString = this.getStringFromBundle(bundle, IDS_REC_DES_CATEGORY);
            replace.put(UNIQUE, Integer.toString(feature.getDistinctCount()));
            MessageFormat fCategoryString = new MessageFormat(baseCategoryString, bundle.getLocale());
            descriptionBuilder.append(fCategoryString.format(replace));
            descriptionBuilder.append(SPACE);
        }
    }

    @Override
    public String getDescription(Map<String, List<String>> parameters, List<ExtractedFeatureSet> extractedFeatures, Locale locale) {
        StringBuilder descriptionBuilder = new StringBuilder();
        ResourceBundle bundle = this.getBundle(locale);
        String hierarchyCategoryString = this.getStringFromBundle(bundle, IDS_REC_DES_HIERARCHY);
        for (ExtractedFeatureSet feature : extractedFeatures) {
            HashMap<String, String> replace = new HashMap<String, String>();
            String columnName = feature.getColumn().getName();
            String featureConcept = this.getFeatureConcept(feature);
            String nulls = feature.isNullable() ? this.getStringFromBundle(bundle, IDS_NULLS) : EMPTY_STRING;
            replace.put(COLUMN_NAME, columnName);
            replace.put(CONCEPT, this.getStringFromBundle(bundle, featureConcept));
            replace.put(NULLS, nulls);
            this.getFeatureTypeDescription(feature, descriptionBuilder, bundle);
            descriptionBuilder.append("\n");
            IDataColumn col = feature.getColumn();
            if (!col.isHierchical()) continue;
            List h = col.getHierarchy();
            StringBuilder hierarchyStr = new StringBuilder();
            hierarchyStr.append(((IDataColumn)h.get(0)).getName());
            for (int i = 1; i < h.size(); ++i) {
                hierarchyStr.append(", " + ((IDataColumn)h.get(i)).getName());
            }
            replace.clear();
            replace.put(HIERARCHY, hierarchyStr.toString());
            MessageFormat fCategoryString = new MessageFormat(hierarchyCategoryString, bundle.getLocale());
            descriptionBuilder.append(fCategoryString.format(replace));
            descriptionBuilder.append(SPACE);
            descriptionBuilder.append("\n");
        }
        String result = descriptionBuilder.toString().trim();
        int len1 = result.length();
        if (!result.isEmpty() && result.charAt(len1 - 1) == '\n') {
            result = result.substring(0, len1 - 1).trim();
        }
        return result;
    }

    public ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle = this.resourceBundles.get(locale.toString());
        if (bundle == null) {
            this.resourceBundles.put(locale.toString(), ResourceBundle.getBundle(this.baseStringName, locale));
            bundle = this.resourceBundles.get(locale.toString());
        }
        return bundle;
    }
}

