/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.featureAdapters;

import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.FeatureAdapter;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DualColumnsAdaptor
implements FeatureAdapter {
    @Override
    public List<List<ExtractedFeatureSet>> apply(List<List<ExtractedFeatureSet>> features) {
        Predicate<List> hiDomainDual = featureList -> {
            boolean isMeasure = false;
            boolean isCategory = false;
            boolean isHiDomain = false;
            for (ExtractedFeatureSet feature : featureList) {
                if (feature.getFeatureType().equals((Object)BasicType.MEASURE)) {
                    isMeasure = true;
                    continue;
                }
                isCategory = true;
                if (!feature.getQuantity().equals((Object)Quantity.MANY)) continue;
                isHiDomain = true;
            }
            return isMeasure && isCategory && isHiDomain;
        };
        Map<Boolean, List<List>> hiDomainDualPartition = features.stream().collect(Collectors.partitioningBy(hiDomainDual::test));
        ArrayList<List<ExtractedFeatureSet>> result = new ArrayList<List<ExtractedFeatureSet>>(hiDomainDualPartition.getOrDefault(false, Collections.emptyList()));
        List adapted = hiDomainDualPartition.getOrDefault(true, Collections.emptyList()).stream().map(featureList -> featureList.stream().filter(feature -> feature.getFeatureType().equals((Object)BasicType.MEASURE)).collect(Collectors.toList())).collect(Collectors.toList());
        result.addAll(adapted);
        return result;
    }
}

