/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.learning;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ibm.smarts.common.learning.Sentiment;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.visualization.recommender.internal.learning.RecommenderUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PreferedChart {
    private static final double LEARNING_RATE = 0.2;
    private String chartName;
    private Map<String, List<List<Double>>> bindings;
    private double preference;
    private Set<String> flexibleSlotCapacitySet;
    private Sentiment sentiment = Sentiment.NONE;

    public PreferedChart() {
        this.bindings = new HashMap<String, List<List<Double>>>();
        this.flexibleSlotCapacitySet = new HashSet<String>();
    }

    public PreferedChart(String chartName, Map<String, List<List<Double>>> bindings, double preference) {
        this.chartName = chartName;
        this.bindings = bindings;
        this.preference = preference;
        this.flexibleSlotCapacitySet = Collections.emptySet();
    }

    public PreferedChart(String chartName, Map<String, List<List<Double>>> bindings, double preference, Set<String> flexibleSlotCapacitySet) {
        this(chartName, bindings, preference);
        this.flexibleSlotCapacitySet = new HashSet<String>();
        this.flexibleSlotCapacitySet.addAll(flexibleSlotCapacitySet);
    }

    public String getChartName() {
        return this.chartName;
    }

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    public double getPreference() {
        return this.preference;
    }

    public void setPreference(double preference) {
        this.preference = preference;
    }

    @JsonAnyGetter
    public Map<String, List<List<Double>>> getBindings() {
        return this.bindings;
    }

    @JsonAnySetter
    public void addBindings(String slot, List<List<Double>> vectors) {
        this.bindings.put(slot, vectors);
    }

    public Set<String> getFlexibleSlotCapacitySet() {
        return this.flexibleSlotCapacitySet;
    }

    public void setFlexibleSlotCapacitySet(Set<String> slots) {
        this.flexibleSlotCapacitySet.addAll(slots);
    }

    public Sentiment getSentiment() {
        return this.sentiment;
    }

    public void setSentiment(Sentiment sentiment) {
        this.sentiment = sentiment;
    }

    @JsonIgnore
    public List<List<Double>> getSlotBinding(String slot) {
        return this.bindings.getOrDefault(slot, Collections.emptyList());
    }

    @JsonIgnore
    public Set<String> getSlots() {
        return this.bindings.keySet();
    }

    public void update(Map<String, List<List<Double>>> bindings) {
        BiFunction<Double, Double, Double> weightedSum = (d1, d2) -> 0.8 * d1 + 0.2 * d2;
        ArrayList updatedVectors = new ArrayList();
        bindings.entrySet().forEach(e -> {
            ArrayList<List<Double>> vectors = new ArrayList<List<Double>>();
            vectors.addAll(this.getSlotBinding((String)e.getKey()));
            ((List)e.getValue()).stream().forEach(v -> {
                double maxSim = 0.0;
                int maxIndex = 0;
                for (int index = 0; index < vectors.size(); ++index) {
                    double sim = RecommenderUtil.cosineSimilarity(v, (List)vectors.get(index));
                    if (!(sim > maxSim)) continue;
                    maxSim = sim;
                    maxIndex = index;
                }
                List contextVector = (List)vectors.remove(maxIndex);
                updatedVectors.add(IntStream.range(0, contextVector.size()).mapToObj(i -> (Double)weightedSum.apply((Double)contextVector.get(i), (Double)v.get(i))).collect(Collectors.toList()));
            });
            bindings.put((String)e.getKey(), updatedVectors);
        });
    }

    public void update(Map<String, List<List<Double>>> bindings, double preference) {
        this.preference = preference;
        this.update(bindings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PreferedChart)) {
            return false;
        }
        PreferedChart that = (PreferedChart)o;
        return Double.compare(that.getPreference(), this.getPreference()) == 0 && Objects.equals(this.getChartName(), that.getChartName()) && Objects.equals(this.getBindings(), that.getBindings()) && Objects.equals(this.getFlexibleSlotCapacitySet(), that.getFlexibleSlotCapacitySet()) && this.getSentiment() == that.getSentiment();
    }

    public int hashCode() {
        return Objects.hash(this.getChartName(), this.getBindings(), this.getPreference(), this.getFlexibleSlotCapacitySet(), this.getSentiment());
    }

    public String toString() {
        return "PreferedChart{chartName='" + this.chartName + '\'' + ", bindings=" + this.bindings + ", preference=" + this.preference + ", flexibleSlotCapacitySet=" + this.flexibleSlotCapacitySet + ", sentiment=" + this.sentiment + '}';
    }

    public static PreferedChart fromJSON(String json) {
        return (PreferedChart)CommonJAXBHelper.unmarshalFromJSON(PreferedChart.class, (String)json);
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }
}

