/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.modeling;

import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.internal.charts.Numeric;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import com.ibm.smarts.visualization.recommender.internal.charts.Requirment;
import com.ibm.smarts.visualization.recommender.internal.modeling.AxisType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Axis {
    private static final String COMMA_SEP = ",";
    private static final String SPACE_SEP = " ";
    private final AxisType axisType;
    final Set<BasicType> types;
    final Set<Quantity> quantities;
    final Set<String> concepts;
    private Requirment nullable = Requirment.ANY;
    private Requirment positive = Requirment.ANY;
    private Requirment highVariance = Requirment.ANY;

    public Axis(AxisType axisType, BasicType type, Quantity quantity, String concept) {
        this.axisType = axisType;
        this.types = new HashSet<BasicType>();
        this.types.add(type);
        this.quantities = new HashSet<Quantity>();
        if (quantity == null) {
            this.quantities.add(Quantity.NONE);
        } else {
            this.quantities.add(quantity);
        }
        this.concepts = new HashSet<String>();
        if (concept != null) {
            this.concepts.add(concept);
        }
    }

    public Axis(AxisType axisType, Set<BasicType> types, Set<Quantity> quantities, Set<String> concepts) {
        this.axisType = axisType;
        this.types = types;
        if (quantities == null || quantities.isEmpty()) {
            this.quantities = new HashSet<Quantity>();
            this.quantities.add(Quantity.NONE);
        } else {
            this.quantities = quantities;
        }
        this.concepts = concepts == null ? new HashSet<String>() : concepts;
    }

    public Axis(AxisType axisType, Set<BasicType> types, Set<Quantity> quantities, Set<String> concepts, Requirment nullable, Requirment positive, Requirment highVariance) {
        this(axisType, types, quantities, concepts);
        if (nullable != null) {
            this.nullable = nullable;
        }
        if (positive != null) {
            this.positive = positive;
        }
        if (highVariance != null) {
            this.highVariance = highVariance;
        }
    }

    public Axis(AxisType type) {
        this.axisType = type;
        this.types = new HashSet<BasicType>();
        this.quantities = new HashSet<Quantity>();
        this.concepts = new HashSet<String>();
    }

    public static Axis emptyAxis(AxisType type) {
        Axis axis = new Axis(type);
        axis.types.add(BasicType.NONE);
        axis.quantities.add(Quantity.NONE);
        axis.concepts.add("NONE");
        return axis;
    }

    public Axis(Axis other) {
        this.axisType = other.axisType;
        this.types = new HashSet<BasicType>();
        this.quantities = new HashSet<Quantity>();
        this.concepts = new HashSet<String>();
        this.types.addAll(other.types);
        this.quantities.addAll(other.quantities);
        this.concepts.addAll(other.concepts);
        this.nullable = other.nullable;
        this.positive = other.positive;
        this.highVariance = other.highVariance;
    }

    public Requirment getNullable() {
        return this.nullable;
    }

    public Requirment getPositive() {
        return this.positive;
    }

    public AxisType getAxisType() {
        return this.axisType;
    }

    public Set<BasicType> getTypes() {
        return this.types;
    }

    public Requirment getHighVariance() {
        return this.highVariance;
    }

    public Set<Quantity> getQuantities() {
        return this.quantities;
    }

    public Set<String> getConcepts() {
        return this.concepts;
    }

    public boolean equaluivelant(Object other) {
        if (!(other instanceof Axis)) {
            return false;
        }
        Axis oAxis = (Axis)other;
        return this.axisType == oAxis.getAxisType() && this.types.equals(oAxis.types) && this.quantities.equals(oAxis.quantities) && this.concepts.equals(oAxis.concepts);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.axisType == null ? 0 : this.axisType.hashCode());
        result = 31 * result + (this.concepts == null ? 0 : this.concepts.hashCode());
        result = 31 * result + (this.highVariance == null ? 0 : this.highVariance.hashCode());
        result = 31 * result + (this.nullable == null ? 0 : this.nullable.hashCode());
        result = 31 * result + (this.positive == null ? 0 : this.positive.hashCode());
        result = 31 * result + (this.quantities == null ? 0 : this.quantities.hashCode());
        result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Axis other = (Axis)obj;
        if (this.axisType != other.axisType) {
            return false;
        }
        if (this.concepts == null ? other.concepts != null : !this.concepts.equals(other.concepts)) {
            return false;
        }
        if (this.highVariance != other.highVariance) {
            return false;
        }
        if (this.nullable != other.nullable) {
            return false;
        }
        if (this.positive != other.positive) {
            return false;
        }
        if (this.quantities == null ? other.quantities != null : !this.quantities.equals(other.quantities)) {
            return false;
        }
        return !(this.types == null ? other.types != null : !this.types.equals(other.types));
    }

    private void permute(Set<BasicType> inTypes, Set<Quantity> inQuantities, Set<Axis> collector) {
        collector.addAll(inTypes.stream().flatMap(t -> inQuantities.stream().flatMap(q -> this.concepts.stream().map(c -> new Axis(this.axisType, (BasicType)((Object)t), (Quantity)((Object)((Object)q)), (String)c)))).collect(Collectors.toSet()));
    }

    boolean isSupersetOf(Axis other) {
        return this.axisType == other.axisType && this.types.containsAll(other.types) && this.quantities.containsAll(other.quantities) && this.concepts.containsAll(other.concepts);
    }

    boolean isSubsetOf(Axis other) {
        return other.isSupersetOf(this);
    }

    public List<Axis> subtract(Axis other) {
        HashSet<BasicType> subTypes = new HashSet<BasicType>();
        subTypes.addAll(this.types);
        subTypes.removeAll(other.types);
        HashSet<Quantity> subQuantities = new HashSet<Quantity>();
        subQuantities.addAll(this.quantities);
        subQuantities.removeAll(other.quantities);
        HashSet<String> subConcepts = new HashSet<String>();
        subConcepts.addAll(this.concepts);
        subConcepts.removeAll(other.concepts);
        ArrayList<Axis> result = new ArrayList<Axis>();
        HashSet<Axis> set = new HashSet<Axis>();
        this.permute(subTypes, this.quantities, set);
        this.permute(this.types, subQuantities, set);
        this.permute(this.types, this.quantities, set);
        result.addAll(set);
        return result;
    }

    boolean isInersecting(Axis other) {
        return this.axisType == other.axisType && !Collections.disjoint(this.types, other.types) && !Collections.disjoint(this.quantities, other.quantities) && !Collections.disjoint(this.concepts, other.concepts);
    }

    public Axis getIntersection(Axis other) {
        Axis intersection = new Axis(this.axisType);
        intersection.types.addAll(this.types);
        intersection.quantities.addAll(this.quantities);
        intersection.concepts.addAll(this.concepts);
        intersection.types.retainAll(other.types);
        intersection.quantities.retainAll(other.quantities);
        intersection.concepts.retainAll(other.concepts);
        return intersection;
    }

    public boolean isCategorical() {
        return this.types.contains((Object)BasicType.CATEGORY) || this.types.contains((Object)BasicType.DATE) || this.types.contains((Object)BasicType.LOCATION);
    }

    public boolean isCombinable(Axis other) {
        return this.concepts.containsAll(other.concepts) && this.types.equals(other.types);
    }

    public Axis combine(Axis other) {
        Axis combined = new Axis(this);
        combined.types.addAll(other.types);
        combined.quantities.addAll(other.quantities);
        combined.concepts.addAll(other.concepts);
        return combined;
    }

    public String toString() {
        return (Object)((Object)this.axisType) + SPACE_SEP + this.types.toString() + SPACE_SEP + this.quantities + SPACE_SEP + this.concepts;
    }

    private static String makeRow(List<String> combination) {
        StringBuilder sb = new StringBuilder();
        String feature = combination.get(0);
        if (BasicType.NONE.toString().equals(feature)) {
            sb.append((Object)Quantity.NONE).append(COMMA_SEP).append((Object)Quantity.NONE).append(COMMA_SEP).append((Object)Quantity.NONE).append(COMMA_SEP).append((Object)Quantity.NONE);
        } else if (BasicType.CATEGORY.toString().equals(feature)) {
            sb.append(combination.get(1)).append(COMMA_SEP).append((Object)Quantity.NONE).append(COMMA_SEP).append((Object)Quantity.NONE).append(COMMA_SEP).append((Object)Quantity.NONE);
        } else if (BasicType.DATE.toString().equals(feature)) {
            sb.append((Object)Quantity.NONE).append(COMMA_SEP).append(combination.get(1)).append(COMMA_SEP).append((Object)Quantity.NONE).append(COMMA_SEP).append((Object)Quantity.NONE);
        } else if (BasicType.LOCATION.toString().equals(feature)) {
            sb.append((Object)Quantity.NONE).append(COMMA_SEP).append((Object)Quantity.NONE).append(COMMA_SEP).append(combination.get(1)).append(COMMA_SEP).append((Object)Quantity.NONE);
        } else if (BasicType.MEASURE.toString().equals(feature)) {
            sb.append((Object)Quantity.NONE).append(COMMA_SEP).append((Object)Quantity.NONE).append(COMMA_SEP).append((Object)Quantity.NONE).append(COMMA_SEP).append((Object)Numeric.NUMERIC);
        }
        return sb.toString();
    }

    public List<List<String>> generateExamples() {
        ArrayList rows = new ArrayList();
        ArrayList mix = new ArrayList();
        List typesAsStr = this.types.stream().map(BasicType::toString).collect(Collectors.toList());
        mix.add(typesAsStr);
        List quantitiesAsStr = this.quantities.stream().map(Quantity::toString).collect(Collectors.toList());
        mix.add(quantitiesAsStr);
        List featureQuantity = VisRecommenderUtils.cartesianProduct(mix);
        ArrayList<String> expandedFeatureQuantity = new ArrayList<String>();
        for (List<String> list : featureQuantity) {
            expandedFeatureQuantity.add(Axis.makeRow(list));
        }
        rows.add(expandedFeatureQuantity);
        List conceptsAsStr = this.concepts.stream().collect(Collectors.toList());
        rows.add(conceptsAsStr);
        return VisRecommenderUtils.cartesianProduct(rows);
    }
}

