/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.modeling;

import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.IChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidChartDescriptor;
import com.ibm.smarts.visualization.recommender.internal.RecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import com.ibm.smarts.visualization.recommender.internal.charts.Requirment;
import com.ibm.smarts.visualization.recommender.internal.modeling.Axis;
import com.ibm.smarts.visualization.recommender.internal.modeling.AxisType;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ModelChartDescriptor {
    static final double PREFERENCE_MISMATCH_COST = 0.1;
    static final double LOW_PREFERENCE_COST = 0.4;
    static final double MEDIUM_PREFERENCE_COST = 0.15;
    static final Map<String, List<AxisType>> conceptAxisAffinity = new HashMap<String, List<AxisType>>();
    static final List<AxisType> preferedCategoryAxes = new ArrayList<AxisType>();
    static final List<AxisType> preferedMeasureAxes = new ArrayList<AxisType>();
    private static int id;
    private String name;
    private List<Axis> axes;
    private PreferenceLevel preference = PreferenceLevel.HIGH;
    private String label;
    private final Set<String> equivelants = new HashSet<String>();
    private IChartDescriptor descHl;

    private static int getId() {
        return id++;
    }

    public ModelChartDescriptor(IChartDescriptor descHl, String name, List<Axis> axes, PreferenceLevel preference) {
        this.descHl = descHl;
        this.name = name;
        this.axes = axes;
        if (preference != null) {
            this.preference = preference;
        }
        this.label = "" + ModelChartDescriptor.getId();
    }

    public ModelChartDescriptor(String name) {
        this.name = name;
        this.axes = new ArrayList<Axis>();
        this.label = "" + ModelChartDescriptor.getId();
    }

    public ModelChartDescriptor(ModelChartDescriptor other) {
        this.label = other.label;
        this.name = other.name;
        this.equivelants.addAll(other.equivelants);
        this.axes = other.axes.stream().map(Axis::new).collect(Collectors.toList());
    }

    private static void assignElementsToAxisTypes(IChartDescriptor chart, List<Axis> axes, List<ChartElement> elements, List<AxisType> preferedAxistypes, List<AxisType> remainingAxisTypes) throws InvalidChartDescriptor {
        for (ChartElement element : elements) {
            AxisType axisType;
            if (!preferedAxistypes.isEmpty()) {
                axisType = preferedAxistypes.remove(0);
                axes.set(axisType.getPosition(), element.mapOnAxis(axisType));
            } else if (!remainingAxisTypes.isEmpty()) {
                axisType = remainingAxisTypes.remove(0);
                axes.set(axisType.getPosition(), element.mapOnAxis(axisType));
            } else {
                throw new InvalidChartDescriptor(chart);
            }
            if (element.getConcept().equals("NONE")) continue;
            List types = conceptAxisAffinity.computeIfAbsent(element.getConcept(), k -> new ArrayList());
            types.add(axisType);
        }
    }

    public static ModelChartDescriptor getModelChartDescriptor(IChartDescriptor chart) throws InvalidChartDescriptor {
        ArrayList<Axis> axes = new ArrayList<Axis>();
        Collections.addAll(axes, Axis.emptyAxis(AxisType.X), Axis.emptyAxis(AxisType.Y), Axis.emptyAxis(AxisType.SERIES), Axis.emptyAxis(AxisType.SIZE));
        ArrayList<ChartElement> categoryElements = new ArrayList<ChartElement>();
        ArrayList<ChartElement> measureElements = new ArrayList<ChartElement>();
        ArrayList<AxisType> availCatAxisTypes = new ArrayList<AxisType>(preferedCategoryAxes);
        ArrayList<AxisType> availMeasureAxisTypes = new ArrayList<AxisType>(preferedMeasureAxes);
        for (ChartElement element : chart.getChartElements()) {
            List types;
            List axisTypes;
            AxisType axisType = null;
            if (!(element.getConcept().equals("NONE") || (axisTypes = conceptAxisAffinity.getOrDefault(element.getConcept(), Collections.emptyList())).isEmpty() || (types = axisTypes.stream().filter(aType -> availCatAxisTypes.contains(aType) || availMeasureAxisTypes.contains(aType)).collect(Collectors.toList())).isEmpty())) {
                axisType = (AxisType)((Object)types.get(0));
                axes.set(axisType.getPosition(), element.mapOnAxis(axisType));
            }
            if (element.getBasicTypes().contains((Object)BasicType.MEASURE)) {
                if (axisType != null) {
                    availMeasureAxisTypes.remove((Object)axisType);
                    continue;
                }
                measureElements.add(element);
                continue;
            }
            if (axisType != null) {
                availCatAxisTypes.remove((Object)axisType);
                continue;
            }
            categoryElements.add(element);
        }
        categoryElements = categoryElements.stream().sorted(Comparator.comparing(c -> c.getConcept().equals("NONE") ? 1 : 0).thenComparing(c -> c.getBasicTypes().contains((Object)BasicType.DATE)).thenComparing(c -> c.getBasicTypes().contains((Object)BasicType.LOCATION)).thenComparing(c -> c.getBasicTypes().contains((Object)BasicType.CATEGORY)).thenComparing(c -> c.getQuantities().contains((Object)Quantity.MANY)).thenComparing(c -> c.getQuantities().contains((Object)Quantity.MODERATE))).collect(Collectors.toList());
        ModelChartDescriptor.assignElementsToAxisTypes(chart, axes, categoryElements, availCatAxisTypes, availMeasureAxisTypes);
        ModelChartDescriptor.assignElementsToAxisTypes(chart, axes, measureElements, availMeasureAxisTypes, availCatAxisTypes);
        return new ModelChartDescriptor(chart, chart.getName(), axes, chart.getPreferenceLevel());
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getEquivelants() {
        return this.equivelants;
    }

    public String toString() {
        return this.label + " " + this.name + " " + this.equivelants + " " + this.axes;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    private static ValidationResult validateRequirment(Requirment req, boolean actual) {
        ValidationResult result = ValidationResult.PASS;
        switch (req) {
            case MUST: {
                if (actual) break;
                result = ValidationResult.FAIL;
                break;
            }
            case MUST_NOT: {
                if (!actual) break;
                result = ValidationResult.FAIL;
                break;
            }
            case PREFERED: {
                if (actual) break;
                result = ValidationResult.NOT_PREFERED;
                break;
            }
            case PREFERED_NOT: {
                if (!actual) break;
                result = ValidationResult.NOT_PREFERED;
                break;
            }
        }
        return result;
    }

    private void updateRecommendationScore(RecommendedVisualization recommendation, int violationCount) {
        double score = recommendation.getScore();
        if (violationCount > 0) {
            score -= (double)violationCount * 0.1;
        }
        switch (this.preference) {
            case LOW: {
                score -= 0.4;
                break;
            }
            case MEDIUM: {
                score -= 0.15;
                break;
            }
        }
        recommendation.setScore((double)((int)(score * 100.0)) / 100.0);
    }

    public void updateScore(RecommendedVisualization recommendation) {
        ArrayList<ExtractedFeatureSet> features = new ArrayList<ExtractedFeatureSet>();
        features.addAll(recommendation.getFeatures());
        if ((long)features.size() != this.axes.stream().filter(a -> !Axis.emptyAxis(a.getAxisType()).equals(a)).count()) {
            return;
        }
        int mismatches = 0;
        for (int index = 0; index < features.size(); ++index) {
            DataType dType;
            boolean highVariance;
            Requirment varianceReq;
            boolean positive;
            Requirment posReq;
            boolean nullable;
            int axis = ((ExtractedFeatureSet)features.get(index)).getAxis().getPosition();
            ExtractedFeatureSet feature = (ExtractedFeatureSet)features.get(index);
            Requirment nullReq = this.axes.get(axis).getNullable();
            ValidationResult result = ModelChartDescriptor.validateRequirment(nullReq, nullable = feature.isNullable());
            if (ValidationResult.NOT_PREFERED == result) {
                ++mismatches;
            }
            if (ValidationResult.NOT_PREFERED == (result = ModelChartDescriptor.validateRequirment(posReq = this.axes.get(axis).getPositive(), positive = ((ExtractedFeatureSet)features.get(index)).isPositive()))) {
                ++mismatches;
            }
            if (ValidationResult.NOT_PREFERED == (result = ModelChartDescriptor.validateRequirment(varianceReq = this.axes.get(axis).getHighVariance(), highVariance = feature.isHighVariance()))) {
                ++mismatches;
            }
            if (feature.getFeatureType() != BasicType.CATEGORY || (dType = feature.getColumn().getDataType()) == null || !dType.isNumeric()) continue;
            ++mismatches;
        }
        this.updateRecommendationScore(recommendation, mismatches);
    }

    private boolean validateTypeAndQuantity(BasicType type, int axis, ExtractedFeatureSet feature) {
        if (!(this.axes.get(axis).getTypes().contains((Object)type) && this.axes.get(axis).getConcepts().contains(feature.getConcept()) && this.axes.get(axis).getQuantities().contains((Object)feature.getQuantity()))) {
            return false;
        }
        int quantity = feature.getColumn().getQuantity();
        return feature.getQuantity() == Quantity.NONE || feature.getColumn().isQuantityUndefined() || quantity >= this.descHl.getMinDistinctCount();
    }

    public boolean validate(RecommendedVisualization recommendation) {
        ArrayList<ExtractedFeatureSet> features = new ArrayList<ExtractedFeatureSet>();
        features.addAll(recommendation.getFeatures());
        if ((long)features.size() != this.axes.stream().filter(a -> !Axis.emptyAxis(a.getAxisType()).equals(a)).count()) {
            return false;
        }
        for (int index = 0; index < features.size(); ++index) {
            boolean highVariance;
            boolean positive;
            boolean nullable;
            ExtractedFeatureSet feature;
            int axis;
            BasicType type = ((ExtractedFeatureSet)features.get(index)).getFeatureType();
            if (!this.validateTypeAndQuantity(type, axis = ((ExtractedFeatureSet)features.get(index)).getAxis().getPosition(), feature = (ExtractedFeatureSet)features.get(index))) {
                return false;
            }
            Requirment nullReq = this.axes.get(axis).getNullable();
            ValidationResult result = ModelChartDescriptor.validateRequirment(nullReq, nullable = feature.isNullable());
            if (ValidationResult.FAIL == result) {
                return false;
            }
            Requirment posReq = this.axes.get(axis).getPositive();
            result = ModelChartDescriptor.validateRequirment(posReq, positive = ((ExtractedFeatureSet)features.get(index)).isPositive());
            if (ValidationResult.FAIL == result) {
                return false;
            }
            Requirment varianceReq = this.axes.get(axis).getHighVariance();
            result = ModelChartDescriptor.validateRequirment(varianceReq, highVariance = feature.isHighVariance());
            if (ValidationResult.FAIL != result) continue;
            return false;
        }
        return true;
    }

    public boolean isSupersetOf(ModelChartDescriptor other) {
        for (int index = 0; index < this.axes.size(); ++index) {
            if (this.axes.get(index).isSupersetOf(other.axes.get(index))) continue;
            return false;
        }
        return true;
    }

    public boolean isSubsetOf(ModelChartDescriptor other) {
        for (int index = 0; index < this.axes.size(); ++index) {
            if (this.axes.get(index).isSubsetOf(other.axes.get(index))) continue;
            return false;
        }
        return true;
    }

    public List<ModelChartDescriptor> subtract(ModelChartDescriptor other) {
        ArrayList<ModelChartDescriptor> descriptors = new ArrayList<ModelChartDescriptor>();
        ArrayList subtracts = new ArrayList();
        for (int index = 0; index < this.axes.size(); ++index) {
            List<Axis> sub = this.axes.get(index).subtract(other.axes.get(index));
            subtracts.add(sub);
        }
        List products = VisRecommenderUtils.cartesianProduct(subtracts);
        for (List p : products) {
            ModelChartDescriptor desc = new ModelChartDescriptor(this.name);
            desc.axes.addAll(p);
            desc.addEquivelants(this.getEquivelants());
            if (desc.equaluivelant(this)) continue;
            descriptors.add(desc);
        }
        return descriptors;
    }

    public boolean isIntersecting(ModelChartDescriptor other) {
        for (int index = 0; index < this.axes.size(); ++index) {
            if (this.axes.get(index).isInersecting(other.axes.get(index))) continue;
            return false;
        }
        return true;
    }

    public ModelChartDescriptor getIntersection(ModelChartDescriptor other) {
        ModelChartDescriptor intersection = new ModelChartDescriptor(this.name);
        ArrayList<Axis> intersections = new ArrayList<Axis>();
        for (int index = 0; index < this.axes.size(); ++index) {
            intersections.add(this.axes.get(index).getIntersection(other.axes.get(index)));
        }
        intersection.axes.addAll(intersections);
        intersection.addEquivelants(this.equivelants);
        intersection.addEquivelants(other.equivelants);
        intersection.addEquivelant(other.name);
        return intersection;
    }

    public List<ModelChartDescriptor> subtractIntersection(ModelChartDescriptor intersection) {
        ArrayList<ModelChartDescriptor> descriptors = new ArrayList<ModelChartDescriptor>();
        ArrayList subtracts = new ArrayList();
        for (int index = 0; index < this.axes.size(); ++index) {
            subtracts.add(this.axes.get(index).subtract(intersection.axes.get(index)));
        }
        List products = VisRecommenderUtils.cartesianProduct(subtracts);
        for (List p : products) {
            ModelChartDescriptor desc = new ModelChartDescriptor(this.name);
            desc.axes.addAll(p);
            desc.addEquivelants(this.getEquivelants());
            if (desc.equaluivelant(this) || desc.equaluivelant(intersection)) continue;
            descriptors.add(desc);
        }
        return descriptors;
    }

    public boolean isCombinable(ModelChartDescriptor other) {
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.equivelants.equals(other.equivelants)) {
            return false;
        }
        ArrayList<Integer> categoricalsIndices = new ArrayList<Integer>();
        int lastCategoryIndex = 0;
        for (int index = 0; index < this.axes.size(); ++index) {
            if (this.axes.get(index).isCategorical()) {
                categoricalsIndices.add(index);
                lastCategoryIndex = index;
            }
            if (this.axes.get(index).isCombinable(other.axes.get(index))) continue;
            return false;
        }
        Iterator iterator = categoricalsIndices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (index == lastCategoryIndex || this.axes.get(index).equals(other.axes.get(index))) continue;
            return false;
        }
        return true;
    }

    public ModelChartDescriptor combine(ModelChartDescriptor other) {
        ModelChartDescriptor combined = new ModelChartDescriptor(this);
        combined.equivelants.addAll(other.equivelants);
        for (int index = 0; index < combined.axes.size(); ++index) {
            combined.axes.set(index, combined.axes.get(index).combine(other.axes.get(index)));
        }
        return combined;
    }

    public boolean equaluivelant(Object other) {
        if (!(other instanceof ModelChartDescriptor)) {
            return false;
        }
        ModelChartDescriptor otherModel = (ModelChartDescriptor)other;
        for (int index = 0; index < this.axes.size(); ++index) {
            if (this.axes.get(index).equaluivelant(otherModel.axes.get(index))) continue;
            return false;
        }
        return true;
    }

    public List<String> generateExamples() {
        ArrayList products = new ArrayList();
        for (Axis axis : this.axes) {
            products.add(axis.generateExamples().stream().map(x -> x.toString().replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(" ", "")).collect(Collectors.toList()));
        }
        return VisRecommenderUtils.cartesianProduct(products).stream().map(x -> x.toString().replaceAll(" ", "")).collect(Collectors.toList());
    }

    public void addEquivelant(String equivelant) {
        this.equivelants.add(equivelant);
    }

    public void addEquivelants(Set<String> inEquivelants) {
        this.equivelants.addAll(inEquivelants);
    }

    public IChartDescriptor getHighLevelDescriptor() {
        return this.descHl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.axes == null ? 0 : this.axes.hashCode());
        result = 31 * result + this.equivelants.hashCode();
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.preference == null ? 0 : this.preference.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModelChartDescriptor)) {
            return false;
        }
        ModelChartDescriptor other = (ModelChartDescriptor)obj;
        if (this.axes == null ? other.axes != null : !this.axes.equals(other.axes)) {
            return false;
        }
        if (!this.equivelants.equals(other.equivelants)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.preference == other.preference;
    }

    public List<Axis> getAxes() {
        return this.axes;
    }

    static {
        preferedCategoryAxes.add(AxisType.X);
        preferedCategoryAxes.add(AxisType.SERIES);
        preferedMeasureAxes.add(AxisType.Y);
        preferedMeasureAxes.add(AxisType.SIZE);
        id = 0;
    }

    private static enum ValidationResult {
        PASS,
        FAIL,
        NOT_PREFERED;

    }
}

