/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.similarity.classifier.provider;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.ColumnEmbedding;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.similarity.classifier.common.provider.ISimilarityClassifierProvider;
import com.ibm.smarts.store.api.provider.IPersistenceProvider;
import com.ibm.smarts.store.api.query.IRecord;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimilarityClassifierProvider
implements ISimilarityClassifierProvider {
    private static Logger LOGGER = LoggerFactory.getLogger(SimilarityClassifierProvider.class);
    private RequestContext requestContext;
    private IPersistenceProvider persistenceProvider;

    @Deprecated
    public SimilarityClassifierProvider(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public SimilarityClassifierProvider(RequestContext requestContext, IPersistenceProvider persistenceProvider) {
        this.requestContext = requestContext;
        this.persistenceProvider = persistenceProvider;
    }

    public List<ColumnEmbedding> getColumnEmbeddings(String smartsModuleId) {
        SmartsModuleOptions options = new SmartsModuleOptions.SmartsModuleOptionsBuilder().addColumnEmbedding(true).excludeSmartsData(true).build();
        IRecord record = this.persistenceProvider.get(this.requestContext, smartsModuleId, Collections.emptyList(), options);
        if (record != null) {
            SmartsModule smartsModule = (SmartsModule)record.getRecord();
            List<ColumnEmbedding> columnEmbeddings = SmartsModuleUtil.fetchColumnEmbeddingsFromSmartsModule((SmartsModule)smartsModule);
            return columnEmbeddings != null ? columnEmbeddings : Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

