/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.impl;

import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.MatchedFeature;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.store.api.query.IRecordResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NLUEntityContext {
    private Entity nluEntity;
    private List<MatchedFeature> matchedFeatures = new ArrayList<MatchedFeature>();
    private PhraseInfo nluPhraseInfo;
    private List<ConceptInfo> concepts = new ArrayList<ConceptInfo>();
    private Map<String, Float> highestConceptScoreMap = new HashMap<String, Float>();
    private Map<String, IRecordResult<Feature>> rawResultCache = new HashMap<String, IRecordResult<Feature>>();
    private Map<String, IRecordResult<Feature>> rawResultCacheForConcepts = new HashMap<String, IRecordResult<Feature>>();

    public NLUEntityContext(Entity nluEntity) {
        this.nluEntity = nluEntity;
    }

    public Map<String, IRecordResult<Feature>> getRawResultCacheForConcepts() {
        return this.rawResultCacheForConcepts;
    }

    public void setConcepts(List<ConceptInfo> concepts) {
        this.concepts = concepts;
    }

    public List<ConceptInfo> getConcepts() {
        return this.concepts;
    }

    public Entity getNluEntity() {
        return this.nluEntity;
    }

    public void setNluEntity(Entity nluEntity) {
        this.nluEntity = nluEntity;
    }

    public List<MatchedFeature> getMatchedFeatures() {
        return this.matchedFeatures;
    }

    public void setMatchedFeatures(List<MatchedFeature> matchedFeatures) {
        this.matchedFeatures = matchedFeatures;
    }

    public PhraseInfo getNluPhraseInfo() {
        return this.nluPhraseInfo;
    }

    public void setNluPhraseInfo(PhraseInfo nluPhraseInfo) {
        this.nluPhraseInfo = nluPhraseInfo;
    }

    public Map<String, Float> getHighestConceptScoreMap() {
        return this.highestConceptScoreMap;
    }

    public Map<String, IRecordResult<Feature>> getRawResultCache() {
        return this.rawResultCache;
    }

    public boolean isNewHit(IRecordResult<Feature> hit) {
        return this.rawResultCache.get(hit.getRecord().getId()) == null;
    }

    public void cacheRawSearchResult(IRecordResult<Feature> featureHit) {
        this.rawResultCache.put(featureHit.getRecord().getId(), featureHit);
    }

    public void cacheMultipleRawSearchResults(List<IRecordResult<Feature>> featureHits) {
        featureHits.forEach(hit -> this.rawResultCache.put(hit.getRecord().getId(), (IRecordResult<Feature>)hit));
    }

    public void removeCacheRawSearchResults(IRecordResult<Feature> featureHit) {
        String key = featureHit.getRecord().getId();
        if (this.rawResultCache.containsKey(key)) {
            this.rawResultCache.remove(featureHit.getRecord().getId());
        }
    }

    public void cacheMultipleRawSearchResultsForConcepts(List<IRecordResult<Feature>> featureHits) {
        featureHits.forEach(hit -> this.rawResultCacheForConcepts.put(hit.getRecord().getId(), (IRecordResult<Feature>)hit));
    }

    public void cacheRawSearchResultForConcepts(IRecordResult<Feature> featureHit) {
        this.rawResultCacheForConcepts.put(featureHit.getRecord().getId(), featureHit);
    }
}

