/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.pipeline;

import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.impl.SemanticQueryType;
import com.ibm.smarts.semanticsearch.pipeline.IAnnotator;
import com.ibm.smarts.semanticsearch.util.SemanticSearchHelper;
import com.ibm.smarts.store.api.provider.IFeatureStore;
import com.ibm.smarts.store.api.query.IStoreQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LexicalSearchAnnotator
implements IAnnotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LexicalSearchAnnotator.class);
    private SearchContext searchContext;

    public LexicalSearchAnnotator(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    @Override
    public void accept(NLUEntityContext entityContext) {
        IFeatureStore featureStore = this.searchContext.getStoreProvider().getFeatureStore(this.searchContext.getReqCtx());
        IStoreQuery query = SemanticSearchHelper.buildQuery(this.searchContext.getReqCtx(), featureStore, entityContext.getNluEntity().getText(), this.searchContext.getAssetTypes(), this.searchContext.isInDataValue(), SemanticQueryType.ORIG, this.searchContext.getAssetRefs());
        List featureHits = featureStore.executeSearch(query);
        SemanticSearchHelper.debugRawFeatureHits(featureHits, LOGGER, String.format("querySearch with query: [%s]", entityContext.getNluEntity().getText()));
        SemanticSearchHelper.appendQueryByAssetRefsHitsIfInDataValue(featureHits, this.searchContext, featureStore, entityContext.getNluEntity().getText());
        entityContext.cacheMultipleRawSearchResults(featureHits);
    }
}

