/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ibm.smarts.core.api.IAssetPermissions;
import com.ibm.smarts.core.api.ICredentials;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.exceptions.json.JsonSerializeException;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.Request;
import com.ibm.smarts.core.util.SerializedObject;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestJsonHelper {
    public static final String UUID_FIELD = "uuid";
    public static final String LOCALE_FIELD = "locale";
    public static final String PRODUCTLOCALE_FIELD = "productLocale";
    public static final String IS_TRACING_FIELD = "isTracing";
    public static final String CREDENTIALS_FIELD = "credentials";
    public static final String ATTRIBUTES_FIELD = "attributes";
    private static final String PERMISSIONS_FIELD = "permissions";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestJsonHelper.class);

    public static String toJson(Request req) {
        JsonBuilder bldr = new JsonBuilder(req);
        String ret = bldr.build();
        return ret;
    }

    public static Request fromJson(String json) {
        JsonParser jp = new JsonParser(json);
        Request ret = jp.build();
        return ret;
    }

    private static class JsonParser {
        private final JsonNode jsonNode;

        public JsonParser(String json) {
            this.jsonNode = JsonParserHelper.parseJson(json);
        }

        public Request build() {
            UUID id = UUID.fromString(this.jsonNode.get(RequestJsonHelper.UUID_FIELD).asText());
            Locale locale = LocaleUtils.toLocale((String)this.jsonNode.get(RequestJsonHelper.LOCALE_FIELD).asText());
            Locale productLocale = this.jsonNode.get(RequestJsonHelper.PRODUCTLOCALE_FIELD) != null ? LocaleUtils.toLocale((String)this.jsonNode.get(RequestJsonHelper.PRODUCTLOCALE_FIELD).asText()) : Locale.ENGLISH;
            boolean isTracing = this.jsonNode.get(RequestJsonHelper.IS_TRACING_FIELD).asBoolean();
            ICredentials creds = (ICredentials)this.deserializeNode(this.jsonNode.get(RequestJsonHelper.CREDENTIALS_FIELD));
            IAssetPermissions perms = (IAssetPermissions)this.deserializeNode(this.jsonNode.get(RequestJsonHelper.PERMISSIONS_FIELD));
            Request req = new Request(id, locale, productLocale, creds, perms, isTracing);
            ObjectNode attrNode = (ObjectNode)this.jsonNode.get(RequestJsonHelper.ATTRIBUTES_FIELD);
            this.setAttributes(req, attrNode);
            return req;
        }

        private void setAttributes(Request req, ObjectNode jn) {
            Iterator iter = jn.fields();
            while (iter.hasNext()) {
                Map.Entry field = (Map.Entry)iter.next();
                String key = (String)field.getKey();
                JsonNode value = (JsonNode)field.getValue();
                SerializedObject so = JsonParserHelper.parseJson(value, SerializedObject.class);
                Object obj = so.toInstance();
                req.setAttribute(key, obj);
            }
        }

        private <T> T deserializeNode(JsonNode jn) {
            Object ret;
            if (jn != null) {
                SerializedObject so = JsonParserHelper.parseJson(jn, SerializedObject.class);
                ret = so.toInstance();
            } else {
                ret = null;
            }
            return (T)ret;
        }
    }

    private static class JsonBuilder {
        private final Request req;
        private final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;

        public JsonBuilder(Request req) {
            this.req = req;
        }

        public String build() {
            try {
                JsonNode permsNode;
                ObjectNode rcNode = this.nodeFactory.objectNode();
                rcNode.put(RequestJsonHelper.UUID_FIELD, this.req.uuid.toString());
                rcNode.put(RequestJsonHelper.LOCALE_FIELD, this.req.locale.toString());
                rcNode.put(RequestJsonHelper.IS_TRACING_FIELD, this.req.isTracing);
                JsonNode credsNode = this.serializeValue(this.req.credentials);
                if (credsNode != null) {
                    rcNode.put(RequestJsonHelper.CREDENTIALS_FIELD, credsNode);
                }
                if ((permsNode = this.serializeValue(this.req.permissions)) != null) {
                    rcNode.put(RequestJsonHelper.PERMISSIONS_FIELD, permsNode);
                }
                ObjectNode attrNode = this.getAttributes();
                rcNode.set(RequestJsonHelper.ATTRIBUTES_FIELD, (JsonNode)attrNode);
                return rcNode.toString();
            }
            catch (Throwable e) {
                throw new JsonSerializeException(e, "Failed to generate JSON", this.req);
            }
        }

        private ObjectNode getAttributes() {
            ObjectNode ret = this.nodeFactory.objectNode();
            for (String key : this.req.attributes.keySet()) {
                Object value = this.req.attributes.get(key);
                JsonNode attrNode = null;
                try {
                    attrNode = this.serializeValue(value);
                }
                catch (Throwable th) {
                    LOGGER.error("failed to serialize request context attribute " + key, th);
                }
                if (attrNode == null) continue;
                ret.put(key, attrNode);
            }
            return ret;
        }

        private <T> JsonNode serializeValue(T value) {
            JsonNode ret;
            if (value != null) {
                SerializedObject so;
                try {
                    so = SerializedObject.from(value);
                }
                catch (Throwable th) {
                    throw new InternalException(th, "Could not create SerializedObject from " + value, new Object[0]);
                }
                try {
                    ret = JsonParserHelper.toJsonNode(so);
                }
                catch (Throwable th) {
                    throw new InternalException(th, "Could not convert SerializedObject to JSON: " + so, new Object[0]);
                }
            }
            ret = null;
            return ret;
        }
    }
}

