/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.async.AsyncMetrics;
import com.ibm.smarts.core.util.AbstractMetrics;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RestMetrics
extends AbstractMetrics<RestMetrics> {
    private final ConcurrentHashMap<String, PathMetrics> pathMetrics;
    private final PathMetrics overall;

    public RestMetrics() {
        this(new PathMetrics(null, null), new ConcurrentHashMap<String, PathMetrics>());
    }

    private RestMetrics(PathMetrics overall, ConcurrentHashMap<String, PathMetrics> pathMetrics) {
        this.overall = overall;
        this.pathMetrics = pathMetrics;
    }

    public PathMetrics forPath(String path, String query) {
        PathMetrics ret = this.pathMetrics.computeIfAbsent(path, p -> new PathMetrics(this.overall, (String)p));
        ret.addQueryString(query);
        return ret;
    }

    @Override
    public boolean isTouched() {
        return RestMetrics.isTouched(this.pathMetrics.values());
    }

    @Override
    public long firstTouchNanos() {
        return RestMetrics.firstTouchNanos(this.pathMetrics.values());
    }

    @Override
    public long lastTouchNanos() {
        return RestMetrics.lastTouchNanos(this.pathMetrics.values());
    }

    public RestMetrics combine(RestMetrics other) {
        PathMetrics newOverall = this.overall.combine(null, other.overall);
        HashSet paths = new HashSet();
        paths.addAll(this.pathMetrics.keySet());
        paths.addAll(other.pathMetrics.keySet());
        ConcurrentHashMap<String, PathMetrics> map = new ConcurrentHashMap<String, PathMetrics>();
        for (String path : paths) {
            PathMetrics thisMetrics = this.pathMetrics.get(path);
            PathMetrics otherMetrics = other.pathMetrics.get(path);
            PathMetrics pm = RestMetrics.maybeCombine(newOverall, thisMetrics, otherMetrics);
            map.put(path, pm);
        }
        return new RestMetrics(newOverall, map);
    }

    private static PathMetrics maybeCombine(PathMetrics overall, PathMetrics left, PathMetrics right) {
        if (left != null && right != null) {
            return left.combine(overall, right);
        }
        if (left == null) {
            return right.combine(overall, new PathMetrics(overall, right.path));
        }
        return left.combine(overall, new PathMetrics(overall, left.path));
    }

    @Override
    public String toString(boolean pretty, int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("[RestMetrics");
        for (String path : this.allPaths()) {
            PathMetrics pm = this.forPath(path, null);
            sb.append(RestMetrics.linePrefix(pretty, indent) + pm.toString(pretty, indent + 1));
        }
        sb.append(RestMetrics.linePrefix(pretty, indent) + "overall=" + this.overall.toString(pretty, indent + 1));
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }

    private String[] allPaths() {
        Object[] ret = ((ConcurrentHashMap.CollectionView)((Object)this.pathMetrics.keySet())).toArray(new String[this.pathMetrics.size()]);
        Arrays.sort(ret);
        return ret;
    }

    public static class PathMetrics
    extends AbstractMetrics<PathMetrics> {
        private final PathMetrics parent;
        public final String path;
        public final Set<String> queryStrings;
        public final AsyncMetrics get;
        public final AsyncMetrics put;
        public final AsyncMetrics post;
        public final AsyncMetrics delete;

        public PathMetrics(PathMetrics parent, String path) {
            this(parent, path, new HashSet<String>(), new AsyncMetrics(parent != null ? parent.get : null), new AsyncMetrics(parent != null ? parent.put : null), new AsyncMetrics(parent != null ? parent.post : null), new AsyncMetrics(parent != null ? parent.delete : null));
        }

        private PathMetrics(PathMetrics parent, String path, Set<String> queryStrings, AsyncMetrics get, AsyncMetrics put, AsyncMetrics post, AsyncMetrics delete) {
            this.parent = parent;
            this.path = path;
            this.queryStrings = queryStrings;
            this.get = get;
            this.put = put;
            this.post = post;
            this.delete = delete;
        }

        public synchronized void addQueryString(String q) {
            if (q != null) {
                this.queryStrings.add(q);
            }
        }

        @Override
        public boolean isTouched() {
            return PathMetrics.isTouched((AbstractMetrics[])new AsyncMetrics[]{this.get, this.put, this.post, this.delete});
        }

        @Override
        public long firstTouchNanos() {
            return PathMetrics.firstTouchNanos((AbstractMetrics[])new AsyncMetrics[]{this.get, this.put, this.post, this.delete});
        }

        @Override
        public long lastTouchNanos() {
            return PathMetrics.lastTouchNanos((AbstractMetrics[])new AsyncMetrics[]{this.get, this.put, this.post, this.delete});
        }

        public PathMetrics combine(PathMetrics newParent, PathMetrics other) {
            HashSet<String> qs = new HashSet<String>();
            qs.addAll(this.queryStrings);
            qs.addAll(other.queryStrings);
            return new PathMetrics(newParent, this.path, qs, this.get.combine(newParent != null ? newParent.get : null, other.get), this.put.combine(newParent != null ? newParent.put : null, other.put), this.post.combine(newParent != null ? newParent.post : null, other.post), this.delete.combine(newParent != null ? newParent.delete : null, other.delete));
        }

        @Override
        public String toString(boolean pretty, int indent) {
            StringBuilder sb = new StringBuilder();
            sb.append("[PathMetrics");
            if (this.path != null) {
                sb.append(" path=" + this.path);
            }
            if (this.queryStrings.size() > 0) {
                sb.append(" uniqueQueries=" + this.queryStrings.size());
            }
            PathMetrics.maybeAppend(sb, pretty, indent, this.get, "get");
            PathMetrics.maybeAppend(sb, pretty, indent, this.put, "put");
            PathMetrics.maybeAppend(sb, pretty, indent, this.post, "post");
            PathMetrics.maybeAppend(sb, pretty, indent, this.delete, "delete");
            sb.append("]");
            String ret = sb.toString();
            return ret;
        }

        private static void maybeAppend(StringBuilder sb, boolean pretty, int indent, AsyncMetrics am, String name) {
            if (am.isTouched()) {
                sb.append(PathMetrics.linePrefix(pretty, indent) + name + "=" + am.toString(pretty, indent + 1));
            }
        }
    }
}

