/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.exceptions.InternalException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Sha1HashBuilder {
    private final MessageDigest digest;
    private final byte[] buffer = new byte[20];
    private final ByteBuffer bb;
    private final byte[] newline = "\n".getBytes();
    private final byte[] blank = " ".getBytes();

    public Sha1HashBuilder() {
        try {
            this.digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalException((Throwable)e, "Creating Sha1HashBuilder", new Object[0]);
        }
        this.bb = ByteBuffer.wrap(this.buffer);
        this.bb.mark();
    }

    public void update(int i) {
        this.bb.reset();
        this.bb.putInt(i);
        this.digest.update(this.buffer, 0, 4);
        this.blank();
    }

    public void update(double d) {
        this.bb.reset();
        this.bb.putDouble(d);
        this.digest.update(this.buffer, 0, 8);
        this.blank();
    }

    public void update(String s) {
        this.digest.update(s.getBytes());
        this.blank();
    }

    public void update(String s, double d) {
        this.update(s);
        this.update(d);
    }

    public void update(String s, int i, int j) {
        this.update(s);
        this.update(i);
        this.update(j);
    }

    public void updateNewline() {
        this.digest.update(this.newline);
    }

    public void blank() {
        this.digest.update(this.blank);
    }

    public String getDigest() {
        byte[] bytes = this.digest.digest();
        return Sha1HashBuilder.bytesToHex(bytes);
    }

    public static String bytesToHex(byte[] b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < b.length; ++j) {
            buf.append(hexDigit[b[j] >> 4 & 0xF]);
            buf.append(hexDigit[b[j] & 0xF]);
        }
        return buf.toString();
    }
}

