/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public final class StacktraceHelper {
    private static final String NEWLINE = System.getProperty("line.separator");

    private StacktraceHelper() {
    }

    public static String getCurrentFrames(int from, int count, String prefix) {
        Exception e = new Exception();
        StackTraceElement[] frames = e.getStackTrace();
        StringBuilder sb = new StringBuilder();
        if (frames != null && frames.length > from + 1) {
            for (int i = from + 1; i < count + from + 1; ++i) {
                if (i >= frames.length) continue;
                if (prefix != null) {
                    sb.append(prefix);
                }
                sb.append(frames[i] + "\n");
            }
        }
        String ret = sb.toString();
        return ret;
    }

    public static String getStacktrace() {
        Exception e = new Exception();
        String sRet = StacktraceHelper.getStacktrace(e);
        return sRet;
    }

    public static String getStacktrace(Throwable throwable) {
        String sStacktrace = null;
        StackTraceElement[] trace = throwable.getStackTrace();
        StringWriter stringWriter = new StringWriter(trace.length * 256);
        PrintWriter pw = new PrintWriter((Writer)stringWriter, true);
        for (int i = 0; i < trace.length; ++i) {
            pw.println("\tat " + trace[i]);
        }
        pw.close();
        sStacktrace = stringWriter.toString();
        return sStacktrace;
    }

    public static String trimStacktraceStart(String sStacktrace, String sToTrim) {
        String sTextBefore;
        int nLastNL;
        String sRet = sStacktrace;
        int i = sRet.indexOf(sToTrim);
        if (i > -1 && (nLastNL = (sTextBefore = sStacktrace.substring(0, i)).lastIndexOf(NEWLINE)) > -1) {
            sRet = sStacktrace.substring(nLastNL += NEWLINE.length());
        }
        return sRet;
    }

    public static String trimStacktraceEnd(String sStacktrace, String sToTrim) {
        int nLastNL;
        String sRet = sStacktrace;
        int i = sRet.indexOf(sToTrim);
        if (i > -1 && (nLastNL = (sRet = sStacktrace.substring(0, i)).lastIndexOf(NEWLINE)) > -1) {
            sRet = sStacktrace.substring(0, nLastNL);
        }
        return sRet;
    }
}

