/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.flow;

import com.ibm.dltj.uima_annotator.flow.FixedFlowStage;
import com.ibm.dltj.uima_annotator.flow.IFlowStage;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMA_UnsupportedOperationException;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class ChunkFlowStage
implements IFlowStage {
    private final String _chunkerId;
    private final String _mergerId;
    private final List<IFlowStage> _stages;
    private int _currStageIndex;

    public ChunkFlowStage(String string, List<IFlowStage> list, String string2) {
        this._chunkerId = string;
        this._mergerId = string2;
        this._stages = new ArrayList<IFlowStage>(2 + list.size());
        this._stages.add(new FixedFlowStage(this._chunkerId));
        this._stages.addAll(list);
        this._stages.add(new FixedFlowStage(this._mergerId));
    }

    String getMergerId() {
        return this._mergerId;
    }

    public List<IFlowStage> getStages() {
        return this._stages;
    }

    @Override
    public void reset() {
        this._currStageIndex = 0;
        for (IFlowStage iFlowStage : this._stages) {
            iFlowStage.reset();
        }
    }

    @Override
    public boolean hasNext(CAS cAS) throws AnalysisEngineProcessException {
        while (this._currStageIndex < this._stages.size()) {
            IFlowStage iFlowStage = this._stages.get(this._currStageIndex);
            if (iFlowStage.hasNext(cAS)) {
                return true;
            }
            ++this._currStageIndex;
        }
        return false;
    }

    @Override
    public String next() throws AnalysisEngineProcessException {
        IFlowStage iFlowStage = this._stages.get(this._currStageIndex);
        return iFlowStage.next();
    }

    void newCasProduced(String string, Logger logger) throws AnalysisEngineProcessException {
        logger.log(Level.INFO, Messages.getMessage("ChunkFlowState.newcas"));
        if (string.equals(this._chunkerId)) {
            this._currStageIndex = 1;
            for (int i = 1; i < this._stages.size(); ++i) {
                this._stages.get(i).reset();
            }
        } else if (!string.equals(this._mergerId)) {
            throw new UIMA_UnsupportedOperationException("cas_multiplier_not_supported", new Object[]{this.getClass().getName()});
        }
    }

    @Override
    public void describe(int n, Logger logger) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(Messages.getMessage("ChunkFlowState.name"));
        logger.log(Level.CONFIG, stringBuilder.toString());
        for (IFlowStage iFlowStage : this._stages) {
            iFlowStage.describe(n + 1, logger);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ChunkFlowStage");
        stringBuilder.append("[index=").append(this._currStageIndex);
        if (this._currStageIndex >= 0 && this._currStageIndex < this._stages.size()) {
            stringBuilder.append(",stage=").append(this._stages.get(this._currStageIndex));
        }
        stringBuilder.append(']');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

