/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.uima_annotator.lex_analysis.AnnotationsCreator;
import com.ibm.dltj.util.ArrayUtils;
import com.ibm.dltj.util.ListBase;
import com.ibm.dltj.util.PooledListHandler;
import com.ibm.dltj.util.StringBufferCharacterIterator;
import com.ibm.langware.annotator.Copyright;
import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public final class TokenInfo
extends PooledListHandler<LemmaEntry, TokenInfo> {
    public int addr;
    public int begin;
    public int end;
    public int wclass;
    public boolean skipped = false;
    public BasicType type;

    public TokenInfo() {
        super((ListBase)new LemmaEntry());
    }

    public void reset(int n, int n2, int n3, BasicType basicType) {
        this.type = basicType;
        this.begin = n;
        this.end = n2;
        this.wclass = n3;
        this.addr = 0;
        this.clear();
        this.skipped = false;
    }

    public void accommodate(int n, BasicType basicType) {
        this.type = this.type.promote(basicType);
        this.wclass = Math.max(this.wclass, n);
    }

    public TokenInfo createNew() {
        return new TokenInfo();
    }

    public String toString() {
        return (Object)((Object)this.type) + super.toString();
    }

    public static enum RetainmentPolicy implements Comparator<LemmaEntry>
    {
        BEST_ONLY{

            @Override
            public void apply(TokenInfo tokenInfo) {
                assert (tokenInfo.size() >= 1);
                tokenInfo.clear();
                tokenInfo.commitItem();
            }

            @Override
            public int compare(LemmaEntry lemmaEntry, LemmaEntry lemmaEntry2) {
                assert (false);
                return 0;
            }
        }
        ,
        UNIQUE_LEMMA_STRING_AND_POS{

            @Override
            public void apply(TokenInfo tokenInfo) {
                tokenInfo.removeDuplicates(this);
            }

            @Override
            public int compare(LemmaEntry lemmaEntry, LemmaEntry lemmaEntry2) {
                int n = lemmaEntry.pos;
                int n2 = lemmaEntry2.pos;
                if (n != n2) {
                    return n - n2;
                }
                String string = lemmaEntry.getLemmaString();
                String string2 = lemmaEntry2.getLemmaString();
                if (string == null) {
                    if (string2 != null) {
                        return 1;
                    }
                    return 0;
                }
                return string.compareTo(string2);
            }
        }
        ,
        UNIQUE_LEMMA_STRING{

            @Override
            public void apply(TokenInfo tokenInfo) {
                tokenInfo.removeDuplicates(this);
            }

            @Override
            public int compare(LemmaEntry lemmaEntry, LemmaEntry lemmaEntry2) {
                String string = lemmaEntry.getLemmaString();
                String string2 = lemmaEntry2.getLemmaString();
                if (string == null) {
                    if (string2 != null) {
                        return 1;
                    }
                    return 0;
                }
                return string.compareTo(string2);
            }
        };


        public abstract void apply(TokenInfo var1);
    }

    public static enum BasicType {
        UNKNOWN(false, true),
        PUNCTUATION(false, true),
        MWU(true, false){

            @Override
            void performAnnotation(AnnotationsCreator annotationsCreator, TokenInfo tokenInfo) throws AnalysisEngineProcessException {
                tokenInfo.addr = annotationsCreator.createNewMWUAnnotation(tokenInfo);
            }
        }
        ,
        MWU_ANNOTATED(true, false){

            @Override
            void performAnnotation(AnnotationsCreator annotationsCreator, TokenInfo tokenInfo) throws AnalysisEngineProcessException {
            }
        }
        ,
        STD_GENERIC(false, true),
        STD(true, true),
        COMPOUND(false, true){

            @Override
            void performAnnotation(AnnotationsCreator annotationsCreator, TokenInfo tokenInfo) throws AnalysisEngineProcessException {
                tokenInfo.addr = annotationsCreator.createNewCompoundAnnotation(tokenInfo, false);
            }
        }
        ,
        COMPOUND_MATCHED(true, true){

            @Override
            void performAnnotation(AnnotationsCreator annotationsCreator, TokenInfo tokenInfo) throws AnalysisEngineProcessException {
                tokenInfo.addr = annotationsCreator.createNewCompoundAnnotation(tokenInfo, true);
            }
        };

        final boolean isDictMatch;
        public final boolean isTagged;

        private BasicType(boolean bl, boolean bl2) {
            this.isDictMatch = bl;
            this.isTagged = bl2;
        }

        public BasicType promote(BasicType basicType) {
            if (this == COMPOUND && basicType.isDictMatch || basicType == COMPOUND && this.isDictMatch) {
                return COMPOUND_MATCHED;
            }
            if (this == MWU ^ basicType == MWU) {
                return STD;
            }
            return basicType.ordinal() > this.ordinal() ? basicType : this;
        }

        void performAnnotation(AnnotationsCreator annotationsCreator, TokenInfo tokenInfo) throws AnalysisEngineProcessException {
            tokenInfo.addr = annotationsCreator.createNewTokenAnnotation(tokenInfo, annotationsCreator.isInCompound());
        }
    }

    public static final class LemmaEntry
    extends ListBase<LemmaEntry> {
        private String lemmaString;
        public String surfaceString;
        public LemmaGenerator lemmaGloss;
        public int pos;
        public int stop;
        public int constraints;
        public int[] morphBitMaskArray = ArrayUtils.EMPTY_INT_ARRAY;
        public int extPos;
        public int jpStart;
        public int jkom;
        public int annoReference;
        int fsReference;
        public Object tag;

        public LemmaEntry() {
        }

        public LemmaEntry(LemmaEntry lemmaEntry) {
            this.lemmaString = lemmaEntry.lemmaString;
            this.lemmaGloss = lemmaEntry.lemmaGloss;
            this.surfaceString = lemmaEntry.surfaceString;
            this.pos = lemmaEntry.pos;
            this.stop = lemmaEntry.stop;
            this.constraints = lemmaEntry.constraints;
            this.morphBitMaskArray = lemmaEntry.morphBitMaskArray;
            this.extPos = lemmaEntry.extPos;
            this.jpStart = lemmaEntry.jpStart;
            this.jkom = lemmaEntry.jkom;
            this.fsReference = lemmaEntry.fsReference;
        }

        public void reset() {
            this.lemmaString = null;
            this.lemmaGloss = null;
            this.surfaceString = null;
            this.pos = 0;
            this.stop = 0;
            this.constraints = 0;
            this.morphBitMaskArray = ArrayUtils.EMPTY_INT_ARRAY;
            this.extPos = 0;
            this.jpStart = 0;
            this.jkom = 0;
            this.fsReference = 0;
            this.annoReference = 0;
            this.tag = null;
        }

        public LemmaEntry createNew() {
            return new LemmaEntry();
        }

        public String getLemmaString() {
            if (this.lemmaString == null) {
                if (this.lemmaGloss != null) {
                    try {
                        this.lemmaString = this.lemmaGloss.getLemma((CharacterIterator)new StringBufferCharacterIterator((CharSequence)this.surfaceString), 0, this.surfaceString.length());
                    }
                    catch (DLTException dLTException) {
                        // empty catch block
                    }
                }
                if (this.lemmaString == null || this.lemmaString.length() == 0) {
                    this.lemmaString = this.surfaceString;
                }
            }
            return this.lemmaString;
        }

        public void setLemmaString(String string) {
            this.lemmaString = string;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.pos;
            n = 31 * n + this.stop;
            n = 31 * n + this.constraints;
            n = 31 * n + (this.surfaceString == null ? 0 : this.surfaceString.hashCode());
            n = 31 * n + (this.lemmaGloss == null ? 0 : this.lemmaGloss.hashCode());
            n = 31 * n + Arrays.hashCode(this.morphBitMaskArray);
            n = 31 * n + this.extPos;
            n = 31 * n + this.jkom;
            n = 31 * n + this.jpStart;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            LemmaEntry lemmaEntry = (LemmaEntry)((Object)object);
            if (this.pos != lemmaEntry.pos) {
                return false;
            }
            if (this.stop != lemmaEntry.stop) {
                return false;
            }
            if (this.constraints != lemmaEntry.constraints) {
                return false;
            }
            if (this.lemmaGloss != lemmaEntry.lemmaGloss) {
                String string = this.getLemmaString();
                String string2 = lemmaEntry.getLemmaString();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return false;
                }
            }
            if (this.morphBitMaskArray != lemmaEntry.morphBitMaskArray) {
                return false;
            }
            if (this.surfaceString == null ? lemmaEntry.surfaceString != null : !this.surfaceString.equals(lemmaEntry.surfaceString)) {
                return false;
            }
            if (this.extPos != lemmaEntry.extPos) {
                return false;
            }
            if (this.jkom != lemmaEntry.jkom) {
                return false;
            }
            return this.jpStart == lemmaEntry.jpStart;
        }

        public String toString() {
            return this.lemmaString + "(" + this.tag + ")";
        }
    }
}

