/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis.es;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.data.DecompositionRuleSetFactory;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.uima_annotator.AnalyzerContext;
import com.ibm.dltj.uima_annotator.lex_analysis.AnnotationsCreator;
import com.ibm.dltj.uima_annotator.lex_analysis.LexicalAnalyzer;
import com.ibm.dltj.uima_annotator.lex_analysis.LexicalAnalyzerContext;
import com.ibm.dltj.uima_annotator.lex_analysis.ResultHandler;
import com.ibm.dltj.uima_annotator.lex_analysis.es.AnnotationsCreatorOF;
import com.ibm.dltj.uima_annotator.lex_analysis.es.ConfigurationMgrOF;
import com.ibm.dltj.uima_annotator.lex_analysis.es.LexicalAnalyzerOFContext;
import com.ibm.dltj.uima_annotator.lex_analysis.es.ResultHandlerOF;
import com.ibm.dltj.uima_annotator.lex_analysis.es.ResultHandlerQP;
import com.ibm.dltj.uima_annotator.lex_analysis.es.ResultHandlerSegmentation;
import com.ibm.dltj.uima_annotator.lex_analysis.es.ResultSpecMgrOF;
import com.ibm.dltj.uima_annotator.util.Language;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import com.ibm.langware.annotator.jFrostAEProcessException;
import java.text.CharacterIterator;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class LexicalAnalyzerOF
extends LexicalAnalyzer {
    private static final String CLASS_NAME = LexicalAnalyzerOF.class.getName();
    private final LexicalAnalyzerOFContext mContext = (LexicalAnalyzerOFContext)this.getContext();
    private final ConfigurationMgrOF mConfigMgr = (ConfigurationMgrOF)this.mContext.getConfigurationManager();
    private final ResultSpecMgrOF mRsltSpecMgr = (ResultSpecMgrOF)this.mContext.getResultSpecManager();
    protected final AnnotationsCreatorOF mAnnoCreator;
    private final ResultHandlerQP mResultHandlerQP;
    protected UniLexAnalyzer mQueryAnalyzer = null;
    protected static String mQuerySessionLocale = "eu";

    public LexicalAnalyzerOF(UimaContext uimaContext) throws ResourceInitializationException {
        super(uimaContext);
        this.mAnnoCreator = (AnnotationsCreatorOF)((LexicalAnalyzer)this).mAnnoCreator;
        this.mResultHandlerQP = this.mConfigMgr.mQueryProcessingMode ? new ResultHandlerQP(this.mAnnoCreator) : null;
    }

    @Override
    protected synchronized void processText(CharacterIterator characterIterator, ParsingStream parsingStream) throws AnalysisEngineProcessException {
        super.processText(characterIterator, parsingStream);
        if (this.mConfigMgr.mQueryProcessingMode) {
            if (this.mRsltSpecMgr.mIsTokenReq) {
                this.doQueryProcessingStep(characterIterator, ResultHandlerQP.QueryProcessingType.BOOST);
                this.doQueryProcessingStep(characterIterator, ResultHandlerQP.QueryProcessingType.STOP);
                this.doQueryProcessingStep(characterIterator, ResultHandlerQP.QueryProcessingType.SYN);
            } else {
                this.doQueryProcessingPretokenized(characterIterator, ResultHandlerQP.QueryProcessingType.BOOST);
                this.doQueryProcessingPretokenized(characterIterator, ResultHandlerQP.QueryProcessingType.STOP);
                this.doQueryProcessingPretokenized(characterIterator, ResultHandlerQP.QueryProcessingType.SYN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doQueryProcessingStep(CharacterIterator characterIterator, ResultHandlerQP.QueryProcessingType queryProcessingType) throws AnalysisEngineProcessException {
        if (!queryProcessingType.shouldApply(this.mRsltSpecMgr)) {
            return;
        }
        Dictionary[] dictionaryArray = this.mContext.mLanguageDicts.getDictsOfType(queryProcessingType.dictionaryType);
        if (dictionaryArray == null || dictionaryArray.length == 0) {
            this.mContext.logMsg(Level.CONFIG, CLASS_NAME, "processText", Messages.MessageKeys.LexicalAnalyzerOF__No_Query_dictionaries_found__CONFIG.name(), (Object)queryProcessingType);
            return;
        }
        queryProcessingType.processTokensInCompounds(this.mAnnoCreator, dictionaryArray, characterIterator);
        try {
            this.mResultHandlerQP.type = queryProcessingType;
            if (this.mContext.mLanguageDicts.getLanguage().isLanguageOfType(Language.LanguageType.EU)) {
                this.mUniLexAnalyzer = this.openSession(this.mUniLexAnalyzer, dictionaryArray, this.mContext.mLanguageDicts.getLanguage().getLanguageFullName());
                this.mUniLexAnalyzer.processText(characterIterator, (ParsingStream)this.mResultHandlerQP);
            } else {
                this.mQueryAnalyzer = this.openSession(this.mQueryAnalyzer, dictionaryArray, mQuerySessionLocale);
                this.mQueryAnalyzer.processText(characterIterator, (ParsingStream)this.mResultHandlerQP);
            }
        }
        catch (DLTException dLTException) {
            this.mContext.logError(Level.WARNING, Messages.getFormattedMessage(Messages.MessageKeys.LexicalAnalyzerOF__Error_Retrieve_X_for_Query__WARNING.name(), new Object[]{queryProcessingType}), (Exception)((Object)dLTException));
        }
        finally {
            this.closeSession(this.mUniLexAnalyzer);
            this.closeSession(this.mQueryAnalyzer);
        }
    }

    private void doQueryProcessingPretokenized(CharacterIterator characterIterator, ResultHandlerQP.QueryProcessingType queryProcessingType) {
        if (!queryProcessingType.shouldApply(this.mRsltSpecMgr)) {
            return;
        }
        Dictionary[] dictionaryArray = this.mContext.mLanguageDicts.getDictsOfType(queryProcessingType.dictionaryType);
        if (dictionaryArray == null || dictionaryArray.length == 0) {
            this.mContext.logMsg(Level.CONFIG, CLASS_NAME, "processText", Messages.MessageKeys.LexicalAnalyzerOF__No_Query_dictionaries_found__CONFIG.name(), (Object)queryProcessingType);
            return;
        }
        this.mAnnoCreator.processPreTokenizedQuery(dictionaryArray, characterIterator, queryProcessingType);
    }

    @Override
    protected void adjustConfiguration(Language.LanguageType languageType) {
        super.adjustConfiguration(languageType);
        this.mConfigMgr.mDecompositionEnabled |= this.mRsltSpecMgr.mIsCompoundAnnoReq;
        if (this.mConfigMgr.mQueryProcessingMode && this.mConfigMgr.mCreateDecompStructure) {
            this.mConfigMgr.mCreateDecompStructure = false;
            this.mConfigMgr.mCreateCompoundPartsInsteadOfToken = true;
        } else {
            this.mConfigMgr.mCreateDecompStructure = this.mConfigMgr.mCreateDecompStructure_ConfigVal;
            this.mConfigMgr.mCreateCompoundPartsInsteadOfToken = this.mConfigMgr.mCreateCompoundPartsInsteadOfToken_ConfigVal;
        }
    }

    protected UniLexAnalyzer openSession(UniLexAnalyzer uniLexAnalyzer, Dictionary[] dictionaryArray, String string) throws AnalysisEngineProcessException {
        try {
            if (uniLexAnalyzer == null) {
                uniLexAnalyzer = UniLexAnalyzer.getUniLexAnalyzer((String)string);
                if (this.mContext.mLanguageDicts.mBreakRulesSpec != null && this.mContext.mLanguageDicts.mBreakRulesSpec.length() != 0) {
                    uniLexAnalyzer.setBreakIteratorByFilename(this.mContext.mLanguageDicts.mBreakRulesSpec);
                }
                if (this.mContext.mLanguageDicts.mDecompositionRulesSpec != null && this.mContext.mLanguageDicts.mDecompositionRulesSpec.length() != 0) {
                    uniLexAnalyzer.setDecompositionRules(DecompositionRuleSetFactory.getDecompositionRulesByFilename((String)this.mContext.mLanguageDicts.mDecompositionRulesSpec));
                }
            }
            uniLexAnalyzer.setDictionaries(dictionaryArray, null, null);
            uniLexAnalyzer.setCaseStrictMode(this.mConfigMgr.mUseStrictCaseMode);
            uniLexAnalyzer.open(this.mConfigMgr.mUseFirstMatchPolicy ? 1 : 0, LexicalAnalyzerOF.getOptions(this.mConfigMgr.mDecompositionEnabled, this.mConfigMgr.mReturnOnlyFirstLevelOfCompoundBreakdown, this.mConfigMgr.mCrossDictionaryDecomposition, this.mConfigMgr.mBOFAOnlyDecomposition, this.mConfigMgr.mBreakOnHyphens, this.mConfigMgr.mFilterDecompositions, this.mConfigMgr.mStandaloneDecomposition), LexicalAnalyzerOF.getSpecificOptions(this.mConfigMgr.mJaDeepWordBreak, this.mConfigMgr.mAggressiveSentenceBreaks));
        }
        catch (DLTException dLTException) {
            this.closeSession(uniLexAnalyzer);
            throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.FROST_EXCEPTION_ENCOUNTERED__SEVERE.name(), new Object[0], dLTException);
        }
        return uniLexAnalyzer;
    }

    @Override
    protected AnnotationsCreatorOF getNewAnnotationsCreatorInstance(LexicalAnalyzerContext lexicalAnalyzerContext) {
        return new AnnotationsCreatorOF(lexicalAnalyzerContext);
    }

    @Override
    protected ResultHandler getNewResultHandlerInstance(LexicalAnalyzerContext lexicalAnalyzerContext, AnnotationsCreator annotationsCreator, CharacterIterator characterIterator) {
        ConfigurationMgrOF configurationMgrOF = (ConfigurationMgrOF)lexicalAnalyzerContext.getConfigurationManager();
        return configurationMgrOF.mDoSegmentation4RBBI ? new ResultHandlerSegmentation(lexicalAnalyzerContext, annotationsCreator, characterIterator) : new ResultHandlerOF(lexicalAnalyzerContext, annotationsCreator, characterIterator);
    }

    @Override
    protected AnalyzerContext getNewAnalyzerContextInstance(UimaContext uimaContext) throws ResourceInitializationException {
        return new LexicalAnalyzerOFContext(uimaContext);
    }
}

