/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.corenlp.analyzer;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.nlp.core.corenlp.analyzer.PostProcessor;
import com.ibm.smarts.nlp.core.corenlp.analyzer.PreProcessor;
import com.ibm.smarts.nlp.core.corenlp.annotator.LemmaAnnotatorLW;
import com.ibm.smarts.nlp.core.corenlp.annotator.TokenOverrides;
import com.ibm.smarts.nlp.core.corenlp.fastload.FastLoadHelper;
import com.ibm.smarts.nlp.core.corenlp.fastload.StanfordCoreNLPFastLoad;
import com.ibm.smarts.nlp.core.corenlp.posmapping.POSMapper;
import com.ibm.smarts.nlp.pipeline.IAnnotatorFactory;
import com.ibm.smarts.nlp.pipeline.PipelineInstance;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.HeadFinder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreNLPResourceManager {
    private static final Logger log = LoggerFactory.getLogger(CoreNLPResourceManager.class);
    private static final String PIPELINE_NAME = "pipeline_";
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static final String DOT_PROPERTIES = ".properties";
    private static final String PROCESSING_SETTINGS_NAME = "processingSettings_";
    private static final String HEAD_FINDER = "corenlp.headfinder";
    private static final String POS_MAPPER = "corenlp.posmapper";
    private static final String PRE_PROCESSOR = "preprocessor";
    private static final String POST_PROCESSOR = "postprocessor";
    private static Map<String, Properties> processingSettings = new ConcurrentHashMap<String, Properties>();
    private static IAnnotatorFactory factory = new IAnnotatorFactory(){

        public Annotator createLemmaAnnotatorLW(String name, Properties props) {
            return new LemmaAnnotatorLW(name, props);
        }

        public Annotator createTokenOverrides(String name, Properties props) {
            return new TokenOverrides(name, props);
        }
    };

    public static synchronized void loadPipelineAndSettings() {
        CoreNLPResourceManager.loadPipeline(DEFAULT_LOCALE);
        CoreNLPResourceManager.loadProcessingSettings(DEFAULT_LOCALE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPipeline(Locale locale) {
        Class<PipelineInstance> clazz = PipelineInstance.class;
        synchronized (PipelineInstance.class) {
            PipelineInstance pipeline = PipelineInstance.getInstance((IAnnotatorFactory)factory);
            if (!pipeline.getMap().containsKey(locale.getLanguage())) {
                String pipelineFile = CoreNLPResourceManager.buildPropertyFileName(PIPELINE_NAME, locale);
                InputStream resource = CoreNLPResourceManager.class.getResourceAsStream(pipelineFile);
                StanfordCoreNLPFastLoad instance = null;
                if (resource != null) {
                    try {
                        Properties props = new Properties();
                        props.load(resource);
                        instance = FastLoadHelper.useFastLoader() ? new StanfordCoreNLPFastLoad(props) : new StanfordCoreNLP(props);
                        log.info("corenlp pipeline loaded for: {} ", (Object)locale.getLanguage());
                        System.out.println("Loaded CoreNLP pipeline for " + locale.getLanguage());
                    }
                    catch (IOException e) {
                        log.error("Failed to load pipeline for language " + locale.getLanguage(), (Throwable)e);
                        throw new InternalException((Throwable)e, "can't load corenlp pipeline with properties '" + pipelineFile + "' for language " + locale.getLanguage(), new Object[0]);
                    }
                } else {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                pipeline.getMap().put(locale.getLanguage(), instance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static String buildPropertyFileName(String fileName, Locale locale) {
        return fileName + locale.getLanguage() + DOT_PROPERTIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StanfordCoreNLP getPipeline(Locale locale) {
        Class<PipelineInstance> clazz = PipelineInstance.class;
        synchronized (PipelineInstance.class) {
            PipelineInstance pipeline = PipelineInstance.getInstance((IAnnotatorFactory)factory);
            if (!pipeline.getMap().containsKey(locale.getLanguage())) {
                CoreNLPResourceManager.loadPipeline(locale);
            }
            if (pipeline.getMap().containsKey(locale.getLanguage())) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return (StanfordCoreNLP)pipeline.getMap().get(locale.getLanguage());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (StanfordCoreNLP)pipeline.getMap().get(DEFAULT_LOCALE.getLanguage());
        }
    }

    private static void loadProcessingSettings(Locale locale) {
        Properties props = new Properties();
        InputStream resource = CoreNLPResourceManager.class.getResourceAsStream(CoreNLPResourceManager.buildPropertyFileName(PROCESSING_SETTINGS_NAME, locale));
        if (resource == null) {
            processingSettings.put(locale.getLanguage(), props);
            return;
        }
        try {
            props.load(resource);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load processingSettings properties file for language " + locale.getLanguage(), e);
        }
        processingSettings.put(locale.getLanguage(), props);
    }

    public static HeadFinder getHeadFinder(Locale locale) {
        return (HeadFinder)CoreNLPResourceManager.getProcessingInstance(locale, HEAD_FINDER);
    }

    public static POSMapper getPOSMapper(Locale locale) {
        return (POSMapper)CoreNLPResourceManager.getProcessingInstance(locale, POS_MAPPER);
    }

    public static PreProcessor getPreProcessor(Locale locale) {
        return (PreProcessor)CoreNLPResourceManager.getProcessingInstance(locale, PRE_PROCESSOR);
    }

    public static PostProcessor getPostProcessor(Locale locale) {
        return (PostProcessor)CoreNLPResourceManager.getProcessingInstance(locale, POST_PROCESSOR);
    }

    public static Object getProcessingInstance(Locale locale, String name) {
        Properties props;
        if (!processingSettings.containsKey(locale.getLanguage())) {
            CoreNLPResourceManager.loadProcessingSettings(locale);
        }
        if ((props = processingSettings.get(locale.getLanguage())) == null || props.isEmpty()) {
            props = processingSettings.get(DEFAULT_LOCALE.getLanguage());
        }
        if (props != null && props.containsKey(name)) {
            String hfName = props.getProperty(name);
            try {
                Class<?> implClass = Class.forName(hfName);
                Object hf = implClass.newInstance();
                return hf;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to find class " + hfName, e);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to instantiate " + hfName, e);
            }
        }
        return null;
    }
}

