/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.logic;

import com.ibm.smarts.nlp.api.grammar.PartOfSpeech;
import com.ibm.smarts.nlp.api.grammar.Significance;
import com.ibm.smarts.nlp.api.utility.DomainObjectAssembler;
import com.ibm.smarts.nlp.core.corenlp.analyzer.CoreNLPResourceManager;
import com.ibm.smarts.nlp.core.corenlp.analyzer.PostProcessor;
import com.ibm.smarts.nlp.core.corenlp.domain.CoreNLPResults;
import com.ibm.smarts.schema.ParseTreeNode;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TokenInfo;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assembler<T> {
    private final DomainObjectAssembler<T> domAssembler;
    PostProcessor postProcessor;
    protected static final Logger LOGGER = LoggerFactory.getLogger(Assembler.class);

    public Assembler(DomainObjectAssembler<T> domAssembler, Locale locale) {
        this.domAssembler = domAssembler;
        this.postProcessor = CoreNLPResourceManager.getPostProcessor(locale);
    }

    public ParseTreeNode assembleParseTree(HeadFinder hf, T results) {
        List tokens = this.domAssembler.assembleTokenInfo(results, Collections.emptyMap());
        Tree tree = ((CoreNLPResults)results).getParseTree();
        if (LOGGER.isDebugEnabled()) {
            tree.pennPrint();
        }
        HashMap<Tree, TokenInfo> leafToTokenMap = new HashMap<Tree, TokenInfo>();
        List leaves = tree.getLeaves();
        if (leaves.size() != tokens.size()) {
            throw new RuntimeException("leaves not equal to tokens");
        }
        for (int i = 0; i < tokens.size(); ++i) {
            leafToTokenMap.put((Tree)leaves.get(i), (TokenInfo)tokens.get(i));
        }
        ParseTreeNode root = this.convertTree(hf, tree, leafToTokenMap, null);
        return root;
    }

    private ParseTreeNode convertTree(HeadFinder hf, Tree tree, Map<Tree, TokenInfo> leafToTokenMap, ParseTreeNode parent) {
        ParseTreeNode node = null;
        if (tree.isPhrasal()) {
            Tree head = tree.headTerminal(hf);
            TokenInfo headToken = leafToTokenMap.get(head);
            if (this.postProcessor.shouldBeHead(headToken)) {
                headToken.setSignificance(Significance.IMPORTANT);
            }
            ParseTreeNode newTree = new ParseTreeNode();
            newTree.setParent(parent);
            newTree.setPartOfSpeech(PartOfSpeech.getPOS((String)tree.label().value()).toString());
            newTree.setHead(headToken);
            node = newTree;
            for (Tree child : tree.getChildrenAsList()) {
                ParseTreeNode childNode = this.convertTree(hf, child, leafToTokenMap, node);
                node.getChildren().add(childNode);
            }
        } else if (tree.isPreTerminal() || tree.isLeaf()) {
            Tree leaf = tree.isPreTerminal() ? tree.getChild(0) : tree;
            TokenInfo token = leafToTokenMap.get(leaf);
            ParseTreeNode newTree = new ParseTreeNode();
            newTree.setParent(parent);
            newTree.setPartOfSpeech(PartOfSpeech.getPOS((String)tree.label().value()).toString());
            newTree.setToken(token);
            newTree.setHead(null);
            node = newTree;
        } else {
            throw new RuntimeException("Error: Tree is should be either phrasal, PreTerminal or leaf");
        }
        return node;
    }

    public List<PhraseInfo> assemblePhrasesFromParseTree(HeadFinder hf, T results) {
        List tokens = this.domAssembler.assembleTokenInfo(results, Collections.emptyMap());
        Tree tree = ((CoreNLPResults)results).getParseTree();
        if (LOGGER.isDebugEnabled()) {
            tree.pennPrint();
        }
        HashMap<Tree, TokenInfo> leafToTokenMap = new HashMap<Tree, TokenInfo>();
        List leaves = tree.getLeaves();
        if (leaves.size() != tokens.size()) {
            throw new RuntimeException("leaves not equal to tokens");
        }
        for (int i = 0; i < tokens.size(); ++i) {
            leafToTokenMap.put((Tree)leaves.get(i), (TokenInfo)tokens.get(i));
        }
        List<PhraseInfo> phrases = null;
        phrases = this.postProcessor.convertTreeToPhrases(hf, tree, leafToTokenMap, tokens);
        return this.postProcessor.assembleEntities((CoreNLPResults)results, phrases, tokens.size());
    }
}

