/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.tasks;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.logging.PerformanceLogger;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.nlp.core.utility.PrettyNameUtil;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenizeColumnsTaskImpl {
    private final Logger LOGGER = LoggerFactory.getLogger(TokenizeColumnsTaskImpl.class);
    private SmartNLP nlp = null;

    public void execute(SmartsTaskContext taskContext) throws InternalException {
        String smartsId = taskContext.getSmartsModuleId();
        String datasetId = taskContext.getDatasetId();
        PerformanceLogger.get().info((Object)(smartsId + "." + datasetId));
        RequestContext rc = taskContext.getRequestContext();
        IStoreProvider storeProvider = taskContext.getStoreProvider();
        this.nlp = (SmartNLP)taskContext.getProperty("nlp");
        IInMemoryModuleStore store = storeProvider.getModuleStore(rc);
        if (store == null) {
            throw new InternalException("No in-memory store found", new Object[0]);
        }
        StoreStatus moduleStatus = store.apply(smartsId, sm -> {
            if (sm.getLabel() == null && sm.getName() != null) {
                sm.setLabel(this.describe(rc, sm.getName()));
            }
            if (sm.getDescriptionLabel() == null && sm.getDescription() != null) {
                if (sm.getDescription().equals(sm.getName())) {
                    sm.setDescriptionLabel(sm.getLabel());
                } else {
                    sm.setDescriptionLabel(this.describe(rc, sm.getDescription()));
                }
            }
            if (sm.getCommentLabel() == null && sm.getComment() != null) {
                sm.setCommentLabel(this.describe(rc, sm.getComment()));
            }
            return sm;
        });
        if (moduleStatus == null || !moduleStatus.isSuccess()) {
            this.LOGGER.error("SmartsModule: {}, failed to store labels.", (Object)smartsId);
            throw new InternalException("SmartsModule: {}, failed to store labels.", new Object[]{smartsId});
        }
        NLPInfo datasetNLPInfo = new NLPInfo();
        HashMap<String, NLPInfo> columnsMap = new HashMap<String, NLPInfo>();
        DeltaAnalysisScope deltaAnalysisScope = taskContext.getDeltaAnalysisScope(DeltaAnalysisScope.ScopedTask.TOKENIZE);
        boolean bTokenizeAll = deltaAnalysisScope == null || DeltaAnalysisScope.ScopedColumns.ALL == deltaAnalysisScope.getScopedColumns();
        store.apply(smartsId, datasetId, dsInfo -> {
            if (bTokenizeAll) {
                return this.collectAllDatasetAndColumnInfoForTokenizing(datasetNLPInfo, (Map<String, NLPInfo>)columnsMap, (DatasetInfo)dsInfo);
            }
            return this.collectDeltaDatasetAndColumnInfoForTokenizing(deltaAnalysisScope, datasetNLPInfo, (Map<String, NLPInfo>)columnsMap, (DatasetInfo)dsInfo);
        });
        TextInfo dsNameTextInfo = null;
        TextInfo dsDescriptionTextInfo = null;
        TextInfo dsCommentTextInfo = null;
        if (datasetNLPInfo.name != null) {
            dsNameTextInfo = this.describe(rc, datasetNLPInfo.name);
        }
        if (datasetNLPInfo.description != null) {
            dsDescriptionTextInfo = datasetNLPInfo.description.equals(datasetNLPInfo.name) ? dsNameTextInfo : this.describe(rc, datasetNLPInfo.description);
        }
        if (datasetNLPInfo.comment != null) {
            dsCommentTextInfo = this.describe(rc, datasetNLPInfo.comment);
        }
        DescribedNLPInfo describedDatasetNLPInfo = new DescribedNLPInfo(dsNameTextInfo, dsDescriptionTextInfo, dsCommentTextInfo);
        HashMap describedColumnsMap = new HashMap();
        columnsMap.forEach((colId, colNLPInfo) -> {
            TextInfo colNameTextInfo = null;
            TextInfo colDescriptionTextInfo = null;
            TextInfo colCommentTextInfo = null;
            if (((NLPInfo)colNLPInfo).name != null) {
                colNameTextInfo = this.describe(rc, ((NLPInfo)colNLPInfo).name);
            }
            if (((NLPInfo)colNLPInfo).description != null) {
                colDescriptionTextInfo = ((NLPInfo)colNLPInfo).description.equals(((NLPInfo)colNLPInfo).name) ? colNameTextInfo : this.describe(rc, ((NLPInfo)colNLPInfo).description);
            }
            if (((NLPInfo)colNLPInfo).comment != null) {
                colCommentTextInfo = this.describe(rc, ((NLPInfo)colNLPInfo).comment);
            }
            describedColumnsMap.put(colId, new DescribedNLPInfo(colNameTextInfo, colDescriptionTextInfo, colCommentTextInfo));
        });
        StoreStatus status = store.apply(smartsId, datasetId, dsInfo -> {
            if (describedDatasetNLPInfo.getLabel() != null && dsInfo.getLabel() == null && dsInfo.getName() != null) {
                dsInfo.setLabel(describedDatasetNLPInfo.getLabel());
            }
            if (dsInfo.getDescriptionLabel() == null && dsInfo.getDescription() != null) {
                if (dsInfo.getDescription().equals(dsInfo.getName()) && describedDatasetNLPInfo.getLabel() != null) {
                    dsInfo.setDescriptionLabel(describedDatasetNLPInfo.getLabel());
                } else if (describedDatasetNLPInfo.getDescriptionLabel() != null) {
                    dsInfo.setDescriptionLabel(describedDatasetNLPInfo.getDescriptionLabel());
                }
            }
            if (describedDatasetNLPInfo.getCommentLabel() != null && dsInfo.getCommentLabel() == null && dsInfo.getComment() != null) {
                dsInfo.setCommentLabel(describedDatasetNLPInfo.getCommentLabel());
            }
            SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dsInfo).forEach(colInfo -> {
                String colId = colInfo.getId();
                DescribedNLPInfo describedColumnInfo = describedColumnsMap.getOrDefault(colId, null);
                if (describedColumnInfo == null) {
                    return;
                }
                if (describedColumnInfo.getLabel() != null && colInfo.getName() != null) {
                    colInfo.setLabel(describedColumnInfo.getLabel());
                }
                if (colInfo.getDescriptionLabel() == null && colInfo.getDescription() != null) {
                    if (colInfo.getDescription().equals(colInfo.getName()) && describedColumnInfo.getLabel() != null) {
                        colInfo.setDescriptionLabel(describedColumnInfo.getLabel());
                    } else if (describedColumnInfo.getDescriptionLabel() != null) {
                        colInfo.setDescriptionLabel(describedColumnInfo.getDescriptionLabel());
                    }
                }
                if (describedColumnInfo.getCommentLabel() != null && colInfo.getCommentLabel() == null && colInfo.getComment() != null) {
                    colInfo.setCommentLabel(describedColumnInfo.getCommentLabel());
                }
            });
            PrettyNameUtil.setDatasetPrettyNames(dsInfo, (Boolean)taskContext.getProperty("moduleHasOverwrites"), (Boolean)taskContext.getProperty("prettifyLabels"));
            return dsInfo;
        });
        if (status == null || !status.isSuccess()) {
            this.LOGGER.error("SmartsModule: {} | Dataset: {} failed to store labels.", (Object)smartsId, (Object)datasetId);
            throw new InternalException("SmartsModule: {} | Dataset: {} failed to store labels.", new Object[]{smartsId, datasetId});
        }
        PerformanceLogger.get().info((Object)(smartsId + "." + datasetId));
    }

    private DatasetInfo collectDeltaDatasetAndColumnInfoForTokenizing(DeltaAnalysisScope deltaAnalysisScope, NLPInfo datasetNLPInfo, Map<String, NLPInfo> columnsMap, DatasetInfo dsInfo) {
        Set datasetModifiedProperties = deltaAnalysisScope.getDatasetPropertiesDelta();
        if (!datasetModifiedProperties.isEmpty()) {
            boolean bDatasetModifiedPropertiesAll = datasetModifiedProperties.contains(DeltaAnalysisScope.ModifiableProperty.ALL);
            if (bDatasetModifiedPropertiesAll || datasetModifiedProperties.contains(DeltaAnalysisScope.ModifiableProperty.NAME)) {
                datasetNLPInfo.setName(dsInfo.getName());
            }
            if (bDatasetModifiedPropertiesAll || datasetModifiedProperties.contains(DeltaAnalysisScope.ModifiableProperty.DESCRIPTION)) {
                datasetNLPInfo.setDescription(dsInfo.getDescription());
            }
            if (bDatasetModifiedPropertiesAll || datasetModifiedProperties.contains(DeltaAnalysisScope.ModifiableProperty.COMMENT)) {
                datasetNLPInfo.setComment(dsInfo.getComment());
            }
        }
        Map columnPropertiesDelta = deltaAnalysisScope.getColumnPropertiesDelta();
        if (deltaAnalysisScope.getScopedColumns() == DeltaAnalysisScope.ScopedColumns.NONE) {
            return dsInfo;
        }
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dsInfo).forEach(colInfo -> {
            NLPInfo colNLPInfo = new NLPInfo();
            Set modifiedProperties = columnPropertiesDelta.getOrDefault(colInfo.getIdForExpression(), null);
            if (modifiedProperties == null) {
                return;
            }
            boolean bModifiedPropertiesAll = modifiedProperties.contains(DeltaAnalysisScope.ModifiableProperty.ALL);
            if (bModifiedPropertiesAll || modifiedProperties.contains(DeltaAnalysisScope.ModifiableProperty.NAME)) {
                colNLPInfo.setName(colInfo.getName());
            }
            if (bModifiedPropertiesAll || modifiedProperties.contains(DeltaAnalysisScope.ModifiableProperty.DESCRIPTION)) {
                colNLPInfo.setDescription(colInfo.getDescription());
            }
            if (bModifiedPropertiesAll || modifiedProperties.contains(DeltaAnalysisScope.ModifiableProperty.COMMENT)) {
                colNLPInfo.setComment(colInfo.getComment());
            }
            columnsMap.put(colInfo.getId(), colNLPInfo);
        });
        return dsInfo;
    }

    private DatasetInfo collectAllDatasetAndColumnInfoForTokenizing(NLPInfo datasetNLPInfo, Map<String, NLPInfo> columnsMap, DatasetInfo dsInfo) {
        if (dsInfo.getLabel() == null && dsInfo.getName() != null) {
            datasetNLPInfo.setName(dsInfo.getName());
        }
        if (dsInfo.getDescriptionLabel() == null && dsInfo.getDescription() != null) {
            datasetNLPInfo.setDescription(dsInfo.getDescription());
        }
        if (dsInfo.getCommentLabel() == null && dsInfo.getComment() != null) {
            datasetNLPInfo.setComment(dsInfo.getComment());
        }
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dsInfo).forEach(colInfo -> {
            NLPInfo colNLPInfo = new NLPInfo();
            if (colInfo.getLabel() == null && colInfo.getName() != null) {
                colNLPInfo.setName(colInfo.getName());
            }
            if (colInfo.getDescriptionLabel() == null && colInfo.getDescription() != null) {
                colNLPInfo.setDescription(colInfo.getDescription());
            }
            if (colInfo.getCommentLabel() == null && colInfo.getComment() != null) {
                colNLPInfo.setComment(colInfo.getComment());
            }
            columnsMap.put(colInfo.getId(), colNLPInfo);
        });
        return dsInfo;
    }

    private TextInfo describe(RequestContext rc, String fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        List labels = this.nlp.describeText(rc, new String[]{fieldValue});
        if (!labels.isEmpty()) {
            return (TextInfo)labels.get(0);
        }
        return null;
    }

    private static class DescribedNLPInfo {
        private final TextInfo label;
        private final TextInfo descriptionLabel;
        private final TextInfo commentLabel;

        public DescribedNLPInfo(TextInfo label, TextInfo descriptionLabel, TextInfo commentLabel) {
            this.label = label;
            this.descriptionLabel = descriptionLabel;
            this.commentLabel = commentLabel;
        }

        public TextInfo getLabel() {
            return this.label;
        }

        public TextInfo getDescriptionLabel() {
            return this.descriptionLabel;
        }

        public TextInfo getCommentLabel() {
            return this.commentLabel;
        }
    }

    private static class NLPInfo {
        private String name;
        private String description;
        private String comment;

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

