/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.mq;

import com.ibm.smarts.common.mq.SmartsModuleConsumer;
import com.ibm.smarts.common.mq.SmartsModuleStartConsumer;
import com.ibm.smarts.common.mq.SmartsModuleTask;
import com.ibm.smarts.common.mq.TaskAlreadyExistsException;
import com.ibm.smarts.common.mq.function.SmartsModuleFunction;
import com.ibm.smarts.common.mq.function.SmartsModuleMultiQueueFunction;
import com.ibm.smarts.common.mq.message.SmartsModuleMessage;
import com.ibm.smarts.common.mq.message.SmartsModuleMultiMessage;
import com.ibm.smarts.common.mq.progress.SmartsModuleProgressUtil;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.mq.ExchangeId;
import com.ibm.smarts.core.mq.MessageProducerProvider;
import com.ibm.smarts.core.mq.MessageQueueingSystem;
import com.ibm.smarts.core.mq.QueueId;
import com.ibm.smarts.core.mq.TypedMessageConsumer;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.store.api.multirec.MRTRecord;
import com.ibm.smarts.store.api.multirec.MultiRecordTrigger;
import com.ibm.smarts.store.api.provider.IMRTStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsModuleMessageGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModuleMessageGroup.class);
    public static final String SMARTS_MODULE_START_QUEUE_NAME = "smartsmodule.start";
    public static final ExchangeId SMARTS_MODULE_START_EXCHANGE = new ExchangeId("smartsmodule.fanout.start");
    public static final QueueId DEFAULT_SMARTS_MODULE_START_QUEUE = new QueueId(SMARTS_MODULE_START_EXCHANGE, "smartsmodule.start");
    public static final String SMARTS_MODULE_TASK_DONE_QUEUE_NAME = "smartsmodule.done.task";
    public static final ExchangeId SMARTS_MODULE_TASK_DONE_EXCHANGE = new ExchangeId("smartsmodule.fanout.done.task");
    public static final QueueId DEFAULT_SMARTS_MODULE_TASK_DONE_QUEUE = new QueueId(SMARTS_MODULE_TASK_DONE_EXCHANGE, "smartsmodule.done.task");
    public static final String SMARTS_MODULE_DONE_QUEUE_NAME = "smartsmodule.done";
    public static final ExchangeId SMARTS_MODULE_DONE_EXCHANGE = new ExchangeId("smartsmodule.fanout.done");
    public static final QueueId DEFAULT_SMARTS_MODULE_DONE_QUEUE = new QueueId(SMARTS_MODULE_DONE_EXCHANGE, "smartsmodule.done");
    public static final String COLUMN_NAME_EXCHANGE_NAME = "smartsmodule.fanout.column.name";
    public static final ExchangeId COLUMN_NAME_EXCHANGE = new ExchangeId("smartsmodule.fanout.column.name");
    public static final QueueId DEFAULT_COLUMN_NAME_QUEUE = new QueueId(COLUMN_NAME_EXCHANGE, "smartsmodule.default.column.name");
    public static final String COLUMN_TOKEN_EXCHANGE_NAME = "smartsmodule.fanout.column.token";
    public static final ExchangeId COLUMN_TOKEN_EXCHANGE = new ExchangeId("smartsmodule.fanout.column.token");
    public static final QueueId DEFAULT_COLUMN_TOKEN_QUEUE = new QueueId(COLUMN_TOKEN_EXCHANGE, "smartsmodule.default.column.token");
    public static final String COLUMN_SAMPLES_EXCHANGE_NAME = "smartsmodule.fanout.column.samples";
    public static final ExchangeId COLUMN_SAMPLES_EXCHANGE = new ExchangeId("smartsmodule.fanout.column.samples");
    public static final QueueId DEFAULT_COLUMN_SAMPLES_QUEUE = new QueueId(COLUMN_SAMPLES_EXCHANGE, "smartsmodule.default.column.samples");
    public static final String COLUMN_PREDICT_EXCHANGE_NAME = "smartsmodule.fanout.column.predict";
    public static final ExchangeId COLUMN_PREDICT_EXCHANGE = new ExchangeId("smartsmodule.fanout.column.predict");
    public static final QueueId DEFAULT_COLUMN_PREDICT_QUEUE = new QueueId(COLUMN_PREDICT_EXCHANGE, "smartsmodule.default.column.predict");
    public static final String COLUMN_CONCEPT_EXCHANGE_NAME = "smartsmodule.fanout.column.concept";
    public static final ExchangeId COLUMN_CONCEPT_EXCHANGE = new ExchangeId("smartsmodule.fanout.column.concept");
    public static final QueueId DEFAULT_COLUMN_CONCEPT_QUEUE = new QueueId(COLUMN_CONCEPT_EXCHANGE, "smartsmodule.default.column.concept");
    public static final String SMARTS_MODULE_PUBLISH_EXCHANGE_NAME = "smartsmodule.fanout.publish";
    public static final ExchangeId SMARTS_MODULE_PUBLISH_EXCHANGE = new ExchangeId("smartsmodule.fanout.publish");
    public static final QueueId DEFAULT_SMARTS_MODULE_PUBLISH_QUEUE = new QueueId(SMARTS_MODULE_PUBLISH_EXCHANGE, "smartsmodule.default.publish");
    public static final String SMARTS_MODULE_INIT_PUBLISH_EXCHANGE_NAME = "smartsmodule.fanout.initpublish";
    public static final ExchangeId SMARTS_MODULE_INIT_PUBLISH_EXCHANGE = new ExchangeId("smartsmodule.fanout.initpublish");
    public static final QueueId DEFAULT_SMARTS_MODULE_INIT_PUBLISH_QUEUE = new QueueId(SMARTS_MODULE_INIT_PUBLISH_EXCHANGE, "smartsmodule.default.initpublish");
    private static final UUID MESSAGE_GROUP_CONTEXT_UUID = UUID.fromString("df64ca96-9003-4e1b-bd84-cf9f7284363f");
    public static final RequestContext MESSAGE_GROUP_CONTEXT = new RequestContext(MESSAGE_GROUP_CONTEXT_UUID, Locale.ENGLISH, Locale.ENGLISH, null, null, false);
    private static final String TASK_RECORD_TYPE = "smarts.message.group.tasks";
    private static final String TASK_RECORD_KEY = "smarts.module";
    public static final String START_TASK_ID = "smarts.smartmodule.start";
    public static final String START_TASK_NAME = "Start";
    public static final String START_TASK_DESCRIPTION = "Start building the smart metadata.";
    private final MessageQueueingSystem messageSystem;
    private final IStoreProvider storeProvider;
    private static final Object INIT_LOCK = new Object();

    public SmartsModuleMessageGroup(IStoreProvider storeProvider, MessageQueueingSystem messageSystem) {
        this.storeProvider = storeProvider;
        this.messageSystem = messageSystem;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = INIT_LOCK;
        synchronized (object) {
            boolean missingStartTask = SmartsModuleMessageGroup.getSmartsModuleTasks(this.storeProvider).stream().noneMatch(task -> START_TASK_ID.equals(task.id));
            if (missingStartTask) {
                this.messageSystem.setConsumer(DEFAULT_SMARTS_MODULE_START_QUEUE, (TypedMessageConsumer)new SmartsModuleStartConsumer());
                this.registerStartTask();
            }
        }
    }

    private void registerStartTask() {
        SmartsModuleTask startTask = new SmartsModuleTask(true, START_TASK_ID, START_TASK_NAME, START_TASK_DESCRIPTION, SmartsModuleTask.Scope.DATASET, Collections.emptyList(), COLUMN_NAME_EXCHANGE_NAME);
        this.register(startTask, null);
    }

    public static QueueId defaultQueueFor(String exchange) {
        QueueId result;
        switch (exchange) {
            case "smartsmodule.fanout.initpublish": {
                result = DEFAULT_SMARTS_MODULE_INIT_PUBLISH_QUEUE;
                break;
            }
            case "smartsmodule.fanout.column.name": {
                result = DEFAULT_COLUMN_NAME_QUEUE;
                break;
            }
            case "smartsmodule.fanout.column.token": {
                result = DEFAULT_COLUMN_TOKEN_QUEUE;
                break;
            }
            case "smartsmodule.fanout.column.samples": {
                result = DEFAULT_COLUMN_SAMPLES_QUEUE;
                break;
            }
            case "smartsmodule.fanout.column.predict": {
                result = DEFAULT_COLUMN_PREDICT_QUEUE;
                break;
            }
            case "smartsmodule.fanout.column.concept": {
                result = DEFAULT_COLUMN_CONCEPT_QUEUE;
                break;
            }
            case "smartsmodule.fanout.publish": {
                result = DEFAULT_SMARTS_MODULE_PUBLISH_QUEUE;
                break;
            }
            default: {
                throw new InternalException("unknown exchange " + exchange, new Object[0]);
            }
        }
        return result;
    }

    public static Class<? extends SmartsModuleMessage> messageTypeFor(String exchange) {
        Class<SmartsModuleMessage> result;
        switch (exchange) {
            case "smartsmodule.fanout.initpublish": {
                result = SmartsModuleMessage.class;
                break;
            }
            case "smartsmodule.fanout.column.name": {
                result = SmartsModuleMessage.class;
                break;
            }
            case "smartsmodule.fanout.column.token": {
                result = SmartsModuleMessage.class;
                break;
            }
            case "smartsmodule.fanout.column.samples": {
                result = SmartsModuleMessage.class;
                break;
            }
            case "smartsmodule.fanout.column.predict": {
                result = SmartsModuleMessage.class;
                break;
            }
            case "smartsmodule.fanout.column.concept": {
                result = SmartsModuleMessage.class;
                break;
            }
            case "smartsmodule.fanout.publish": {
                result = SmartsModuleMessage.class;
                break;
            }
            default: {
                throw new InternalException("unknown exchange " + exchange, new Object[0]);
            }
        }
        return result;
    }

    public static TypedMessageConsumer<?> multiQueueConsumerFor(String exchange, IStoreProvider storeProvider, SmartsModuleTask task, SmartsModuleFunction<SmartsModuleMultiMessage> function) {
        final SmartsModuleMultiQueueFunction multiFunction = new SmartsModuleMultiQueueFunction(storeProvider, task, function);
        switch (exchange) {
            case "smartsmodule.fanout.initpublish": {
                return new TypedMessageConsumer<SmartsModuleMessage>(){

                    public void receiveMessage(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
                        multiFunction.apply(rc, producerProvider, message);
                    }

                    public Class<SmartsModuleMessage> getItemClass() {
                        return SmartsModuleMessage.class;
                    }
                };
            }
            case "smartsmodule.fanout.column.name": {
                return new TypedMessageConsumer<SmartsModuleMessage>(){

                    public void receiveMessage(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
                        multiFunction.apply(rc, producerProvider, message);
                    }

                    public Class<SmartsModuleMessage> getItemClass() {
                        return SmartsModuleMessage.class;
                    }
                };
            }
            case "smartsmodule.fanout.column.token": {
                return new TypedMessageConsumer<SmartsModuleMessage>(){

                    public void receiveMessage(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
                        multiFunction.apply(rc, producerProvider, message);
                    }

                    public Class<SmartsModuleMessage> getItemClass() {
                        return SmartsModuleMessage.class;
                    }
                };
            }
            case "smartsmodule.fanout.column.samples": {
                return new TypedMessageConsumer<SmartsModuleMessage>(){

                    public void receiveMessage(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
                        multiFunction.apply(rc, producerProvider, message);
                    }

                    public Class<SmartsModuleMessage> getItemClass() {
                        return SmartsModuleMessage.class;
                    }
                };
            }
            case "smartsmodule.fanout.column.predict": {
                return new TypedMessageConsumer<SmartsModuleMessage>(){

                    public void receiveMessage(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
                        multiFunction.apply(rc, producerProvider, message);
                    }

                    public Class<SmartsModuleMessage> getItemClass() {
                        return SmartsModuleMessage.class;
                    }
                };
            }
            case "smartsmodule.fanout.column.concept": {
                return new TypedMessageConsumer<SmartsModuleMessage>(){

                    public void receiveMessage(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
                        multiFunction.apply(rc, producerProvider, message);
                    }

                    public Class<SmartsModuleMessage> getItemClass() {
                        return SmartsModuleMessage.class;
                    }
                };
            }
            case "smartsmodule.fanout.publish": {
                return new TypedMessageConsumer<SmartsModuleMessage>(){

                    public void receiveMessage(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
                        multiFunction.apply(rc, producerProvider, message);
                    }

                    public Class<SmartsModuleMessage> getItemClass() {
                        return SmartsModuleMessage.class;
                    }
                };
            }
        }
        throw new InternalException("unknown exchange " + exchange, new Object[0]);
    }

    public static SmartsModuleMessage messageFor(String exchange, String smartsModuleId, String datasetId, String resourceURI) {
        switch (exchange) {
            case "smartsmodule.fanout.initpublish": {
                return new SmartsModuleMessage(smartsModuleId, datasetId, resourceURI);
            }
            case "smartsmodule.fanout.column.name": {
                return new SmartsModuleMessage(smartsModuleId, datasetId, resourceURI);
            }
            case "smartsmodule.fanout.column.token": {
                return new SmartsModuleMessage(smartsModuleId, datasetId, resourceURI);
            }
            case "smartsmodule.fanout.column.samples": {
                return new SmartsModuleMessage(smartsModuleId, datasetId, resourceURI);
            }
            case "smartsmodule.fanout.column.predict": {
                return new SmartsModuleMessage(smartsModuleId, datasetId, resourceURI);
            }
            case "smartsmodule.fanout.column.concept": {
                return new SmartsModuleMessage(smartsModuleId, datasetId, resourceURI);
            }
            case "smartsmodule.fanout.publish": {
                return new SmartsModuleMessage(smartsModuleId, datasetId, resourceURI);
            }
        }
        throw new InternalException("unknown exchange " + exchange, new Object[0]);
    }

    public static List<SmartsModuleTask> getSmartsModuleTasks(IStoreProvider storeProvider) {
        ArrayList<SmartsModuleTask> result = new ArrayList<SmartsModuleTask>();
        String taskRecordId = MultiRecordTrigger.getRecordId((String)TASK_RECORD_TYPE, (String)TASK_RECORD_KEY);
        IMRTStore store = storeProvider.getMRTStore();
        MRTRecord record = store.getById(taskRecordId);
        if (record != null) {
            record.records.forEach(json -> {
                SmartsModuleTask rec = (SmartsModuleTask)JsonParserHelper.fromJson((String)json, SmartsModuleTask.class);
                result.add(rec);
            });
        }
        return result;
    }

    public <T extends SmartsModuleMessage> void register(SmartsModuleTask task, SmartsModuleFunction<T> function) {
        this.checkUnique(task);
        if (task.incomingExchanges.size() == 1) {
            ExchangeId exchange = new ExchangeId((String)task.incomingExchanges.get(0));
            SmartsModuleConsumer<T> consumer = new SmartsModuleConsumer<T>(task, function);
            this.messageSystem.setConsumer(new QueueId(exchange, task.id), consumer);
        } else {
            task.incomingExchanges.forEach(e -> {
                TypedMessageConsumer<?> consumer = SmartsModuleMessageGroup.multiQueueConsumerFor(e, this.storeProvider, task, function);
                this.messageSystem.setConsumer(new QueueId(new ExchangeId(e), task.id), consumer);
            });
        }
        this.storeSmartsModuleTask(task);
        SmartsModuleProgressUtil.trackProgressForTask(this.storeProvider, this.messageSystem, task);
        LOGGER.trace("registered task " + task.id);
    }

    public static List<String> findUnregisteredTasks(IStoreProvider storeProvider, String ... taskIds) {
        ArrayList<String> result = new ArrayList<String>();
        String taskRecordId = MultiRecordTrigger.getRecordId((String)TASK_RECORD_TYPE, (String)TASK_RECORD_KEY);
        IMRTStore store = storeProvider.getMRTStore();
        MRTRecord taskRecord = store.getById(taskRecordId);
        ArrayList registeredIds = new ArrayList();
        if (taskRecord != null) {
            taskRecord.records.forEach(json -> {
                SmartsModuleTask registered = (SmartsModuleTask)JsonParserHelper.fromJson((String)json, SmartsModuleTask.class);
                registeredIds.add(registered.id);
            });
        }
        for (String taskId : taskIds) {
            if (registeredIds.contains(taskId)) continue;
            result.add(taskId);
        }
        return result;
    }

    private void checkUnique(SmartsModuleTask task) {
        String taskRecordId = MultiRecordTrigger.getRecordId((String)TASK_RECORD_TYPE, (String)TASK_RECORD_KEY);
        IMRTStore store = this.storeProvider.getMRTStore();
        MRTRecord taskRecord = store.getById(taskRecordId);
        if (taskRecord != null) {
            taskRecord.records.forEach(json -> {
                SmartsModuleTask registered = (SmartsModuleTask)JsonParserHelper.fromJson((String)json, SmartsModuleTask.class);
                if (registered.id.equals(task.id)) {
                    throw new TaskAlreadyExistsException(task.id, new Object[0]);
                }
            });
        }
    }

    private void storeSmartsModuleTask(SmartsModuleTask task) {
        String taskRecordId = MultiRecordTrigger.getRecordId((String)TASK_RECORD_TYPE, (String)TASK_RECORD_KEY);
        IMRTStore store = this.storeProvider.getMRTStore();
        store.createOrApply(taskRecordId, tasksIn -> {
            MRTRecord taskRecord = tasksIn;
            if (taskRecord == null) {
                taskRecord = new MRTRecord();
                taskRecord.type = TASK_RECORD_TYPE;
                taskRecord.key = TASK_RECORD_KEY;
                taskRecord.records = new ArrayList();
            }
            String taskJson = JsonParserHelper.toJson((Object)task);
            taskRecord.records.add(taskJson);
            return taskRecord;
        });
    }
}

