/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.provider;

import com.ibm.smarts.common.provider.IDistinctValueData;
import com.ibm.smarts.common.provider.IValueIterator;
import com.ibm.smarts.model.dataset.DatasetDataItem;
import com.ibm.smarts.model.dataset.DatasetDataResult;
import com.ibm.smarts.model.dataset.DatasetItem;
import com.ibm.smarts.model.dataset.DatasetObject;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DistinctValueData
implements IDistinctValueData {
    private List<Value> dataValues = new ArrayList<Value>();

    @Override
    public long numDistintValues() {
        return this.dataValues.size();
    }

    @Override
    public IValueIterator valueIterator() {
        return new ValueIterator(this.dataValues);
    }

    public static IDistinctValueData from(DatasetDataResult dataResults) {
        DistinctValueData ret = new DistinctValueData();
        for (DatasetDataItem data : dataResults.dataItems) {
            if (data.items == null) continue;
            for (DatasetItem item : data.items) {
                if (item == null || item.tabular == null || item.tabular.size() <= 0) continue;
                Object element = ((DatasetObject)item.tabular.get((int)0)).display;
                if (element != null) {
                    Value value = ValueFactory.create((Object)element);
                    ret.dataValues.add(value);
                    continue;
                }
                Object useElem = ((DatasetObject)item.tabular.get((int)0)).use;
                if (!(useElem instanceof Integer)) continue;
                Value value = ValueFactory.create((Object)useElem);
                ret.dataValues.add(value);
            }
        }
        return ret;
    }

    private class ValueIterator
    implements IValueIterator {
        private Iterator<Value> itr;
        private final List<Value> values;

        private ValueIterator(List<Value> values) {
            this.itr = values.iterator();
            this.values = values;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Value next() {
            return this.itr.next();
        }

        @Override
        public void reset() {
            this.itr = this.values.iterator();
        }

        @Override
        public void close() {
        }
    }
}

