/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.framework;

import java.util.ArrayList;
import java.util.List;
import simplenlg.framework.DocumentCategory;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.NLGElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentElement
extends NLGElement {
    private static final String FEATURE_TITLE = "textTitle";
    private static final String FEATURE_COMPONENTS = "textComponents";

    public DocumentElement() {
    }

    public DocumentElement(DocumentCategory category, String textTitle) {
        this.setCategory(category);
        this.setTitle(textTitle);
    }

    public void setTitle(String textTitle) {
        this.setFeature(FEATURE_TITLE, textTitle);
    }

    public String getTitle() {
        return this.getFeatureAsString(FEATURE_TITLE);
    }

    public List<NLGElement> getComponents() {
        return this.getFeatureAsElementList(FEATURE_COMPONENTS);
    }

    public void addComponent(NLGElement element) {
        if (element != null) {
            ElementCategory thisCategory = this.getCategory();
            ElementCategory category = element.getCategory();
            if (category != null && thisCategory instanceof DocumentCategory) {
                if (((DocumentCategory)thisCategory).hasSubPart(category)) {
                    this.addElementToComponents(element);
                } else {
                    NLGElement promotedElement = this.promote(element);
                    if (promotedElement != null) {
                        this.addElementToComponents(promotedElement);
                    } else {
                        this.addElementToComponents(element);
                    }
                }
            } else {
                this.addElementToComponents(element);
            }
        }
    }

    private void addElementToComponents(NLGElement element) {
        List<NLGElement> components = this.getComponents();
        components.add(element);
        element.setParent(this);
        this.setComponents(components);
    }

    private NLGElement promote(NLGElement element) {
        if (((DocumentCategory)this.getCategory()).hasSubPart(element.getCategory())) {
            return element;
        }
        if (!(element instanceof DocumentElement)) {
            DocumentElement sentence = new DocumentElement(DocumentCategory.SENTENCE, null);
            sentence.addElementToComponents(element);
            return this.promote(sentence);
        }
        if (element.getCategory() == DocumentCategory.SENTENCE) {
            DocumentElement paragraph = new DocumentElement(DocumentCategory.PARAGRAPH, null);
            paragraph.addElementToComponents(element);
            return this.promote(paragraph);
        }
        return null;
    }

    public void addComponents(List<?> textComponents) {
        if (textComponents != null) {
            ElementCategory thisCategory = this.getCategory();
            ArrayList<NLGElement> elementsToAdd = new ArrayList<NLGElement>();
            ElementCategory category = null;
            for (Object eachElement : textComponents) {
                if (!(eachElement instanceof NLGElement) || (category = ((NLGElement)eachElement).getCategory()) == null || !(thisCategory instanceof DocumentCategory) || !((DocumentCategory)thisCategory).hasSubPart(category)) continue;
                elementsToAdd.add((NLGElement)eachElement);
                ((NLGElement)eachElement).setParent(this);
            }
            if (elementsToAdd.size() > 0) {
                List<NLGElement> components = this.getComponents();
                if (components == null) {
                    components = new ArrayList<NLGElement>();
                }
                components.addAll(elementsToAdd);
                this.setFeature(FEATURE_COMPONENTS, components);
            }
        }
    }

    public boolean removeComponent(NLGElement textComponent) {
        List<NLGElement> components;
        boolean removed = false;
        if (textComponent != null && (components = this.getComponents()) != null) {
            removed = components.remove(textComponent);
        }
        return removed;
    }

    public void clearComponents() {
        List<NLGElement> components = this.getComponents();
        if (components != null) {
            components.clear();
        }
    }

    @Override
    public List<NLGElement> getChildren() {
        return this.getComponents();
    }

    public void setComponents(List<NLGElement> components) {
        this.setFeature(FEATURE_COMPONENTS, components);
    }

    @Override
    public String printTree(String indent) {
        String thisIndent = indent == null ? " |-" : indent + " |-";
        String childIndent = indent == null ? " | " : indent + " | ";
        String lastIndent = indent == null ? " \\-" : indent + " \\-";
        String lastChildIndent = indent == null ? "   " : indent + "   ";
        StringBuffer print = new StringBuffer();
        print.append("DocumentElement: category=").append(this.getCategory().toString());
        String realisation = this.getRealisation();
        if (realisation != null) {
            print.append(" realisation=").append(realisation);
        }
        print.append('\n');
        List<NLGElement> children = this.getChildren();
        int length = children.size() - 1;
        int index = 0;
        if (children.size() > 0) {
            for (index = 0; index < length; ++index) {
                print.append(thisIndent).append(children.get(index).printTree(childIndent));
            }
            print.append(lastIndent).append(children.get(index).printTree(lastChildIndent));
        }
        return print.toString();
    }
}

