/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import simplenlg.features.ClauseStatus;
import simplenlg.features.DiscourseFunction;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.StringElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhraseElement
extends NLGElement {
    public PhraseElement(PhraseCategory newCategory) {
        this.setCategory(newCategory);
        this.setFeature("elided", false);
    }

    @Override
    public List<NLGElement> getChildren() {
        ArrayList<NLGElement> children = new ArrayList<NLGElement>();
        ElementCategory category = this.getCategory();
        NLGElement currentElement = null;
        if (category instanceof PhraseCategory) {
            switch ((PhraseCategory)category) {
                case CLAUSE: {
                    currentElement = this.getFeatureAsElement("cue_phrase");
                    if (currentElement != null) {
                        children.add(currentElement);
                    }
                    children.addAll(this.getFeatureAsElementList("front_modifiers"));
                    children.addAll(this.getFeatureAsElementList("premodifiers"));
                    children.addAll(this.getFeatureAsElementList("subjects"));
                    children.addAll(this.getFeatureAsElementList("verb_phrase"));
                    children.addAll(this.getFeatureAsElementList("complements"));
                    break;
                }
                case NOUN_PHRASE: {
                    currentElement = this.getFeatureAsElement("specifier");
                    if (currentElement != null) {
                        children.add(currentElement);
                    }
                    children.addAll(this.getFeatureAsElementList("premodifiers"));
                    currentElement = this.getHead();
                    if (currentElement != null) {
                        children.add(currentElement);
                    }
                    children.addAll(this.getFeatureAsElementList("complements"));
                    children.addAll(this.getFeatureAsElementList("postmodifiers"));
                    break;
                }
                case VERB_PHRASE: {
                    children.addAll(this.getFeatureAsElementList("premodifiers"));
                    currentElement = this.getHead();
                    if (currentElement != null) {
                        children.add(currentElement);
                    }
                    children.addAll(this.getFeatureAsElementList("complements"));
                    children.addAll(this.getFeatureAsElementList("postmodifiers"));
                    break;
                }
                case CANNED_TEXT: {
                    break;
                }
                default: {
                    children.addAll(this.getFeatureAsElementList("premodifiers"));
                    currentElement = this.getHead();
                    if (currentElement != null) {
                        children.add(currentElement);
                    }
                    children.addAll(this.getFeatureAsElementList("complements"));
                    children.addAll(this.getFeatureAsElementList("postmodifiers"));
                }
            }
        }
        return children;
    }

    public void setHead(Object newHead) {
        if (newHead == null) {
            this.removeFeature("head");
            return;
        }
        NLGElement headElement = newHead instanceof NLGElement ? (NLGElement)newHead : new StringElement(newHead.toString());
        this.setFeature("head", headElement);
    }

    public NLGElement getHead() {
        return this.getFeatureAsElement("head");
    }

    public void addComplement(NLGElement newComplement) {
        List<NLGElement> complements = this.getFeatureAsElementList("complements");
        if (complements == null) {
            complements = new ArrayList<NLGElement>();
        }
        if (!newComplement.hasFeature("discourse_function")) {
            newComplement.setFeature("discourse_function", (Object)DiscourseFunction.OBJECT);
        }
        complements.add(newComplement);
        this.setFeature("complements", complements);
        if (newComplement.isA(PhraseCategory.CLAUSE) || newComplement instanceof CoordinatedPhraseElement) {
            newComplement.setFeature("clause_status", (Object)ClauseStatus.SUBORDINATE);
            if (!newComplement.hasFeature("discourse_function")) {
                newComplement.setFeature("discourse_function", (Object)DiscourseFunction.OBJECT);
            }
        }
    }

    public void setComplement(NLGElement newComplement) {
        DiscourseFunction function = (DiscourseFunction)((Object)newComplement.getFeature("discourse_function"));
        this.removeComplements(function);
        this.addComplement(newComplement);
    }

    private void removeComplements(DiscourseFunction function) {
        List<NLGElement> complements = this.getFeatureAsElementList("complements");
        if (function == null || complements == null) {
            return;
        }
        ArrayList<NLGElement> complementsToRemove = new ArrayList<NLGElement>();
        for (NLGElement complement : complements) {
            if (function != complement.getFeature("discourse_function")) continue;
            complementsToRemove.add(complement);
        }
        if (!complementsToRemove.isEmpty()) {
            complements.removeAll(complementsToRemove);
            this.setFeature("complements", complements);
        }
    }

    public void addComplement(String newComplement) {
        StringElement newElement = new StringElement(newComplement);
        List<NLGElement> complements = this.getFeatureAsElementList("complements");
        if (complements == null) {
            complements = new ArrayList<NLGElement>();
        }
        complements.add(newElement);
        this.setFeature("complements", complements);
    }

    public void setComplement(String newComplement) {
        this.setFeature("complements", null);
        this.addComplement(newComplement);
    }

    public void addPostModifier(NLGElement newPostModifier) {
        List<NLGElement> postModifiers = this.getFeatureAsElementList("postmodifiers");
        if (postModifiers == null) {
            postModifiers = new ArrayList<NLGElement>();
        }
        newPostModifier.setFeature("discourse_function", (Object)DiscourseFunction.POST_MODIFIER);
        postModifiers.add(newPostModifier);
        this.setFeature("postmodifiers", postModifiers);
    }

    public void addPostModifier(String newPostModifier) {
        List<NLGElement> postModifiers = this.getFeatureAsElementList("postmodifiers");
        if (postModifiers == null) {
            postModifiers = new ArrayList<NLGElement>();
        }
        postModifiers.add(new StringElement(newPostModifier));
        this.setFeature("postmodifiers", postModifiers);
    }

    public void setPostModifier(String newPostModifier) {
        this.setFeature("postmodifiers", null);
        this.addPostModifier(newPostModifier);
    }

    public void setPostModifier(NLGElement newPostModifier) {
        this.setFeature("postmodifiers", null);
        this.addPostModifier(newPostModifier);
    }

    public void addFrontModifier(NLGElement newFrontModifier) {
        List<NLGElement> frontModifiers = this.getFeatureAsElementList("front_modifiers");
        if (frontModifiers == null) {
            frontModifiers = new ArrayList<NLGElement>();
        }
        frontModifiers.add(newFrontModifier);
        this.setFeature("front_modifiers", frontModifiers);
    }

    public void addFrontModifier(String newFrontModifier) {
        List<NLGElement> frontModifiers = this.getFeatureAsElementList("front_modifiers");
        if (frontModifiers == null) {
            frontModifiers = new ArrayList<NLGElement>();
        }
        frontModifiers.add(new StringElement(newFrontModifier));
        this.setFeature("front_modifiers", frontModifiers);
    }

    public void setFrontModifier(String newFrontModifier) {
        this.setFeature("front_modifiers", null);
        this.addFrontModifier(newFrontModifier);
    }

    public void setFrontModifier(NLGElement newFrontModifier) {
        this.setFeature("front_modifiers", null);
        this.addFrontModifier(newFrontModifier);
    }

    public void addPreModifier(NLGElement newPreModifier) {
        List<NLGElement> preModifiers = this.getFeatureAsElementList("premodifiers");
        if (preModifiers == null) {
            preModifiers = new ArrayList<NLGElement>();
        }
        preModifiers.add(newPreModifier);
        this.setFeature("premodifiers", preModifiers);
    }

    public void addPreModifier(String newPreModifier) {
        this.addPreModifier(new StringElement(newPreModifier));
    }

    public void setPreModifier(String newPreModifier) {
        this.setFeature("premodifiers", null);
        this.addPreModifier(newPreModifier);
    }

    public void setPreModifier(NLGElement newPreModifier) {
        this.setFeature("premodifiers", null);
        this.addPreModifier(newPreModifier);
    }

    public void addModifier(Object modifier) {
        if (modifier == null) {
            return;
        }
        if (modifier instanceof NLGElement) {
            this.addPreModifier((NLGElement)modifier);
        } else {
            this.addPreModifier((String)modifier);
        }
    }

    public List<NLGElement> getPreModifiers() {
        return this.getFeatureAsElementList("premodifiers");
    }

    public List<NLGElement> getPostModifiers() {
        return this.getFeatureAsElementList("postmodifiers");
    }

    public List<NLGElement> getFrontModifiers() {
        return this.getFeatureAsElementList("front_modifiers");
    }

    @Override
    public String printTree(String indent) {
        String thisIndent = indent == null ? " |-" : indent + " |-";
        String childIndent = indent == null ? " | " : indent + " | ";
        String lastIndent = indent == null ? " \\-" : indent + " \\-";
        String lastChildIndent = indent == null ? "   " : indent + "   ";
        StringBuffer print = new StringBuffer();
        print.append("PhraseElement: category=").append(this.getCategory().toString()).append(", features={");
        Map<String, Object> features = this.getAllFeatures();
        for (String eachFeature : features.keySet()) {
            print.append(eachFeature).append('=').append(features.get(eachFeature).toString()).append(' ');
        }
        print.append("}\n");
        List<NLGElement> children = this.getChildren();
        int length = children.size() - 1;
        int index = 0;
        for (index = 0; index < length; ++index) {
            print.append(thisIndent).append(children.get(index).printTree(childIndent));
        }
        if (length >= 0) {
            print.append(lastIndent).append(children.get(length).printTree(lastChildIndent));
        }
        return print.toString();
    }

    public void clearComplements() {
        this.removeFeature("complements");
    }

    @Deprecated
    public void setDeterminer(Object newDeterminer) {
        NLGFactory factory = new NLGFactory();
        NLGElement determinerElement = factory.createWord(newDeterminer, LexicalCategory.DETERMINER);
        if (determinerElement != null) {
            determinerElement.setFeature("discourse_function", (Object)DiscourseFunction.SPECIFIER);
            this.setFeature("specifier", determinerElement);
            determinerElement.setParent(this);
        }
    }
}

