/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon;

import java.util.List;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.WordElement;
import simplenlg.lexicon.XMLLexicon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Lexicon {
    public static Lexicon getDefaultLexicon() {
        return new XMLLexicon();
    }

    protected WordElement createWord(String baseForm, LexicalCategory category) {
        return new WordElement(baseForm, category);
    }

    protected WordElement createWord(String baseForm) {
        return new WordElement(baseForm);
    }

    public WordElement lookupWord(String baseForm, LexicalCategory category) {
        if (this.hasWord(baseForm, category)) {
            return this.getWord(baseForm, category);
        }
        if (this.hasWordFromVariant(baseForm, category)) {
            return this.getWordFromVariant(baseForm, category);
        }
        if (this.hasWordByID(baseForm)) {
            return this.getWordByID(baseForm);
        }
        return this.createWord(baseForm, category);
    }

    public WordElement lookupWord(String baseForm) {
        return this.lookupWord(baseForm, LexicalCategory.ANY);
    }

    public abstract List<WordElement> getWords(String var1, LexicalCategory var2);

    public WordElement getWord(String baseForm, LexicalCategory category) {
        List<WordElement> wordElements = this.getWords(baseForm, category);
        if (wordElements.isEmpty()) {
            return this.createWord(baseForm, category);
        }
        return this.selectMatchingWord(wordElements, baseForm);
    }

    private WordElement selectMatchingWord(List<WordElement> wordElements, String baseForm) {
        if (wordElements == null || wordElements.isEmpty()) {
            return this.createWord(baseForm);
        }
        for (WordElement wordElement : wordElements) {
            if (!wordElement.getBaseForm().equals(baseForm)) continue;
            return wordElement;
        }
        if (wordElements.get(0).getBaseForm().equalsIgnoreCase(baseForm)) {
            return this.createWord(baseForm, LexicalCategory.ANY);
        }
        return wordElements.get(0);
    }

    public boolean hasWord(String baseForm, LexicalCategory category) {
        return !this.getWords(baseForm, category).isEmpty();
    }

    public List<WordElement> getWords(String baseForm) {
        return this.getWords(baseForm, LexicalCategory.ANY);
    }

    public WordElement getWord(String baseForm) {
        List<WordElement> wordElements = this.getWords(baseForm);
        if (wordElements.isEmpty()) {
            return this.createWord(baseForm);
        }
        return this.selectMatchingWord(wordElements, baseForm);
    }

    public boolean hasWord(String baseForm) {
        return !this.getWords(baseForm).isEmpty();
    }

    public abstract List<WordElement> getWordsByID(String var1);

    public WordElement getWordByID(String id) {
        List<WordElement> wordElements = this.getWordsByID(id);
        if (wordElements.isEmpty()) {
            return this.createWord(id);
        }
        return wordElements.get(0);
    }

    public boolean hasWordByID(String id) {
        return !this.getWordsByID(id).isEmpty();
    }

    public abstract List<WordElement> getWordsFromVariant(String var1, LexicalCategory var2);

    public WordElement getWordFromVariant(String variant, LexicalCategory category) {
        List<WordElement> wordElements = this.getWordsFromVariant(variant, category);
        if (wordElements.isEmpty()) {
            return this.createWord(variant, category);
        }
        return this.selectMatchingWord(wordElements, variant);
    }

    public boolean hasWordFromVariant(String variant, LexicalCategory category) {
        return !this.getWordsFromVariant(variant, category).isEmpty();
    }

    public List<WordElement> getWordsFromVariant(String variant) {
        return this.getWordsFromVariant(variant, LexicalCategory.ANY);
    }

    public WordElement getWordFromVariant(String variant) {
        List<WordElement> wordElements = this.getWordsFromVariant(variant);
        if (wordElements.isEmpty()) {
            return this.createWord(variant);
        }
        return wordElements.get(0);
    }

    public boolean hasWordFromVariant(String variant) {
        return !this.getWordsFromVariant(variant).isEmpty();
    }

    public void close() {
    }
}

