/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.useractions.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import com.ibm.smarts.useractions.actions.UserActionType;
import com.ibm.smarts.useractions.actions.UserLearningDirective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAction.class);
    private UserActionType actionType;
    private JsonNode actionPayload;
    private UserLearningDirective learningDirective;
    private String userId;
    private String augmentations = null;

    @JsonCreator
    public UserAction(@JsonProperty(value="actionType") UserActionType actionType, @JsonProperty(value="actionPayload") JsonNode actionPayload, @JsonProperty(value="learningDirective") UserLearningDirective learningDirective, @JsonProperty(value="userId") String userId, @JsonProperty(value="augmentations") String augmentations) {
        this.actionType = actionType;
        this.actionPayload = actionPayload;
        this.learningDirective = learningDirective;
        this.userId = userId;
        this.augmentations = augmentations;
    }

    public UserActionType getActionType() {
        return this.actionType;
    }

    public JsonNode getActionPayload() {
        return this.actionPayload;
    }

    public UserLearningDirective getLearningDirective() {
        return this.learningDirective;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAugmentations() {
        return this.augmentations;
    }

    public void setAugmentations(String augmentations) {
        this.augmentations = augmentations;
    }

    public static UserAction fromJSON(String str) {
        try {
            return (UserAction)CommonJAXBHelper.unmarshalFromJSON(UserAction.class, (String)str);
        }
        catch (JsonDeserializeException e) {
            LOGGER.error("Error parsing visualization recommender request", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)false);
    }
}

