/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.useractions.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.useractions.actions.IGenericActionHandler;
import com.ibm.smarts.useractions.actions.IGenericUserAction;
import com.ibm.smarts.useractions.actions.UserAction;
import com.ibm.smarts.useractions.actions.VisualizationAction;
import com.ibm.smarts.useractions.actions.VisualizationPayload;
import com.ibm.smarts.visualization.recommender.schema.VisColumn;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualizationActionHandler
implements IGenericActionHandler {
    public static final String MATCH_COLUMN_IDS = "MatchColumnIds";
    public static final String SELECT_CHART_TYPE = "VizType";
    private static final Logger LOGGER = LoggerFactory.getLogger(VisualizationActionHandler.class);

    @Override
    public IGenericUserAction augment(UserAction action, SmartsModule smartsModule) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ArrayList<ColumnInfo> relatedColumns = new ArrayList<ColumnInfo>();
            VisualizationPayload payload = (VisualizationPayload)mapper.convertValue((Object)action.getActionPayload(), VisualizationPayload.class);
            for (int ii = 0; ii < payload.getColumns().size(); ++ii) {
                VisColumn visColumn = payload.getColumns().get(ii);
                for (int jj = 0; jj < visColumn.getId().size(); ++jj) {
                    String id = (String)visColumn.getId().get(jj);
                    int found = relatedColumns.size();
                    smartsModule.getDatasets().forEach(dataset -> {
                        ColumnInfo columnInfo = this.getColumnInfoByIdForExpression((DatasetInfo)dataset, id);
                        if (columnInfo != null) {
                            relatedColumns.add(columnInfo);
                        }
                    });
                    if (found != relatedColumns.size()) continue;
                    LOGGER.warn("Could not find column with id for expression '{}' while augmenting user action for SmartModule {}", (Object)id, (Object)smartsModule.getId());
                }
            }
            String json = JAXBHelper.marshalToJSON(relatedColumns, (boolean)true);
            action.setAugmentations(json);
            return new VisualizationAction(payload, relatedColumns);
        }
        catch (IOException e) {
            return null;
        }
    }

    private ColumnInfo getColumnInfoByIdForExpression(DatasetInfo dataset, String idForExpression) {
        return SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataset).stream().filter(c -> c.getIdForExpression().equals(idForExpression)).findFirst().orElse(null);
    }
}

