/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.useractions.util;

import com.ibm.bi.recommendationmodel.RecommendationModel;
import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.useractions.actions.UserAction;
import com.ibm.smarts.useractions.actions.UserActionType;
import com.ibm.smarts.useractions.actions.UserLearningDirective;
import com.ibm.smarts.useractions.actions.VisualizationAction;
import com.ibm.smarts.useractions.actions.VisualizationActionHandler;
import com.ibm.smarts.visualization.recommender.api.VisRecommenderSupport;
import com.ibm.smarts.visualization.recommender.exceptions.LearningException;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import com.ibm.smarts.visualization.recommender.schema.VisualizationUserActionData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserActionLearning {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisRecommenderSupport.class);
    private VisRecommenderSupport recommender = null;

    public UserActionLearning(VisRecommenderSupport recommender) {
        this.recommender = recommender;
    }

    public void process(RequestContext context, UserAction userAction, SmartsModule smartsModule) {
        if (this.shouldLearn(context) && userAction.getActionType().equals((Object)UserActionType.VISUALIZATION)) {
            this.processVisualization(context, smartsModule, userAction);
        }
    }

    public void processAll(RequestContext context, List<UserAction> actions, SmartsModule smartsModule) {
        if (!this.shouldLearn(context)) {
            return;
        }
        List visualizationUserActionData = actions.stream().filter(userAction -> userAction.getActionType().equals((Object)UserActionType.VISUALIZATION)).filter(userAction -> userAction.getLearningDirective().equals((Object)UserLearningDirective.USE)).map(userAction -> {
            VisualizationAction visualizationAction = (VisualizationAction)new VisualizationActionHandler().augment((UserAction)userAction, smartsModule);
            return new VisualizationUserActionData(visualizationAction.getVisPayload().getChartType(), this.getColumnsById(visualizationAction), this.getBindings(visualizationAction));
        }).collect(Collectors.toList());
        this.recommender.useAll(context, smartsModule, visualizationUserActionData);
    }

    public void purge(RequestContext context, UserActionType learningContextType, String learningType) {
        if (learningContextType.equals((Object)UserActionType.ALL)) {
            this.recommender.purge(context, learningType);
        } else {
            this.recommender.purge(context, learningType);
        }
    }

    private void processVisualization(RequestContext context, SmartsModule smartsModule, UserAction userAction) {
        VisualizationAction visualizationAction = (VisualizationAction)new VisualizationActionHandler().augment(userAction, smartsModule);
        VisualizationUserActionData data = new VisualizationUserActionData(visualizationAction.getVisPayload().getChartType(), this.getColumnsById(visualizationAction), this.getBindings(visualizationAction));
        if (userAction.getLearningDirective().equals((Object)UserLearningDirective.LIKE)) {
            this.recommender.like(context, smartsModule, data);
        } else if (userAction.getLearningDirective().equals((Object)UserLearningDirective.DISLIKE)) {
            this.recommender.dislike(context, smartsModule, data);
        } else if (userAction.getLearningDirective().equals((Object)UserLearningDirective.USE)) {
            this.recommender.use(context, smartsModule, data);
        } else {
            LOGGER.error("Invalid learning directive " + (Object)((Object)userAction.getLearningDirective()));
        }
    }

    public boolean isRecModelAvailable(RequestContext context) {
        RecommendationModel model = null;
        boolean modelPresent = false;
        try {
            model = this.recommender.getOnlineRecommendationModel(context);
        }
        catch (LearningException e) {
            LOGGER.error("Failed to get online recommendation model");
        }
        if (model != null && !model.getCharts().isEmpty()) {
            modelPresent = true;
        }
        return modelPresent;
    }

    private List<String> getColumnsById(VisualizationAction action) {
        ArrayList<String> subsetColumnsById = new ArrayList<String>();
        action.getRelatedColumnInfos().forEach(f -> subsetColumnsById.add(f.getIdForExpression()));
        return subsetColumnsById;
    }

    private List<Binding> getBindings(VisualizationAction action) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        action.getVisPayload().getColumns().forEach(f -> bindings.add(new Binding(f.getId(), f.getSlot())));
        return bindings;
    }

    private SmartsCaClientManager getSmartsCaClientManager(RequestContext requestContext) {
        ObjectCreator clientManagerCreator = (ObjectCreator)requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager");
        return (SmartsCaClientManager)clientManagerCreator.create(requestContext);
    }

    private boolean canLearnCapabilityPresent(RequestContext requestContext) {
        return this.getSmartsCaClientManager(requestContext).getUserProfileServiceClient().canLearnFromUsage();
    }

    private boolean isLearningEnabled(RequestContext requestContext) {
        return this.getSmartsCaClientManager(requestContext).getUserProfileServiceClient().isLearningEnabled();
    }

    private boolean shouldLearn(RequestContext requestContext) {
        return this.canLearnCapabilityPresent(requestContext) && this.isLearningEnabled(requestContext);
    }
}

