/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.storageservice.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    private static boolean isCompressed(String recModel) {
        return !recModel.startsWith("{");
    }

    public static String compressRecModel(String jsonRecModel) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream gzipOS = new GZIPOutputStream(bos);
            gzipOS.write(jsonRecModel.getBytes(StandardCharsets.UTF_8));
            gzipOS.finish();
            return Base64.getEncoder().encodeToString(bos.toByteArray());
        }
        catch (IOException ex) {
            log.error("Unable to compress the recommendation Model." + ex.getMessage());
            return null;
        }
    }

    public static String uncompressRecModel(String compressedRecModel) {
        String jsonRecModel = null;
        try {
            if (compressedRecModel != null && !compressedRecModel.isEmpty() && Utils.isCompressed(compressedRecModel)) {
                byte[] base64 = Base64.getDecoder().decode(compressedRecModel);
                ByteArrayInputStream bis = new ByteArrayInputStream(base64);
                GZIPInputStream gzipIS = new GZIPInputStream(bis);
                jsonRecModel = IOUtils.toString((InputStream)gzipIS, (Charset)StandardCharsets.UTF_8);
            } else {
                jsonRecModel = compressedRecModel;
            }
        }
        catch (IOException e) {
            log.error("Unable to uncompress the Recommendation Model" + e.getMessage());
        }
        return jsonRecModel;
    }
}

