/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core;

import com.ibm.smarts.fields.recommender.core.BaseFieldsAnalysisContext;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersAnalysisContext;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.StatisticType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface AnalysisStep<T> {
    public static final List<StatisticType> CORR_MEASURE = Arrays.asList(StatisticType.ETA, StatisticType.CRAMERS_V, StatisticType.PEARSON);
    public static final String EMPTY_ID = "http://www.ibm.com/ontologies/waca/application#Empty";
    public static final String UNIQUE_ID = "http://www.ibm.com/ontologies/waca/application#UniqueValue";
    public static final String SINGLETON_ID = "http://www.ibm.com/ontologies/waca/application#Singleton";
    public static final String LOWVALUEREPETITION_ID = "http://www.ibm.com/ontologies/waca/application#LowValueRepetition";

    public void execute(@Nonnull T var1);

    default public String getName() {
        return this.getClass().getSimpleName();
    }

    default public String toFieldUID(String fieldID, String tableID) {
        return fieldID + "|" + tableID;
    }

    default public boolean isSemanticEligible(ColumnInfo col) {
        return !this.hasConcept(col, "http://www.ibm.com/ontologies/waca/domain/common#Immutable", false) && !this.hasConcept(col, "http://www.ibm.com/ontologies/waca/application#SubItem", false) && (this.hasConcept(col, "http://www.ibm.com/ontologies/waca/domain/common#Measure", false) || this.hasConcept(col, "http://www.ibm.com/ontologies/waca/domain/common#Mutable", false) && !this.isDegenerate(col));
    }

    default public boolean isDegenerate(ColumnInfo col) {
        return col.getSemanticInfo().getConcepts().stream().anyMatch(c -> UNIQUE_ID.equals(c.getConceptID()) || EMPTY_ID.equals(c.getConceptID()) || SINGLETON_ID.equals(c.getConceptID()));
    }

    default public boolean hasConcept(ColumnInfo col, String aConcept, boolean currentLevel) {
        if (Objects.isNull(col.getSemanticInfo())) {
            return false;
        }
        if (col.getSemanticInfo().getConcepts().stream().anyMatch(c -> c.getConceptID().equals(aConcept))) {
            return true;
        }
        if (currentLevel) {
            return false;
        }
        return col.getSemanticInfo().getConcepts().stream().anyMatch(c -> this.parentHasConcept(ConceptsRegistry.instance().getConcept(c.getConceptID()), aConcept));
    }

    default public boolean hasConcept(ColumnInfo col, String aConcept, boolean currentLevel, float acceptable) {
        if (Objects.isNull(col.getSemanticInfo())) {
            return false;
        }
        if (col.getSemanticInfo().getConcepts().stream().anyMatch(c -> this.acceptableMatch(aConcept, acceptable, c.getConceptID(), c.getConfidence()))) {
            return true;
        }
        if (currentLevel) {
            return false;
        }
        return col.getSemanticInfo().getConcepts().stream().anyMatch(c -> this.parentHasConcept(ConceptsRegistry.instance().getConcept(c.getConceptID()), c.getConfidence(), aConcept, acceptable));
    }

    default public boolean acceptableMatch(String toMatch, float acceptable, String toAccept, float toAcceptConfidence) {
        return toAccept.equals(toMatch) && Float.compare(toAcceptConfidence, acceptable) > 0;
    }

    default public boolean parentHasConcept(Concept c, float cConfidence, String aConcept, float acceptable) {
        if (c.getParents().isEmpty()) {
            return false;
        }
        if (c.getParents().stream().anyMatch(p -> this.acceptableMatch(aConcept, acceptable, p.getIRI(), cConfidence))) {
            return true;
        }
        return c.getParents().stream().anyMatch(p -> this.parentHasConcept((Concept)p, cConfidence, aConcept, acceptable));
    }

    default public DatasetInfo getTargetTable(InfluencersAnalysisContext rfac) {
        return rfac.getSmartsModule().getDatasets().stream().filter(ds -> ds.getId().equals(rfac.getTargetFieldTableID())).findFirst().get();
    }

    default public Map<Pair<String, String>, BivariateStatistics> toMap(List<BivariateStatistics> bv) {
        HashMap<Pair<String, String>, BivariateStatistics> retVal = new HashMap<Pair<String, String>, BivariateStatistics>(bv.size());
        bv.forEach(bvValue -> retVal.put((Pair<String, String>)new Pair((Object)bvValue.getColumn1(), (Object)bvValue.getColumn2()), (BivariateStatistics)bvValue));
        return retVal;
    }

    default public BivariateStatistics getBivariate(Map<Pair<String, String>, BivariateStatistics> bvMap, String field1, String field2) {
        BivariateStatistics bv = null;
        if (bvMap != null && (bv = bvMap.get(new Pair((Object)field1, (Object)field2))) == null) {
            bv = bvMap.get(new Pair((Object)field2, (Object)field1));
        }
        return bv;
    }

    default public Map<Pair<String, String>, BivariateStatistics> getBVMapAndStoreIfAbsent(BaseFieldsAnalysisContext bfac, DatasetInfo targetTable) {
        Map<Pair<String, String>, BivariateStatistics> bvMap = bfac.getBivariateMap(targetTable.getId());
        if (bvMap == null && !targetTable.getBivariateStatistics().isEmpty()) {
            bvMap = this.toMap(targetTable.getBivariateStatistics());
            bfac.cacheBVs(targetTable.getId(), bvMap);
        }
        return bvMap;
    }

    default public boolean hasFieldInBivarite(String fieldID, BivariateStatistics bv) {
        return fieldID.equals(bv.getColumn1()) || fieldID.equals(bv.getColumn2());
    }

    default public boolean valueInRange(BivariateStatistics bv, BaseFieldsAnalysisContext bfac, List<StatisticType> corrMeasure) {
        return bfac.hasNoCorrelationLimit() || this.isWithinCorrelationLimit(bv, bfac, corrMeasure);
    }

    default public boolean isWithinCorrelationLimit(BivariateStatistics bv, BaseFieldsAnalysisContext bfac, List<StatisticType> corrMeasure) {
        if (bv == null) {
            return false;
        }
        return bv.getStatistics().stream().filter(stat -> corrMeasure.contains(stat.getType())).anyMatch(stat -> Double.compare(stat.getValue().doubleValue(), bfac.getCorrelationLowerLimit()) > 0 && Double.compare(stat.getValue().doubleValue(), bfac.getCorrelationUpperLimit()) <= 0);
    }

    default public boolean parentHasConcept(Concept c, String aConcept) {
        if (c == null || c.getParents() == null || c.getParents().isEmpty()) {
            return false;
        }
        if (c.getParents().stream().anyMatch(p -> p.getIRI().equals(aConcept))) {
            return true;
        }
        return c.getParents().stream().anyMatch(p -> this.parentHasConcept((Concept)p, aConcept));
    }

    default public boolean isDegenerated(ConceptInfo c) {
        return UNIQUE_ID.equals(c.getConceptID()) || EMPTY_ID.equals(c.getConceptID()) || SINGLETON_ID.equals(c.getConceptID());
    }
}

