/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.influencers;

import com.ibm.smarts.common.util.SmartsModuleUtil;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.RecommendationStatus;
import com.ibm.smarts.fields.recommender.core.BaseFieldsAnalysisContext;
import com.ibm.smarts.fields.recommender.core.FieldsInputScopeValidation;
import com.ibm.smarts.fields.recommender.core.exceptions.IFRInvalidInputException;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersAnalysisContext;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.InScopeTable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluencersInputScopeValidation
extends FieldsInputScopeValidation<InfluencersAnalysisContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluencersInputScopeValidation.class);

    @Override
    public void execute(@Nonnull InfluencersAnalysisContext rfac) {
        super.execute(rfac);
        if (StringUtils.isBlank((CharSequence)rfac.getTargetFieldID()) || StringUtils.isBlank((CharSequence)rfac.getTargetFieldTableID()) || !this.isTargetFieldValid(rfac)) {
            throw new IFRInvalidInputException(RecommendationStatus.INVALID_TARGET_FIELD);
        }
        this.resolveScope(rfac);
    }

    private void resolveScope(InfluencersAnalysisContext rfac) {
        try {
            if (!rfac.isResolvedJoin()) {
                Object moduleId = rfac.getRequestContext().getAttribute("moduleId");
                if (moduleId != null) {
                    List relatedFields = SmartsModuleUtil.getRelatedFieldsFromJoinGraph((RequestContext)rfac.getRequestContext(), (String)rfac.getTargetFieldTableID(), (String)((String)moduleId));
                    rfac.resolveJoin(rfac.getSmartsModule(), relatedFields);
                } else {
                    LOGGER.warn("Module is missing, so joinable datasets won't be resolved.");
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("unable to get joinable datasets information. use current table only.");
        }
        this.addFieldsFilter(rfac);
    }

    protected void addFieldsFilter(BaseFieldsAnalysisContext rfac) {
        if (rfac.hasScopedFields()) {
            List notjoinable = rfac.getAnalysisScope().getInScopeTables().stream().filter(ist -> !rfac.getJoinableDatasets().contains(ist.getTableID())).flatMap(ist -> Stream.of(ist.getTableID())).collect(Collectors.toList());
            LOGGER.warn("These tables in Analysis Scope are not joinable with the target table: [{}]", notjoinable);
            rfac.getAnalysisScope().getInScopeTables().stream().filter(ist -> rfac.getJoinableDatasets().contains(ist.getTableID())).forEach(ist -> rfac.getScopedFieldIDFilter().addAll(this.getFieldsFilterUID((InScopeTable)ist)));
            LOGGER.info("Fields Filter: [{}]", rfac.getScopedFieldIDFilter());
        }
    }

    private boolean isTargetFieldValid(InfluencersAnalysisContext rfac) {
        Optional<DatasetInfo> ds = rfac.getSmartsModule().getDatasets().stream().filter(table -> table.getId().equals(rfac.getTargetFieldTableID())).findFirst();
        return com.ibm.smarts.schema.util.SmartsModuleUtil.getFlattenedColumns((BaseItemObject)((BaseItemObject)ds.orElseThrow(() -> new IFRInvalidInputException(RecommendationStatus.INVALID_TARGET_FIELD)))).stream().map(BaseObject::getId).anyMatch(fieldID -> fieldID.equals(rfac.getTargetFieldID()));
    }
}

